/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.SlackTerminal;
import com.powsybl.iidm.network.extensions.SlackTerminalAdder;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.TerminalRefXml;
import com.powsybl.iidm.xml.extensions.AbstractVersionableNetworkExtensionXmlSerializer;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

@AutoService(value={ExtensionXmlSerializer.class})
public class SlackTerminalXmlSerializer
extends AbstractVersionableNetworkExtensionXmlSerializer<VoltageLevel, SlackTerminal> {
    public SlackTerminalXmlSerializer() {
        super("slackTerminal", SlackTerminal.class, false, "slt", (Map<IidmXmlVersion, ImmutableSortedSet<String>>)new ImmutableMap.Builder().put((Object)IidmXmlVersion.V_1_3, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"))).put((Object)IidmXmlVersion.V_1_4, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.1"))).put((Object)IidmXmlVersion.V_1_5, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.2"))).put((Object)IidmXmlVersion.V_1_6, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.3"))).put((Object)IidmXmlVersion.V_1_7, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.4"))).put((Object)IidmXmlVersion.V_1_8, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.5"))).put((Object)IidmXmlVersion.V_1_9, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.5"))).put((Object)IidmXmlVersion.V_1_10, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.5"))).put((Object)IidmXmlVersion.V_1_11, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.5"))).build(), (Map<String, String>)new ImmutableMap.Builder().put((Object)"1.0", (Object)"http://www.powsybl.org/schema/iidm/ext/slack_terminal/1_0").put((Object)"1.1", (Object)"http://www.powsybl.org/schema/iidm/ext/slack_terminal/1_1").put((Object)"1.2", (Object)"http://www.powsybl.org/schema/iidm/ext/slack_terminal/1_2").put((Object)"1.3", (Object)"http://www.powsybl.org/schema/iidm/ext/slack_terminal/1_3").put((Object)"1.4", (Object)"http://www.powsybl.org/schema/iidm/ext/slack_terminal/1_4").put((Object)"1.5", (Object)"http://www.powsybl.org/schema/iidm/ext/slack_terminal/1_5").build());
    }

    public InputStream getXsdAsStream() {
        return this.getClass().getResourceAsStream("/xsd/slackTerminal_V1_5.xsd");
    }

    public List<InputStream> getXsdAsStreamList() {
        return ImmutableList.of((Object)this.getClass().getResourceAsStream("/xsd/slackTerminal_V1_0.xsd"), (Object)this.getClass().getResourceAsStream("/xsd/slackTerminal_V1_1.xsd"), (Object)this.getClass().getResourceAsStream("/xsd/slackTerminal_V1_2.xsd"), (Object)this.getClass().getResourceAsStream("/xsd/slackTerminal_V1_3.xsd"), (Object)this.getClass().getResourceAsStream("/xsd/slackTerminal_V1_4.xsd"), (Object)this.getClass().getResourceAsStream("/xsd/slackTerminal_V1_5.xsd"));
    }

    public void write(SlackTerminal slackTerminal, XmlWriterContext context) throws XMLStreamException {
        Terminal terminal = slackTerminal.getTerminal();
        if (terminal != null) {
            TerminalRefXml.writeTerminalRefAttribute(slackTerminal.getTerminal(), (NetworkXmlWriterContext)context);
        }
    }

    public SlackTerminal read(VoltageLevel voltageLevel, XmlReaderContext context) {
        NetworkXmlReaderContext networkContext = (NetworkXmlReaderContext)context;
        String id = networkContext.getAnonymizer().deanonymizeString(networkContext.getReader().getAttributeValue(null, "id"));
        String side = networkContext.getReader().getAttributeValue(null, "side");
        Terminal terminal = TerminalRefXml.resolve(id, side, voltageLevel.getNetwork());
        return (SlackTerminal)((SlackTerminalAdder)voltageLevel.newExtension(SlackTerminalAdder.class)).withTerminal(terminal).add();
    }

    public boolean isSerializable(SlackTerminal slackTerminal) {
        return slackTerminal.getTerminal() != null;
    }
}

