/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.extensions.StandbyAutomaton;
import com.powsybl.iidm.network.extensions.StandbyAutomatonAdder;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class StandbyAutomatonXmlSerializer
extends AbstractExtensionXmlSerializer<StaticVarCompensator, StandbyAutomaton> {
    public StandbyAutomatonXmlSerializer() {
        super("standbyAutomaton", "network", StandbyAutomaton.class, false, "standbyAutomaton.xsd", "http://www.itesla_project.eu/schema/iidm/ext/standby_automaton/1_0", "sa");
    }

    public void write(StandbyAutomaton standbyAutomaton, XmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeDouble((String)"b0", (double)standbyAutomaton.getB0(), (XMLStreamWriter)context.getWriter());
        context.getWriter().writeAttribute("standby", Boolean.toString(standbyAutomaton.isStandby()));
        XmlUtil.writeDouble((String)"lowVoltageSetPoint", (double)standbyAutomaton.getLowVoltageSetpoint(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"highVoltageSetPoint", (double)standbyAutomaton.getHighVoltageSetpoint(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"lowVoltageThreshold", (double)standbyAutomaton.getLowVoltageThreshold(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"highVoltageThreshold", (double)standbyAutomaton.getHighVoltageThreshold(), (XMLStreamWriter)context.getWriter());
    }

    public StandbyAutomaton read(StaticVarCompensator svc, XmlReaderContext context) {
        double b0 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"b0");
        boolean standby = XmlUtil.readBoolAttribute((XMLStreamReader)context.getReader(), (String)"standby");
        double lowVoltageSetpoint = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"lowVoltageSetPoint");
        double highVoltageSetpoint = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"highVoltageSetPoint");
        double lowVoltageThreshold = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"lowVoltageThreshold");
        double highVoltageThreshold = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"highVoltageThreshold");
        ((StandbyAutomatonAdder)svc.newExtension(StandbyAutomatonAdder.class)).withB0(b0).withStandbyStatus(standby).withLowVoltageSetpoint(lowVoltageSetpoint).withHighVoltageSetpoint(highVoltageSetpoint).withLowVoltageThreshold(lowVoltageThreshold).withHighVoltageThreshold(highVoltageThreshold).add();
        return (StandbyAutomaton)svc.getExtension(StandbyAutomaton.class);
    }
}

