/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.extensions.Coordinate;
import com.powsybl.iidm.network.extensions.SubstationPosition;
import com.powsybl.iidm.network.extensions.SubstationPositionAdder;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class SubstationPositionXmlSerializer
extends AbstractExtensionXmlSerializer<Substation, SubstationPosition> {
    public SubstationPositionXmlSerializer() {
        super("substationPosition", "network", SubstationPosition.class, true, "substationPosition.xsd", "http://www.powsybl.org/schema/iidm/ext/substation_position/1_0", "sp");
    }

    public void write(SubstationPosition substationPosition, XmlWriterContext context) throws XMLStreamException {
        context.getWriter().writeEmptyElement(this.getNamespaceUri(), "coordinate");
        XmlUtil.writeDouble((String)"longitude", (double)substationPosition.getCoordinate().getLongitude(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"latitude", (double)substationPosition.getCoordinate().getLatitude(), (XMLStreamWriter)context.getWriter());
    }

    public SubstationPosition read(Substation substation, XmlReaderContext context) throws XMLStreamException {
        Coordinate[] coordinate = new Coordinate[1];
        XmlUtil.readUntilEndElement((String)this.getExtensionName(), (XMLStreamReader)context.getReader(), () -> {
            double longitude = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"longitude");
            double latitude = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"latitude");
            coordinate[0] = new Coordinate(latitude, longitude);
        });
        return (SubstationPosition)((SubstationPositionAdder)substation.newExtension(SubstationPositionAdder.class)).withCoordinate(coordinate[0]).add();
    }
}

