/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerFortescue;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerFortescueAdder;
import com.powsybl.iidm.network.extensions.WindingConnectionType;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class ThreeWindingsTransformerFortescueXmlSerializer
extends AbstractExtensionXmlSerializer<ThreeWindingsTransformer, ThreeWindingsTransformerFortescue> {
    public ThreeWindingsTransformerFortescueXmlSerializer() {
        super("threeWindingsTransformerFortescue", "network", ThreeWindingsTransformerFortescue.class, true, "threeWindingsTransformerFortescue_V1_0.xsd", "http://www.powsybl.org/schema/iidm/ext/three_windings_transformer_fortescue/1_0", "t3f");
    }

    private static void writeLeg(ThreeWindingsTransformerFortescue.LegFortescue legFortescue, XMLStreamWriter writer) throws XMLStreamException {
        XmlUtil.writeOptionalDouble((String)"rz", (double)legFortescue.getRz(), (double)Double.NaN, (XMLStreamWriter)writer);
        XmlUtil.writeOptionalDouble((String)"xz", (double)legFortescue.getXz(), (double)Double.NaN, (XMLStreamWriter)writer);
        writer.writeAttribute("freeFluxes", Boolean.toString(legFortescue.isFreeFluxes()));
        writer.writeAttribute("connectionType", legFortescue.getConnectionType().name());
        XmlUtil.writeOptionalDouble((String)"groundingR", (double)legFortescue.getGroundingR(), (double)0.0, (XMLStreamWriter)writer);
        XmlUtil.writeOptionalDouble((String)"groundingX", (double)legFortescue.getGroundingX(), (double)0.0, (XMLStreamWriter)writer);
    }

    public void write(ThreeWindingsTransformerFortescue twtFortescue, XmlWriterContext context) throws XMLStreamException {
        context.getWriter().writeEmptyElement(this.getNamespaceUri(), "leg1");
        ThreeWindingsTransformerFortescueXmlSerializer.writeLeg(twtFortescue.getLeg1(), context.getWriter());
        context.getWriter().writeEmptyElement(this.getNamespaceUri(), "leg2");
        ThreeWindingsTransformerFortescueXmlSerializer.writeLeg(twtFortescue.getLeg2(), context.getWriter());
        context.getWriter().writeEmptyElement(this.getNamespaceUri(), "leg3");
        ThreeWindingsTransformerFortescueXmlSerializer.writeLeg(twtFortescue.getLeg3(), context.getWriter());
    }

    private void readLeg(ThreeWindingsTransformerFortescueAdder.LegFortescueAdder legAdder, XMLStreamReader reader) {
        double rz = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)"rz");
        double xz = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)"xz");
        boolean freeFluxes = XmlUtil.readBoolAttribute((XMLStreamReader)reader, (String)"freeFluxes");
        WindingConnectionType connectionType = WindingConnectionType.valueOf((String)reader.getAttributeValue(null, "connectionType"));
        double groundingR = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)"groundingR", (double)0.0);
        double groundingX = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)"groundingX", (double)0.0);
        legAdder.withRz(rz).withXz(xz).withFreeFluxes(freeFluxes).withConnectionType(connectionType).withGroundingR(groundingR).withGroundingX(groundingX);
    }

    public ThreeWindingsTransformerFortescue read(ThreeWindingsTransformer twt, XmlReaderContext context) throws XMLStreamException {
        ThreeWindingsTransformerFortescueAdder fortescueAdder = (ThreeWindingsTransformerFortescueAdder)twt.newExtension(ThreeWindingsTransformerFortescueAdder.class);
        XmlUtil.readUntilEndElement((String)this.getExtensionName(), (XMLStreamReader)context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "leg1": {
                    this.readLeg(fortescueAdder.leg1(), context.getReader());
                    break;
                }
                case "leg2": {
                    this.readLeg(fortescueAdder.leg2(), context.getReader());
                    break;
                }
                case "leg3": {
                    this.readLeg(fortescueAdder.leg3(), context.getReader());
                    break;
                }
            }
        });
        return (ThreeWindingsTransformerFortescue)fortescueAdder.add();
    }
}

