/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerFortescue;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerFortescueAdder;
import com.powsybl.iidm.network.extensions.WindingConnectionType;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class TwoWindingsTransformerFortescueXmlSerializer
extends AbstractExtensionXmlSerializer<TwoWindingsTransformer, TwoWindingsTransformerFortescue> {
    public TwoWindingsTransformerFortescueXmlSerializer() {
        super("twoWindingsTransformerFortescue", "network", TwoWindingsTransformerFortescue.class, false, "twoWindingsTransformerFortescue_V1_0.xsd", "http://www.powsybl.org/schema/iidm/ext/two_windings_transformer_fortescue/1_0", "t2f");
    }

    public void write(TwoWindingsTransformerFortescue twtFortescue, XmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeOptionalDouble((String)"rz", (double)twtFortescue.getRz(), (double)Double.NaN, (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalDouble((String)"xz", (double)twtFortescue.getXz(), (double)Double.NaN, (XMLStreamWriter)context.getWriter());
        context.getWriter().writeAttribute("freeFluxes", Boolean.toString(twtFortescue.isFreeFluxes()));
        context.getWriter().writeAttribute("connectionType1", twtFortescue.getConnectionType1().name());
        context.getWriter().writeAttribute("connectionType2", twtFortescue.getConnectionType2().name());
        XmlUtil.writeOptionalDouble((String)"groundingR1", (double)twtFortescue.getGroundingR1(), (double)0.0, (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalDouble((String)"groundingX1", (double)twtFortescue.getGroundingX1(), (double)0.0, (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalDouble((String)"groundingR2", (double)twtFortescue.getGroundingR2(), (double)0.0, (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalDouble((String)"groundingX2", (double)twtFortescue.getGroundingX2(), (double)0.0, (XMLStreamWriter)context.getWriter());
    }

    public TwoWindingsTransformerFortescue read(TwoWindingsTransformer twt, XmlReaderContext context) throws XMLStreamException {
        double rz = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"rz");
        double xz = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"xz");
        boolean freeFluxes = XmlUtil.readBoolAttribute((XMLStreamReader)context.getReader(), (String)"freeFluxes");
        WindingConnectionType connectionType1 = WindingConnectionType.valueOf((String)context.getReader().getAttributeValue(null, "connectionType1"));
        WindingConnectionType connectionType2 = WindingConnectionType.valueOf((String)context.getReader().getAttributeValue(null, "connectionType2"));
        double groundingR1 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"groundingR1", (double)0.0);
        double groundingX1 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"groundingX1", (double)0.0);
        double groundingR2 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"groundingR2", (double)0.0);
        double groundingX2 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"groundingX2", (double)0.0);
        return (TwoWindingsTransformerFortescue)((TwoWindingsTransformerFortescueAdder)twt.newExtension(TwoWindingsTransformerFortescueAdder.class)).withRz(rz).withXz(xz).withFreeFluxes(freeFluxes).withConnectionType1(connectionType1).withConnectionType2(connectionType2).withGroundingR1(groundingR1).withGroundingX1(groundingX1).withGroundingR2(groundingR2).withGroundingX2(groundingX2).add();
    }
}

