/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.util;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.xml.AbstractNetworkXmlContext;
import com.powsybl.iidm.xml.ExportOptions;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IidmXmlUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IidmXmlUtil.class);
    private static final String MAXIMUM_REASON = "IIDM-XML version should be <= ";
    private static final String MINIMUM_REASON = "IIDM-XML version should be >= ";

    private static String message(String elementName, ErrorMessage type, IidmXmlVersion version, IidmXmlVersion contextVersion, String reason) {
        return elementName + " is " + type.message + " for IIDM-XML version " + contextVersion.toString(".") + ". " + reason + version.toString(".");
    }

    private static PowsyblException createException(String rootElementName, String elementName, ErrorMessage type, IidmXmlVersion version, IidmXmlVersion contextVersion, String reason) {
        return IidmXmlUtil.createException(rootElementName + "." + elementName, type, version, contextVersion, reason);
    }

    private static PowsyblException createException(String elementName, ErrorMessage type, IidmXmlVersion version, IidmXmlVersion contextVersion, String reason) {
        return new PowsyblException(IidmXmlUtil.message(elementName, type, version, contextVersion, reason));
    }

    private static void createExceptionOrLogError(String rootElementName, String elementName, ErrorMessage type, IidmXmlVersion refVersion, String reason, NetworkXmlWriterContext context) {
        IidmXmlUtil.createExceptionOrLogError(rootElementName + "." + elementName, type, refVersion, reason, context);
    }

    private static void createExceptionOrLogError(String elementName, ErrorMessage type, IidmXmlVersion refVersion, String reason, NetworkXmlWriterContext context) {
        if (context.getOptions().getIidmVersionIncompatibilityBehavior() == ExportOptions.IidmVersionIncompatibilityBehavior.THROW_EXCEPTION) {
            throw IidmXmlUtil.createException(elementName, type, refVersion, context.getVersion(), reason);
        }
        if (context.getOptions().getIidmVersionIncompatibilityBehavior() == ExportOptions.IidmVersionIncompatibilityBehavior.LOG_ERROR) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(IidmXmlUtil.message(elementName, type, refVersion, context.getVersion(), reason));
            }
        } else {
            throw new IllegalStateException("Unexpected behaviour: " + context.getOptions().getIidmVersionIncompatibilityBehavior());
        }
    }

    public static void assertMaximumVersion(String rootElementName, String elementName, ErrorMessage type, IidmXmlVersion maxVersion, NetworkXmlReaderContext context) {
        if (context.getVersion().compareTo(maxVersion) > 0) {
            throw IidmXmlUtil.createException(rootElementName, elementName, type, maxVersion, context.getVersion(), MAXIMUM_REASON);
        }
    }

    public static void assertMaximumVersion(String rootElementName, String elementName, ErrorMessage type, IidmXmlVersion maxVersion, NetworkXmlWriterContext context) {
        if (context.getVersion().compareTo(maxVersion) > 0) {
            IidmXmlUtil.createExceptionOrLogError(rootElementName, elementName, type, maxVersion, MAXIMUM_REASON, context);
        }
    }

    public static void assertMaximumVersion(String elementName, ErrorMessage type, IidmXmlVersion maxVersion, NetworkXmlReaderContext context) {
        if (context.getVersion().compareTo(maxVersion) > 0) {
            throw IidmXmlUtil.createException(elementName, type, maxVersion, context.getVersion(), MAXIMUM_REASON);
        }
    }

    public static void assertMaximumVersion(String elementName, ErrorMessage type, IidmXmlVersion maxVersion, NetworkXmlWriterContext context) {
        if (context.getVersion().compareTo(maxVersion) > 0) {
            IidmXmlUtil.createExceptionOrLogError(elementName, type, maxVersion, MAXIMUM_REASON, context);
        }
    }

    public static void assertMinimumVersion(String rootElementName, String elementName, ErrorMessage type, IidmXmlVersion minVersion, NetworkXmlReaderContext context) {
        if (context.getVersion().compareTo(minVersion) < 0) {
            throw IidmXmlUtil.createException(rootElementName, elementName, type, minVersion, context.getVersion(), MINIMUM_REASON);
        }
    }

    public static void assertMinimumVersion(String rootElementName, String elementName, ErrorMessage type, IidmXmlVersion minVersion, IidmXmlVersion version) {
        if (version.compareTo(minVersion) < 0) {
            throw IidmXmlUtil.createException(rootElementName, elementName, type, minVersion, version, MINIMUM_REASON);
        }
    }

    public static void assertMinimumVersion(String rootElementName, String elementName, ErrorMessage type, IidmXmlVersion minVersion, NetworkXmlWriterContext context) {
        if (context.getVersion().compareTo(minVersion) < 0) {
            IidmXmlUtil.createExceptionOrLogError(rootElementName, elementName, type, minVersion, MINIMUM_REASON, context);
        }
    }

    public static void assertMinimumVersion(String elementName, ErrorMessage type, IidmXmlVersion minVersion, NetworkXmlReaderContext context) {
        if (context.getVersion().compareTo(minVersion) < 0) {
            throw IidmXmlUtil.createException(elementName, type, minVersion, context.getVersion(), MINIMUM_REASON);
        }
    }

    public static void assertMinimumVersion(String elementName, ErrorMessage type, IidmXmlVersion minVersion, NetworkXmlWriterContext context) {
        if (context.getVersion().compareTo(minVersion) < 0) {
            IidmXmlUtil.createExceptionOrLogError(elementName, type, minVersion, MINIMUM_REASON, context);
        }
    }

    public static void assertMinimumVersionIfNotDefault(boolean valueIsNotDefault, String rootElementName, String elementName, ErrorMessage type, IidmXmlVersion minVersion, IidmXmlVersion version) {
        if (valueIsNotDefault) {
            IidmXmlUtil.assertMinimumVersion(rootElementName, elementName, type, minVersion, version);
        }
    }

    public static void assertMinimumVersionIfNotDefault(boolean valueIsNotDefault, String rootElementName, String elementName, ErrorMessage type, IidmXmlVersion minVersion, NetworkXmlReaderContext context) {
        if (valueIsNotDefault) {
            IidmXmlUtil.assertMinimumVersion(rootElementName, elementName, type, minVersion, context);
        }
    }

    public static void assertMinimumVersionIfNotDefault(boolean valueIsNotDefault, String rootElementName, String elementName, ErrorMessage type, IidmXmlVersion minVersion, NetworkXmlWriterContext context) {
        if (valueIsNotDefault) {
            IidmXmlUtil.assertMinimumVersion(rootElementName, elementName, type, minVersion, context);
        }
    }

    public static void assertMinimumVersionAndRunIfNotDefault(boolean valueIsNotDefault, String rootElementName, String elementName, ErrorMessage type, IidmXmlVersion minVersion, NetworkXmlReaderContext context, IidmXmlRunnable runnable) {
        if (valueIsNotDefault) {
            IidmXmlUtil.assertMinimumVersion(rootElementName, elementName, type, minVersion, context);
            runnable.run();
        }
    }

    public static void assertMinimumVersionAndRunIfNotDefault(boolean valueIsNotDefault, String rootElementName, String elementName, ErrorMessage type, IidmXmlVersion minVersion, NetworkXmlWriterContext context, IidmXmlRunnable runnable) {
        if (valueIsNotDefault) {
            IidmXmlUtil.assertMinimumVersion(rootElementName, elementName, type, minVersion, context);
            IidmXmlUtil.runFromMinimumVersion(minVersion, context, runnable::run);
        }
    }

    public static void assertStrictMaximumVersion(String rootElementName, String elementName, ErrorMessage type, IidmXmlVersion maxVersion, NetworkXmlReaderContext context) {
        if (context.getVersion().compareTo(maxVersion) >= 0) {
            throw IidmXmlUtil.createException(rootElementName, elementName, type, maxVersion, context.getVersion(), "IIDM-XML version should be < ");
        }
    }

    public static void assertStrictMaximumVersion(String rootElementName, String elementName, ErrorMessage type, IidmXmlVersion maxVersion, NetworkXmlWriterContext context) {
        if (context.getVersion().compareTo(maxVersion) >= 0) {
            IidmXmlUtil.createExceptionOrLogError(rootElementName, elementName, type, maxVersion, "IIDM-XML version should be < ", context);
        }
    }

    public static <C extends AbstractNetworkXmlContext> void runFromMinimumVersion(IidmXmlVersion minVersion, C context, IidmXmlRunnable runnable) {
        if (context.getVersion().compareTo(minVersion) >= 0) {
            runnable.run();
        }
    }

    public static <C extends AbstractNetworkXmlContext> void runUntilMaximumVersion(IidmXmlVersion maxVersion, C context, IidmXmlRunnable runnable) {
        if (context.getVersion().compareTo(maxVersion) <= 0) {
            runnable.run();
        }
    }

    public static void writeBooleanAttributeFromMinimumVersion(String rootElementName, String attributeName, boolean value, boolean defaultValue, ErrorMessage type, IidmXmlVersion minVersion, NetworkXmlWriterContext context) {
        IidmXmlUtil.writeAttributeFromMinimumVersion(rootElementName, attributeName, value != defaultValue, type, minVersion, context, () -> context.getWriter().writeAttribute(attributeName, Boolean.toString(value)));
    }

    public static void writeDoubleAttributeFromMinimumVersion(String rootElementName, String attributeName, double value, ErrorMessage type, IidmXmlVersion minVersion, NetworkXmlWriterContext context) {
        IidmXmlUtil.writeDoubleAttributeFromMinimumVersion(rootElementName, attributeName, value, Double.NaN, type, minVersion, context);
    }

    public static void writeDoubleAttributeFromMinimumVersion(String rootElementName, String attributeName, double value, double defaultValue, ErrorMessage type, IidmXmlVersion minVersion, NetworkXmlWriterContext context) {
        IidmXmlUtil.writeAttributeFromMinimumVersion(rootElementName, attributeName, !Objects.equals(value, defaultValue), type, minVersion, context, () -> XmlUtil.writeDouble((String)attributeName, (double)value, (XMLStreamWriter)context.getWriter()));
    }

    private static void writeAttributeFromMinimumVersion(String rootElementName, String attributeName, boolean isNotDefaultValue, ErrorMessage type, IidmXmlVersion minVersion, NetworkXmlWriterContext context, IidmXmlRunnable write) {
        if (context.getVersion().compareTo(minVersion) >= 0) {
            write.run();
        } else {
            IidmXmlUtil.assertMinimumVersionIfNotDefault(isNotDefaultValue, rootElementName, attributeName, type, minVersion, context);
        }
    }

    public static void writeIntAttributeUntilMaximumVersion(String attributeName, int value, IidmXmlVersion maxVersion, NetworkXmlWriterContext context) throws XMLStreamException {
        if (context.getVersion().compareTo(maxVersion) <= 0) {
            XmlUtil.writeInt((String)attributeName, (int)value, (XMLStreamWriter)context.getWriter());
        }
    }

    public static String getAttributeName(String oldName, String newName, IidmXmlVersion version, IidmXmlVersion comparisonVersion) {
        if (version.compareTo(comparisonVersion) < 0) {
            return oldName;
        }
        return newName;
    }

    public static <T extends Identifiable> Iterable<T> sorted(Iterable<T> identifiables, ExportOptions exportOptions) {
        Objects.requireNonNull(identifiables);
        Objects.requireNonNull(exportOptions);
        return exportOptions.isSorted() ? (Iterable)StreamSupport.stream(identifiables.spliterator(), false).sorted(Comparator.comparing(Identifiable::getId)).collect(Collectors.toList()) : identifiables;
    }

    public static <T extends Identifiable<T>> Stream<T> sorted(Stream<T> stream, ExportOptions exportOptions) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(exportOptions);
        return exportOptions.isSorted() ? stream.sorted(Comparator.comparing(Identifiable::getId)) : stream;
    }

    public static Iterable<? extends Extension<? extends Identifiable<?>>> sortedExtensions(Iterable<? extends Extension<? extends Identifiable<?>>> extensions, ExportOptions exportOptions) {
        Objects.requireNonNull(exportOptions);
        Objects.requireNonNull(exportOptions);
        return exportOptions.isSorted() ? (Iterable)StreamSupport.stream(extensions.spliterator(), false).sorted(Comparator.comparing(Extension::getName)).collect(Collectors.toList()) : extensions;
    }

    public static Iterable<LoadingLimits.TemporaryLimit> sortedTemporaryLimits(Iterable<LoadingLimits.TemporaryLimit> temporaryLimits, ExportOptions exportOptions) {
        Objects.requireNonNull(temporaryLimits);
        Objects.requireNonNull(exportOptions);
        return exportOptions.isSorted() ? (Iterable)StreamSupport.stream(temporaryLimits.spliterator(), false).sorted(Comparator.comparing(LoadingLimits.TemporaryLimit::getName)).collect(Collectors.toList()) : temporaryLimits;
    }

    public static Iterable<VoltageLevel.NodeBreakerView.InternalConnection> sortedInternalConnections(Iterable<VoltageLevel.NodeBreakerView.InternalConnection> internalConnections, ExportOptions exportOptions) {
        Objects.requireNonNull(internalConnections);
        Objects.requireNonNull(exportOptions);
        return exportOptions.isSorted() ? (Iterable)StreamSupport.stream(internalConnections.spliterator(), false).sorted(Comparator.comparing(VoltageLevel.NodeBreakerView.InternalConnection::getNode1).thenComparing(VoltageLevel.NodeBreakerView.InternalConnection::getNode2)).collect(Collectors.toList()) : internalConnections;
    }

    public static Iterable<String> sortedNames(Iterable<String> names, ExportOptions exportOptions) {
        Objects.requireNonNull(names);
        Objects.requireNonNull(exportOptions);
        return exportOptions.isSorted() ? (Iterable)StreamSupport.stream(names.spliterator(), false).sorted().collect(Collectors.toList()) : names;
    }

    private IidmXmlUtil() {
    }

    public static enum ErrorMessage {
        NOT_SUPPORTED("not supported"),
        MANDATORY("mandatory"),
        NOT_NULL_NOT_SUPPORTED("not null and not supported"),
        NOT_DEFAULT_NOT_SUPPORTED("not defined as default and not supported");

        private String message;

        private ErrorMessage(String message) {
            this.message = message;
        }
    }

    public static interface IidmXmlRunnable
    extends Runnable {
        @Override
        default public void run() {
            try {
                this.runWithXmlStreamException();
            }
            catch (XMLStreamException e) {
                throw new UncheckedXmlStreamException(e);
            }
        }

        public void runWithXmlStreamException() throws XMLStreamException;
    }
}

