/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.itools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileStore;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="package-zip", requiresDependencyCollection=ResolutionScope.RUNTIME, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ItoolsPackagerMojo
extends AbstractMojo {
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter
    private String packageName;
    @Parameter
    private String archiveName;
    @Parameter(defaultValue="8G")
    private String javaXmx;
    @Parameter(defaultValue="config")
    private String configName;
    @Parameter(defaultValue="zip")
    private String packageType;
    @Parameter
    private CopyTo copyToBin;
    @Parameter
    private CopyTo copyToLib;
    @Parameter
    private CopyTo copyToEtc;

    private void zip(Path dir, final Path baseDir, Path zipFilePath) throws IOException {
        this.getLog().info((CharSequence)"Zip package");
        try (final ZipArchiveOutputStream zos = new ZipArchiveOutputStream(Files.newOutputStream(zipFilePath, new OpenOption[0]));){
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    ZipArchiveEntry entry = new ZipArchiveEntry(baseDir.relativize(file).toString());
                    if (Files.isExecutable(file)) {
                        entry.setUnixMode(33272);
                    } else {
                        entry.setUnixMode(33200);
                    }
                    zos.putArchiveEntry(entry);
                    Files.copy(file, (OutputStream)zos);
                    zos.closeArchiveEntry();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    zos.putArchiveEntry(new ZipArchiveEntry(baseDir.relativize(dir).toString() + "/"));
                    zos.closeArchiveEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private void targz(Path dir, final Path baseDir, Path zipFilePath) throws IOException {
        this.getLog().info((CharSequence)"Targz package");
        try (final TarArchiveOutputStream zos = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream(Files.newOutputStream(zipFilePath, new OpenOption[0])));){
            zos.setLongFileMode(3);
            zos.setBigNumberMode(2);
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    TarArchiveEntry entry = new TarArchiveEntry(file.toFile(), baseDir.relativize(file).toString());
                    if (Files.isExecutable(file)) {
                        entry.setMode(33272);
                    } else {
                        entry.setMode(33200);
                    }
                    zos.putArchiveEntry(entry);
                    Files.copy(file, (OutputStream)zos);
                    zos.closeArchiveEntry();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    zos.putArchiveEntry(new TarArchiveEntry(baseDir.relativize(dir).toString() + "/"));
                    zos.closeArchiveEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private void copyFiles(CopyTo copyTo, Path destDir) {
        if (copyTo != null) {
            for (File file : copyTo.getFiles()) {
                Path path = file.toPath();
                if (Files.exists(path, new LinkOption[0])) {
                    this.getLog().info((CharSequence)("Copy file " + path + " to " + destDir));
                    try {
                        Files.copy(path, destDir.resolve(path.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                this.getLog().warn((CharSequence)("File " + path + " not found"));
            }
        }
    }

    private void writeItoolsConf(BufferedWriter writer) throws IOException {
        writer.write("#powsybl_config_dirs=");
        writer.newLine();
        writer.write("powsybl_config_name=");
        writer.write(this.configName);
        writer.newLine();
        writer.write("java_xmx=");
        writer.write(this.javaXmx);
        writer.newLine();
    }

    public void execute() {
        block13: {
            try {
                String archiveNameNotNull;
                String packageNameNotNull = this.packageName != null ? this.packageName : this.project.getBuild().getFinalName();
                Path targetDir = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
                Path packageDir = targetDir.resolve(packageNameNotNull);
                Path javaDir = packageDir.resolve("share").resolve("java");
                Files.createDirectories(javaDir, new FileAttribute[0]);
                for (Object artifact : this.project.getArtifacts()) {
                    Path jar = artifact.getFile().toPath();
                    this.getLog().info((CharSequence)("Add jar " + jar + " to package"));
                    Files.copy(jar, javaDir.resolve(jar.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                }
                Path binDir = packageDir.resolve("bin");
                Files.createDirectories(binDir, new FileAttribute[0]);
                for (String script : Arrays.asList("itools", "itools.bat", "powsyblsh")) {
                    this.getLog().info((CharSequence)("Add script " + script + " to package"));
                    Path file = binDir.resolve(script);
                    Files.copy(ItoolsPackagerMojo.class.getResourceAsStream("/" + script), file, StandardCopyOption.REPLACE_EXISTING);
                    FileStore fileStore = Files.getFileStore(file);
                    if (!fileStore.supportsFileAttributeView(PosixFileAttributeView.class)) continue;
                    EnumSet<PosixFilePermission> perms = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE);
                    Files.setPosixFilePermissions(file, perms);
                }
                this.copyFiles(this.copyToBin, binDir);
                Path etcDir = packageDir.resolve("etc");
                Files.createDirectories(etcDir, new FileAttribute[0]);
                Files.copy(ItoolsPackagerMojo.class.getResourceAsStream("/logback-itools.xml"), etcDir.resolve("logback-itools.xml"), StandardCopyOption.REPLACE_EXISTING);
                Files.copy(ItoolsPackagerMojo.class.getResourceAsStream("/logback-powsyblsh.xml"), etcDir.resolve("logback-powsyblsh.xml"), StandardCopyOption.REPLACE_EXISTING);
                try (BufferedWriter writer = Files.newBufferedWriter(etcDir.resolve("itools.conf"), StandardCharsets.UTF_8, new OpenOption[0]);){
                    this.writeItoolsConf(writer);
                }
                this.copyFiles(this.copyToEtc, etcDir);
                Path libDir = packageDir.resolve("lib");
                Files.createDirectories(libDir, new FileAttribute[0]);
                this.copyFiles(this.copyToLib, libDir);
                String string = archiveNameNotNull = this.archiveName != null ? this.archiveName : packageNameNotNull;
                if (this.packageType.equalsIgnoreCase("zip")) {
                    this.zip(packageDir, targetDir, targetDir.resolve(archiveNameNotNull + ".zip"));
                    break block13;
                }
                if (this.packageType.equalsIgnoreCase("tgz")) {
                    this.targz(packageDir, targetDir, targetDir.resolve(archiveNameNotNull + ".tgz"));
                    break block13;
                }
                throw new IllegalArgumentException("Unknown filetype '" + this.packageType + "': should be either zip or tgz");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static class CopyTo {
        private File[] files;

        public File[] getFiles() {
            return this.files;
        }

        public void setFiles(File[] files) {
            this.files = files;
        }
    }
}

