/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow;

import com.powsybl.commons.Versionable;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.config.PlatformConfigNamedProvider;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.local.LocalComputationManager;
import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.LoadFlowProvider;
import com.powsybl.loadflow.LoadFlowResult;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class LoadFlow {
    private LoadFlow() {
    }

    public static Runner find(String name) {
        return new Runner((LoadFlowProvider)PlatformConfigNamedProvider.Finder.findBackwardsCompatible((String)name, (String)"load-flow", LoadFlowProvider.class, (PlatformConfig)PlatformConfig.defaultConfig()));
    }

    public static Runner find() {
        return LoadFlow.find(null);
    }

    public static CompletableFuture<LoadFlowResult> runAsync(Network network, String workingStateId, ComputationManager computationManager, LoadFlowParameters parameters, ReportNode reportNode) {
        return LoadFlow.find().runAsync(network, workingStateId, computationManager, parameters, reportNode);
    }

    public static CompletableFuture<LoadFlowResult> runAsync(Network network, String workingStateId, ComputationManager computationManager, LoadFlowParameters parameters) {
        return LoadFlow.find().runAsync(network, workingStateId, computationManager, parameters);
    }

    public static CompletableFuture<LoadFlowResult> runAsync(Network network, ComputationManager computationManager, LoadFlowParameters parameters) {
        return LoadFlow.find().runAsync(network, computationManager, parameters);
    }

    public static CompletableFuture<LoadFlowResult> runAsync(Network network, LoadFlowParameters parameters) {
        return LoadFlow.find().runAsync(network, parameters);
    }

    public static CompletableFuture<LoadFlowResult> runAsync(Network network) {
        return LoadFlow.find().runAsync(network);
    }

    public static LoadFlowResult run(Network network, String workingStateId, ComputationManager computationManager, LoadFlowParameters parameters, ReportNode reportNode) {
        return LoadFlow.find().run(network, workingStateId, computationManager, parameters, reportNode);
    }

    public static LoadFlowResult run(Network network, String workingStateId, ComputationManager computationManager, LoadFlowParameters parameters) {
        return LoadFlow.find().run(network, workingStateId, computationManager, parameters);
    }

    public static LoadFlowResult run(Network network, ComputationManager computationManager, LoadFlowParameters parameters) {
        return LoadFlow.find().run(network, computationManager, parameters);
    }

    public static LoadFlowResult run(Network network, LoadFlowParameters parameters) {
        return LoadFlow.find().run(network, parameters);
    }

    public static LoadFlowResult run(Network network) {
        return LoadFlow.find().run(network);
    }

    public static class Runner
    implements Versionable {
        private final LoadFlowProvider provider;

        public Runner(LoadFlowProvider provider) {
            this.provider = Objects.requireNonNull(provider);
        }

        public CompletableFuture<LoadFlowResult> runAsync(Network network, String workingStateId, ComputationManager computationManager, LoadFlowParameters parameters, ReportNode reportNode) {
            Objects.requireNonNull(workingStateId);
            Objects.requireNonNull(parameters);
            Objects.requireNonNull(reportNode);
            return this.provider.run(network, computationManager, workingStateId, parameters, reportNode);
        }

        public CompletableFuture<LoadFlowResult> runAsync(Network network, String workingStateId, ComputationManager computationManager, LoadFlowParameters parameters) {
            return this.runAsync(network, workingStateId, computationManager, parameters, ReportNode.NO_OP);
        }

        public CompletableFuture<LoadFlowResult> runAsync(Network network, ComputationManager computationManager, LoadFlowParameters parameters) {
            return this.runAsync(network, network.getVariantManager().getWorkingVariantId(), computationManager, parameters);
        }

        public CompletableFuture<LoadFlowResult> runAsync(Network network, LoadFlowParameters parameters) {
            return this.runAsync(network, LocalComputationManager.getDefault(), parameters);
        }

        public CompletableFuture<LoadFlowResult> runAsync(Network network) {
            return this.runAsync(network, LoadFlowParameters.load());
        }

        public LoadFlowResult run(Network network, String workingStateId, ComputationManager computationManager, LoadFlowParameters parameters, ReportNode reportNode) {
            Objects.requireNonNull(workingStateId);
            Objects.requireNonNull(parameters);
            Objects.requireNonNull(reportNode);
            return this.provider.run(network, computationManager, workingStateId, parameters, reportNode).join();
        }

        public LoadFlowResult run(Network network, String workingStateId, ComputationManager computationManager, LoadFlowParameters parameters) {
            return this.run(network, workingStateId, computationManager, parameters, ReportNode.NO_OP);
        }

        public LoadFlowResult run(Network network, ComputationManager computationManager, LoadFlowParameters parameters) {
            return this.run(network, network.getVariantManager().getWorkingVariantId(), computationManager, parameters);
        }

        public LoadFlowResult run(Network network, LoadFlowParameters parameters) {
            return this.run(network, LocalComputationManager.getDefault(), parameters);
        }

        public LoadFlowResult run(Network network) {
            return this.run(network, LoadFlowParameters.load());
        }

        public String getName() {
            return this.provider.getName();
        }

        public String getVersion() {
            return this.provider.getVersion();
        }
    }
}

