/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.extensions.ExtensionProvider;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.LoadFlowProvider;
import com.powsybl.loadflow.json.LoadFlowParametersDeserializer;
import com.powsybl.loadflow.json.LoadFlowParametersJsonModule;
import com.powsybl.loadflow.json.LoadFlowParametersSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class JsonLoadFlowParameters {
    private JsonLoadFlowParameters() {
    }

    public static Map<String, ExtensionJsonSerializer> getExtensionSerializers() {
        List providers = new ServiceLoaderCache(LoadFlowProvider.class).getServices();
        return providers.stream().flatMap(loadFlowProvider -> loadFlowProvider.getSpecificParametersSerializer().stream()).collect(Collectors.toMap(ExtensionProvider::getExtensionName, loadFlowProvider -> loadFlowProvider));
    }

    public static LoadFlowParameters read(Path jsonFile) {
        return JsonLoadFlowParameters.update(new LoadFlowParameters(), jsonFile);
    }

    public static LoadFlowParameters read(InputStream jsonStream) {
        return JsonLoadFlowParameters.update(new LoadFlowParameters(), jsonStream);
    }

    public static LoadFlowParameters update(LoadFlowParameters parameters, Path jsonFile) {
        LoadFlowParameters loadFlowParameters;
        block8: {
            Objects.requireNonNull(jsonFile);
            InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);
            try {
                loadFlowParameters = JsonLoadFlowParameters.update(parameters, is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return loadFlowParameters;
    }

    public static LoadFlowParameters update(LoadFlowParameters parameters, InputStream jsonStream) {
        try {
            ObjectMapper objectMapper = JsonLoadFlowParameters.createObjectMapper();
            return (LoadFlowParameters)((Object)objectMapper.readerForUpdating((Object)parameters).readValue(jsonStream));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(LoadFlowParameters parameters, Path jsonFile) {
        Objects.requireNonNull(jsonFile);
        try (OutputStream outputStream = Files.newOutputStream(jsonFile, new OpenOption[0]);){
            JsonLoadFlowParameters.write(parameters, outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(LoadFlowParameters parameters, OutputStream outputStream) {
        try {
            ObjectMapper objectMapper = JsonLoadFlowParameters.createObjectMapper();
            ObjectWriter writer = objectMapper.writerWithDefaultPrettyPrinter();
            writer.writeValue(outputStream, (Object)parameters);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ObjectMapper createObjectMapper() {
        return JsonUtil.createObjectMapper().registerModule((Module)new LoadFlowParametersJsonModule());
    }

    public static LoadFlowParameters deserialize(JsonParser parser, DeserializationContext context, LoadFlowParameters parameters) throws IOException {
        return new LoadFlowParametersDeserializer().deserialize(parser, context, parameters);
    }

    public static LoadFlowParameters deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return new LoadFlowParametersDeserializer().deserialize(parser, context);
    }

    public static void serialize(LoadFlowParameters parameters, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        new LoadFlowParametersSerializer().serialize(parameters, jsonGenerator, serializerProvider);
    }
}

