/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.network.Country;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.json.JsonLoadFlowParameters;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class LoadFlowParametersDeserializer
extends StdDeserializer<LoadFlowParameters> {
    private static final String CONTEXT_NAME = "LoadFlowParameters";

    LoadFlowParametersDeserializer() {
        super(LoadFlowParameters.class);
    }

    public LoadFlowParameters deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        return this.deserialize(parser, deserializationContext, new LoadFlowParameters());
    }

    public LoadFlowParameters deserialize(JsonParser parser, DeserializationContext deserializationContext, LoadFlowParameters parameters) throws IOException {
        String version = null;
        List extensions = Collections.emptyList();
        block48: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.getCurrentName()) {
                case "version": {
                    parser.nextToken();
                    version = parser.getValueAsString();
                    continue block48;
                }
                case "voltageInitMode": {
                    parser.nextToken();
                    parameters.setVoltageInitMode((LoadFlowParameters.VoltageInitMode)((Object)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, LoadFlowParameters.VoltageInitMode.class)));
                    continue block48;
                }
                case "transformerVoltageControlOn": {
                    parser.nextToken();
                    parameters.setTransformerVoltageControlOn((Boolean)parser.readValueAs(Boolean.class));
                    continue block48;
                }
                case "useReactiveLimits": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: useReactiveLimits", version, (String)"1.8");
                    parser.nextToken();
                    parameters.setUseReactiveLimits((Boolean)parser.readValueAs(Boolean.class));
                    continue block48;
                }
                case "noGeneratorReactiveLimits": {
                    JsonUtil.assertLessThanOrEqualToReferenceVersion((String)CONTEXT_NAME, (String)"Tag: noGeneratorReactiveLimits", version, (String)"1.7");
                    parser.nextToken();
                    parameters.setUseReactiveLimits((Boolean)parser.readValueAs(Boolean.class) == false);
                    continue block48;
                }
                case "phaseShifterRegulationOn": {
                    parser.nextToken();
                    parameters.setPhaseShifterRegulationOn((Boolean)parser.readValueAs(Boolean.class));
                    continue block48;
                }
                case "specificCompatibility": {
                    JsonUtil.assertLessThanOrEqualToReferenceVersion((String)CONTEXT_NAME, (String)"Tag: specificCompatibility", version, (String)"1.0");
                    parser.nextToken();
                    parameters.setTwtSplitShuntAdmittance((Boolean)parser.readValueAs(Boolean.class));
                    continue block48;
                }
                case "t2wtSplitShuntAdmittance": {
                    JsonUtil.assertGreaterThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: t2wtSplitShuntAdmittance", version, (String)"1.0");
                    JsonUtil.assertLessThanOrEqualToReferenceVersion((String)CONTEXT_NAME, (String)"Tag: t2wtSplitShuntAdmittance", (String)version, (String)"1.1");
                    parser.nextToken();
                    parameters.setTwtSplitShuntAdmittance((Boolean)parser.readValueAs(Boolean.class));
                    continue block48;
                }
                case "twtSplitShuntAdmittance": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: twtSplitShuntAdmittance", version, (String)"1.2");
                    parser.nextToken();
                    parameters.setTwtSplitShuntAdmittance((Boolean)parser.readValueAs(Boolean.class));
                    continue block48;
                }
                case "simulShunt": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: simulShunt", version, (String)"1.3");
                    JsonUtil.assertLessThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: simulShunt", (String)version, (String)"1.6");
                    parser.nextToken();
                    parameters.setShuntCompensatorVoltageControlOn((Boolean)parser.readValueAs(Boolean.class));
                    continue block48;
                }
                case "shuntCompensatorVoltageControlOn": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: shuntCompensatorVoltageControlOn", version, (String)"1.6");
                    parser.nextToken();
                    parameters.setShuntCompensatorVoltageControlOn((Boolean)parser.readValueAs(Boolean.class));
                    continue block48;
                }
                case "readSlackBus": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: readSlackBus", version, (String)"1.3");
                    parser.nextToken();
                    parameters.setReadSlackBus((Boolean)parser.readValueAs(Boolean.class));
                    continue block48;
                }
                case "writeSlackBus": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: writeSlackBus", version, (String)"1.3");
                    parser.nextToken();
                    parameters.setWriteSlackBus((Boolean)parser.readValueAs(Boolean.class));
                    continue block48;
                }
                case "dc": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: dc", version, (String)"1.4");
                    parser.nextToken();
                    parameters.setDc((Boolean)parser.readValueAs(Boolean.class));
                    continue block48;
                }
                case "distributedSlack": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: distributedSlack", version, (String)"1.4");
                    parser.nextToken();
                    parameters.setDistributedSlack((Boolean)parser.readValueAs(Boolean.class));
                    continue block48;
                }
                case "balanceType": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)("Tag: " + parser.getCurrentName()), (String)version, (String)"1.4");
                    parser.nextToken();
                    parameters.setBalanceType((LoadFlowParameters.BalanceType)((Object)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, LoadFlowParameters.BalanceType.class)));
                    continue block48;
                }
                case "dcUseTransformerRatio": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)("Tag: " + parser.getCurrentName()), (String)version, (String)"1.5");
                    parser.nextToken();
                    parameters.setDcUseTransformerRatio((Boolean)parser.readValueAs(Boolean.class));
                    continue block48;
                }
                case "countriesToBalance": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)("Tag: " + parser.getCurrentName()), (String)version, (String)"1.5");
                    parser.nextToken();
                    Set countries = JsonUtil.readSet((DeserializationContext)deserializationContext, (JsonParser)parser, Country.class);
                    parameters.setCountriesToBalance(countries);
                    continue block48;
                }
                case "connectedComponentMode": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)("Tag: " + parser.getCurrentName()), (String)version, (String)"1.5");
                    parser.nextToken();
                    parameters.setConnectedComponentMode((LoadFlowParameters.ConnectedComponentMode)((Object)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, LoadFlowParameters.ConnectedComponentMode.class)));
                    continue block48;
                }
                case "hvdcAcEmulation": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)("Tag: hvdcAcEmulation" + parser.getCurrentName()), (String)version, (String)"1.7");
                    parser.nextToken();
                    parameters.setHvdcAcEmulation((Boolean)parser.readValueAs(Boolean.class));
                    continue block48;
                }
                case "dcPowerFactor": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)("Tag: dcPowerFactor" + parser.getCurrentName()), (String)version, (String)"1.9");
                    parser.nextToken();
                    parameters.setDcPowerFactor((Double)parser.readValueAs(Double.class));
                    continue block48;
                }
                case "extensions": {
                    parser.nextToken();
                    extensions = JsonUtil.updateExtensions((JsonParser)parser, (DeserializationContext)deserializationContext, JsonLoadFlowParameters.getExtensionSerializers()::get, (Extendable)parameters);
                    continue block48;
                }
            }
            throw new IllegalStateException("Unexpected field: " + parser.getCurrentName());
        }
        extensions.forEach(extension -> parameters.addExtension(extension.getClass(), (Extension)extension));
        return parameters;
    }
}

