/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow;

import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.google.common.collect.ImmutableMap;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.extensions.AbstractExtendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.iidm.network.Country;
import com.powsybl.loadflow.LoadFlowDefaultParametersLoader;
import com.powsybl.loadflow.LoadFlowProvider;
import com.powsybl.loadflow.json.JsonLoadFlowParameters;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadFlowParameters
extends AbstractExtendable<LoadFlowParameters> {
    public static final Logger LOGGER = LoggerFactory.getLogger(LoadFlowParameters.class);
    public static final String VERSION = "1.9";
    public static final VoltageInitMode DEFAULT_VOLTAGE_INIT_MODE = VoltageInitMode.UNIFORM_VALUES;
    public static final boolean DEFAULT_TRANSFORMER_VOLTAGE_CONTROL_ON = false;
    public static final boolean DEFAULT_USE_REACTIVE_LIMITS = true;
    public static final boolean DEFAULT_PHASE_SHIFTER_REGULATION_ON = false;
    public static final boolean DEFAULT_TWT_SPLIT_SHUNT_ADMITTANCE = false;
    public static final boolean DEFAULT_SHUNT_COMPENSATOR_VOLTAGE_CONTROL_ON = false;
    public static final boolean DEFAULT_READ_SLACK_BUS = true;
    public static final boolean DEFAULT_WRITE_SLACK_BUS = true;
    public static final boolean DEFAULT_DC = false;
    public static final boolean DEFAULT_DISTRIBUTED_SLACK = true;
    public static final BalanceType DEFAULT_BALANCE_TYPE = BalanceType.PROPORTIONAL_TO_GENERATION_P_MAX;
    public static final boolean DEFAULT_DC_USE_TRANSFORMER_RATIO_DEFAULT = true;
    public static final Set<Country> DEFAULT_COUNTRIES_TO_BALANCE = Collections.unmodifiableSet(EnumSet.noneOf(Country.class));
    public static final ConnectedComponentMode DEFAULT_CONNECTED_COMPONENT_MODE = ConnectedComponentMode.MAIN;
    public static final boolean DEFAULT_HVDC_AC_EMULATION_ON = true;
    public static final double DEFAULT_DC_POWER_FACTOR = 1.0;
    private VoltageInitMode voltageInitMode = DEFAULT_VOLTAGE_INIT_MODE;
    private boolean transformerVoltageControlOn = false;
    private boolean useReactiveLimits = true;
    private boolean phaseShifterRegulationOn = false;
    private boolean twtSplitShuntAdmittance = false;
    private boolean shuntCompensatorVoltageControlOn = false;
    private boolean readSlackBus = true;
    private boolean writeSlackBus = true;
    private boolean dc = false;
    private boolean distributedSlack = true;
    private BalanceType balanceType = DEFAULT_BALANCE_TYPE;
    private boolean dcUseTransformerRatio = true;
    private Set<Country> countriesToBalance = DEFAULT_COUNTRIES_TO_BALANCE;
    private ConnectedComponentMode connectedComponentMode = DEFAULT_CONNECTED_COMPONENT_MODE;
    private boolean hvdcAcEmulation = true;
    private double dcPowerFactor = 1.0;

    public static LoadFlowParameters load() {
        return LoadFlowParameters.load(PlatformConfig.defaultConfig());
    }

    public static LoadFlowParameters load(PlatformConfig platformConfig) {
        LoadFlowParameters parameters = new LoadFlowParameters();
        LoadFlowParameters.load(parameters, platformConfig);
        parameters.loadExtensions(platformConfig);
        return parameters;
    }

    protected static void load(LoadFlowParameters parameters) {
        LoadFlowParameters.load(parameters, PlatformConfig.defaultConfig());
    }

    protected static void load(LoadFlowParameters parameters, PlatformConfig platformConfig) {
        Objects.requireNonNull(parameters);
        Objects.requireNonNull(platformConfig);
        platformConfig.getOptionalModuleConfig("load-flow-default-parameters").ifPresent(config -> {
            config.getOptionalEnumProperty("voltageInitMode", VoltageInitMode.class).ifPresent(parameters::setVoltageInitMode);
            config.getOptionalBooleanProperty("transformerVoltageControlOn").ifPresent(parameters::setTransformerVoltageControlOn);
            config.getOptionalBooleanProperty("useReactiveLimits").ifPresentOrElse(parameters::setUseReactiveLimits, () -> config.getOptionalBooleanProperty("noGeneratorReactiveLimits").ifPresent(value -> parameters.setUseReactiveLimits(value == false)));
            config.getOptionalBooleanProperty("phaseShifterRegulationOn").ifPresent(parameters::setPhaseShifterRegulationOn);
            config.getOptionalBooleanProperty("twtSplitShuntAdmittance").ifPresentOrElse(parameters::setTwtSplitShuntAdmittance, () -> config.getOptionalBooleanProperty("specificCompatibility").ifPresent(parameters::setTwtSplitShuntAdmittance));
            config.getOptionalBooleanProperty("shuntCompensatorVoltageControlOn").ifPresentOrElse(parameters::setShuntCompensatorVoltageControlOn, () -> config.getOptionalBooleanProperty("simulShunt").ifPresent(parameters::setShuntCompensatorVoltageControlOn));
            config.getOptionalBooleanProperty("readSlackBus").ifPresent(parameters::setReadSlackBus);
            config.getOptionalBooleanProperty("writeSlackBus").ifPresent(parameters::setWriteSlackBus);
            config.getOptionalBooleanProperty("dc").ifPresent(parameters::setDc);
            config.getOptionalBooleanProperty("distributedSlack").ifPresent(parameters::setDistributedSlack);
            config.getOptionalEnumProperty("balanceType", BalanceType.class).ifPresent(parameters::setBalanceType);
            config.getOptionalBooleanProperty("dcUseTranformerRatio").ifPresent(parameters::setDcUseTransformerRatio);
            config.getOptionalEnumSetProperty("contriesToBalance", Country.class).ifPresent(parameters::setCountriesToBalance);
            config.getOptionalEnumProperty("connectedComponentMode", ConnectedComponentMode.class).ifPresent(parameters::setConnectedComponentMode);
            config.getOptionalBooleanProperty("hvdcAcEmulation").ifPresent(parameters::setHvdcAcEmulation);
            config.getOptionalDoubleProperty("dcPowerFactor").ifPresent(parameters::setDcPowerFactor);
        });
    }

    public LoadFlowParameters() {
        this(ServiceLoader.load(LoadFlowDefaultParametersLoader.class).stream().map(ServiceLoader.Provider::get).toList());
    }

    public LoadFlowParameters(List<LoadFlowDefaultParametersLoader> defaultParametersLoaders) {
        int numberOfLoadersFound = Objects.requireNonNull(defaultParametersLoaders).size();
        if (numberOfLoadersFound > 1) {
            List<String> names = defaultParametersLoaders.stream().map(LoadFlowDefaultParametersLoader::getSourceName).toList();
            LOGGER.warn("Multiple default loadflow parameters classes have been found in the class path : {}. No default parameters file loaded", names);
        } else if (numberOfLoadersFound == 1) {
            LoadFlowDefaultParametersLoader loader = defaultParametersLoaders.get(0);
            JsonLoadFlowParameters.update(this, loader.loadDefaultParametersFromFile());
            LOGGER.debug("Default loadflow configuration has been updated using the reference file from parameters loader '{}'", (Object)loader.getSourceName());
        }
    }

    protected LoadFlowParameters(LoadFlowParameters other) {
        Objects.requireNonNull(other);
        this.voltageInitMode = other.voltageInitMode;
        this.transformerVoltageControlOn = other.transformerVoltageControlOn;
        this.useReactiveLimits = other.useReactiveLimits;
        this.phaseShifterRegulationOn = other.phaseShifterRegulationOn;
        this.twtSplitShuntAdmittance = other.twtSplitShuntAdmittance;
        this.shuntCompensatorVoltageControlOn = other.shuntCompensatorVoltageControlOn;
        this.readSlackBus = other.readSlackBus;
        this.writeSlackBus = other.writeSlackBus;
        this.dc = other.dc;
        this.distributedSlack = other.distributedSlack;
        this.balanceType = other.balanceType;
        this.dcUseTransformerRatio = other.dcUseTransformerRatio;
        this.countriesToBalance = other.countriesToBalance;
        this.connectedComponentMode = other.connectedComponentMode;
        this.hvdcAcEmulation = other.hvdcAcEmulation;
        this.dcPowerFactor = other.dcPowerFactor;
    }

    public VoltageInitMode getVoltageInitMode() {
        return this.voltageInitMode;
    }

    public LoadFlowParameters setVoltageInitMode(VoltageInitMode voltageInitMode) {
        this.voltageInitMode = Objects.requireNonNull(voltageInitMode);
        return this;
    }

    public boolean isTransformerVoltageControlOn() {
        return this.transformerVoltageControlOn;
    }

    public LoadFlowParameters setTransformerVoltageControlOn(boolean transformerVoltageControlOn) {
        this.transformerVoltageControlOn = transformerVoltageControlOn;
        return this;
    }

    public boolean isUseReactiveLimits() {
        return this.useReactiveLimits;
    }

    public LoadFlowParameters setUseReactiveLimits(boolean useReactiveLimits) {
        this.useReactiveLimits = useReactiveLimits;
        return this;
    }

    @Deprecated(since="5.1.0")
    public boolean isNoGeneratorReactiveLimits() {
        return !this.useReactiveLimits;
    }

    @Deprecated(since="5.1.0")
    public LoadFlowParameters setNoGeneratorReactiveLimits(boolean noGeneratorReactiveLimits) {
        this.useReactiveLimits = !noGeneratorReactiveLimits;
        return this;
    }

    public boolean isPhaseShifterRegulationOn() {
        return this.phaseShifterRegulationOn;
    }

    public LoadFlowParameters setPhaseShifterRegulationOn(boolean phaseShifterRegulationOn) {
        this.phaseShifterRegulationOn = phaseShifterRegulationOn;
        return this;
    }

    public boolean isTwtSplitShuntAdmittance() {
        return this.twtSplitShuntAdmittance;
    }

    public LoadFlowParameters setTwtSplitShuntAdmittance(boolean twtSplitShuntAdmittance) {
        this.twtSplitShuntAdmittance = twtSplitShuntAdmittance;
        return this;
    }

    @Deprecated(since="4.7.0")
    public boolean isSimulShunt() {
        return this.isShuntCompensatorVoltageControlOn();
    }

    public boolean isShuntCompensatorVoltageControlOn() {
        return this.shuntCompensatorVoltageControlOn;
    }

    @Deprecated(since="4.7.0")
    public LoadFlowParameters setSimulShunt(boolean simulShunt) {
        return this.setShuntCompensatorVoltageControlOn(simulShunt);
    }

    public LoadFlowParameters setShuntCompensatorVoltageControlOn(boolean shuntCompensatorVoltageControlOn) {
        this.shuntCompensatorVoltageControlOn = shuntCompensatorVoltageControlOn;
        return this;
    }

    public boolean isReadSlackBus() {
        return this.readSlackBus;
    }

    public LoadFlowParameters setReadSlackBus(boolean readSlackBus) {
        this.readSlackBus = readSlackBus;
        return this;
    }

    public boolean isWriteSlackBus() {
        return this.writeSlackBus;
    }

    public LoadFlowParameters setWriteSlackBus(boolean writeSlackBus) {
        this.writeSlackBus = writeSlackBus;
        return this;
    }

    public boolean isDc() {
        return this.dc;
    }

    public LoadFlowParameters setDc(boolean dc) {
        this.dc = dc;
        return this;
    }

    public boolean isDistributedSlack() {
        return this.distributedSlack;
    }

    public LoadFlowParameters setDistributedSlack(boolean distributedSlack) {
        this.distributedSlack = distributedSlack;
        return this;
    }

    public LoadFlowParameters setBalanceType(BalanceType balanceType) {
        this.balanceType = Objects.requireNonNull(balanceType);
        return this;
    }

    public BalanceType getBalanceType() {
        return this.balanceType;
    }

    public LoadFlowParameters setDcUseTransformerRatio(boolean dcUseTransformerRatio) {
        this.dcUseTransformerRatio = dcUseTransformerRatio;
        return this;
    }

    public boolean isDcUseTransformerRatio() {
        return this.dcUseTransformerRatio;
    }

    public LoadFlowParameters setCountriesToBalance(Set<Country> countriesToBalance) {
        this.countriesToBalance = Collections.unmodifiableSet(new HashSet(Objects.requireNonNull(countriesToBalance)));
        return this;
    }

    public Set<Country> getCountriesToBalance() {
        return Collections.unmodifiableSet(this.countriesToBalance);
    }

    public ConnectedComponentMode getConnectedComponentMode() {
        return this.connectedComponentMode;
    }

    public LoadFlowParameters setConnectedComponentMode(ConnectedComponentMode connectedComponentMode) {
        this.connectedComponentMode = connectedComponentMode;
        return this;
    }

    public boolean isHvdcAcEmulation() {
        return this.hvdcAcEmulation;
    }

    public LoadFlowParameters setHvdcAcEmulation(boolean hvdcAcEmulation) {
        this.hvdcAcEmulation = hvdcAcEmulation;
        return this;
    }

    public double getDcPowerFactor() {
        return this.dcPowerFactor;
    }

    public LoadFlowParameters setDcPowerFactor(double dcPowerFactor) {
        if (dcPowerFactor <= 0.0 || dcPowerFactor > 1.0) {
            throw new IllegalArgumentException("Invalid DC power factor: " + dcPowerFactor);
        }
        this.dcPowerFactor = dcPowerFactor;
        return this;
    }

    public Map<String, Object> toMap() {
        return ImmutableMap.builder().put((Object)"voltageInitMode", (Object)this.voltageInitMode).put((Object)"transformerVoltageControlOn", (Object)this.transformerVoltageControlOn).put((Object)"useReactiveLimits", (Object)this.useReactiveLimits).put((Object)"phaseShifterRegulationOn", (Object)this.phaseShifterRegulationOn).put((Object)"twtSplitShuntAdmittance", (Object)this.twtSplitShuntAdmittance).put((Object)"shuntCompensatorVoltageControlOn", (Object)this.shuntCompensatorVoltageControlOn).put((Object)"readSlackBus", (Object)this.readSlackBus).put((Object)"writeSlackBus", (Object)this.writeSlackBus).put((Object)"dc", (Object)this.dc).put((Object)"distributedSlack", (Object)this.distributedSlack).put((Object)"balanceType", (Object)this.balanceType).put((Object)"dcUseTransformerRatio", (Object)this.dcUseTransformerRatio).put((Object)"countriesToBalance", this.countriesToBalance).put((Object)"computedConnectedComponentScope", (Object)this.connectedComponentMode).put((Object)"hvdcAcEmulation", (Object)this.hvdcAcEmulation).put((Object)"dcPowerFactor", (Object)this.dcPowerFactor).build();
    }

    public LoadFlowParameters copy() {
        LoadFlowParameters loadFlowParameters;
        byte[] bytes = this.writeInMemory();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            loadFlowParameters = JsonLoadFlowParameters.read(bais);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        bais.close();
        return loadFlowParameters;
    }

    private byte[] writeInMemory() {
        try (ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder();){
            JsonLoadFlowParameters.write(this, (OutputStream)byteArrayBuilder);
            byte[] byArray = byteArrayBuilder.toByteArray();
            return byArray;
        }
    }

    public String toString() {
        return this.toMap().toString();
    }

    private void loadExtensions(PlatformConfig platformConfig) {
        for (LoadFlowProvider provider : new ServiceLoaderCache(LoadFlowProvider.class).getServices()) {
            provider.loadSpecificParameters(platformConfig).ifPresent(extension -> this.addExtension(extension.getClass(), (Extension)extension));
        }
    }

    public static enum VoltageInitMode {
        UNIFORM_VALUES,
        PREVIOUS_VALUES,
        DC_VALUES;

    }

    public static enum BalanceType {
        PROPORTIONAL_TO_GENERATION_P,
        PROPORTIONAL_TO_GENERATION_P_MAX,
        PROPORTIONAL_TO_GENERATION_REMAINING_MARGIN,
        PROPORTIONAL_TO_GENERATION_PARTICIPATION_FACTOR,
        PROPORTIONAL_TO_LOAD,
        PROPORTIONAL_TO_CONFORM_LOAD;

    }

    public static enum ConnectedComponentMode {
        MAIN,
        ALL;

    }
}

