/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.network.Country;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.json.JsonLoadFlowParameters;
import java.io.IOException;

public class LoadFlowParametersSerializer
extends StdSerializer<LoadFlowParameters> {
    LoadFlowParametersSerializer() {
        super(LoadFlowParameters.class);
    }

    public void serialize(LoadFlowParameters parameters, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("version", "1.9");
        jsonGenerator.writeStringField("voltageInitMode", parameters.getVoltageInitMode().name());
        jsonGenerator.writeBooleanField("transformerVoltageControlOn", parameters.isTransformerVoltageControlOn());
        jsonGenerator.writeBooleanField("phaseShifterRegulationOn", parameters.isPhaseShifterRegulationOn());
        jsonGenerator.writeBooleanField("useReactiveLimits", parameters.isUseReactiveLimits());
        jsonGenerator.writeBooleanField("twtSplitShuntAdmittance", parameters.isTwtSplitShuntAdmittance());
        jsonGenerator.writeBooleanField("shuntCompensatorVoltageControlOn", parameters.isShuntCompensatorVoltageControlOn());
        jsonGenerator.writeBooleanField("readSlackBus", parameters.isReadSlackBus());
        jsonGenerator.writeBooleanField("writeSlackBus", parameters.isWriteSlackBus());
        jsonGenerator.writeBooleanField("dc", parameters.isDc());
        jsonGenerator.writeBooleanField("distributedSlack", parameters.isDistributedSlack());
        jsonGenerator.writeStringField("balanceType", parameters.getBalanceType().name());
        jsonGenerator.writeBooleanField("dcUseTransformerRatio", parameters.isDcUseTransformerRatio());
        jsonGenerator.writeArrayFieldStart("countriesToBalance");
        for (Country arg : parameters.getCountriesToBalance()) {
            jsonGenerator.writeString(arg.name());
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeStringField("connectedComponentMode", parameters.getConnectedComponentMode().name());
        jsonGenerator.writeBooleanField("hvdcAcEmulation", parameters.isHvdcAcEmulation());
        jsonGenerator.writeNumberField("dcPowerFactor", parameters.getDcPowerFactor());
        JsonUtil.writeExtensions((Extendable)parameters, (JsonGenerator)jsonGenerator, (SerializerProvider)serializerProvider, JsonLoadFlowParameters.getExtensionSerializers()::get);
        jsonGenerator.writeEndObject();
    }
}

