/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.loadflow.LoadFlowResultImpl;
import com.powsybl.loadflow.json.LoadFlowResultJsonModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LoadFlowResultDeserializer
extends StdDeserializer<LoadFlowResult> {
    private static final String CONTEXT_NAME = "LoadFlowResult";
    public static final String UNEXPECTED_FIELD = "Unexpected field: ";

    LoadFlowResultDeserializer() {
        super(LoadFlowResult.class);
    }

    public LoadFlowResult.ComponentResult deserializeComponentResult(JsonParser parser, String version) throws IOException {
        Integer connectedComponentNum = null;
        Integer synchronousComponentNum = null;
        LoadFlowResult.ComponentResult.Status status = null;
        String statusText = null;
        Map metrics = Collections.emptyMap();
        Integer iterationCount = null;
        List<LoadFlowResult.SlackBusResult> slackBusResults = new ArrayList<LoadFlowResult.SlackBusResult>();
        String referenceBusId = null;
        String slackBusId = null;
        Double slackBusActivePowerMismatch = null;
        Double distributedActivePower = null;
        block28: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.currentName()) {
                case "connectedComponentNum": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)LoadFlowResultDeserializer.class.getName(), (String)parser.currentName(), (String)version, (String)"1.2");
                    parser.nextToken();
                    connectedComponentNum = parser.getValueAsInt();
                    continue block28;
                }
                case "synchronousComponentNum": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)LoadFlowResultDeserializer.class.getName(), (String)parser.currentName(), (String)version, (String)"1.2");
                    parser.nextToken();
                    synchronousComponentNum = parser.getValueAsInt();
                    continue block28;
                }
                case "componentNum": {
                    JsonUtil.assertLessThanReferenceVersion((String)LoadFlowResultDeserializer.class.getName(), (String)parser.currentName(), (String)version, (String)"1.2");
                    parser.nextToken();
                    synchronousComponentNum = parser.getValueAsInt();
                    continue block28;
                }
                case "status": {
                    parser.nextToken();
                    String tempStatus = parser.getValueAsString();
                    if (version.compareTo("1.4") < 0 && "SOLVER_FAILED".equals(tempStatus)) {
                        statusText = tempStatus;
                        tempStatus = LoadFlowResult.ComponentResult.Status.FAILED.name();
                    }
                    status = LoadFlowResult.ComponentResult.Status.valueOf(tempStatus);
                    continue block28;
                }
                case "statusText": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: statusText", (String)version, (String)"1.4");
                    parser.nextToken();
                    statusText = parser.getValueAsString();
                    continue block28;
                }
                case "metrics": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: metrics", (String)version, (String)"1.4");
                    parser.nextToken();
                    metrics = (Map)parser.readValueAs(HashMap.class);
                    continue block28;
                }
                case "iterationCount": {
                    parser.nextToken();
                    iterationCount = parser.getValueAsInt();
                    continue block28;
                }
                case "referenceBusId": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: referenceBusId", (String)version, (String)"1.4");
                    parser.nextToken();
                    referenceBusId = parser.getValueAsString();
                    continue block28;
                }
                case "slackBusResults": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: slackBusResults", (String)version, (String)"1.4");
                    parser.nextToken();
                    this.deserializeSlackBusResults(parser, slackBusResults);
                    continue block28;
                }
                case "slackBusId": {
                    JsonUtil.assertLessThanReferenceVersion((String)LoadFlowResultDeserializer.class.getName(), (String)parser.currentName(), (String)version, (String)"1.4");
                    parser.nextToken();
                    slackBusId = parser.getValueAsString();
                    continue block28;
                }
                case "slackBusActivePowerMismatch": {
                    JsonUtil.assertLessThanReferenceVersion((String)LoadFlowResultDeserializer.class.getName(), (String)parser.currentName(), (String)version, (String)"1.4");
                    parser.nextToken();
                    slackBusActivePowerMismatch = parser.getValueAsDouble();
                    continue block28;
                }
                case "distributedActivePower": {
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)LoadFlowResultDeserializer.class.getName(), (String)parser.currentName(), (String)version, (String)"1.3");
                    parser.nextToken();
                    distributedActivePower = parser.getValueAsDouble();
                    continue block28;
                }
            }
            throw new IllegalStateException(UNEXPECTED_FIELD + parser.currentName());
        }
        if (connectedComponentNum == null) {
            if (version.compareTo("1.2") < 0) {
                connectedComponentNum = 0;
            } else {
                throw new IllegalStateException("Connected component number field not found.");
            }
        }
        if (synchronousComponentNum == null) {
            throw new IllegalStateException("Synchronous component number field not found.");
        }
        if (iterationCount == null) {
            throw new IllegalStateException("Iteration count field not found.");
        }
        if (distributedActivePower == null) {
            if (version.compareTo("1.3") < 0) {
                distributedActivePower = Double.NaN;
            } else {
                throw new IllegalStateException("Distributed active power field not found.");
            }
        }
        if (version.compareTo("1.4") < 0) {
            if (slackBusId == null) {
                throw new IllegalStateException("Slack bus id field not found.");
            }
            if (slackBusActivePowerMismatch == null) {
                throw new IllegalStateException("Slack bus active power mismatch field not found.");
            }
            referenceBusId = slackBusId;
            slackBusResults = List.of(new LoadFlowResultImpl.SlackBusResultImpl(slackBusId, slackBusActivePowerMismatch));
        }
        return new LoadFlowResultImpl.ComponentResultImpl(connectedComponentNum, synchronousComponentNum, status, statusText, metrics, iterationCount, referenceBusId, slackBusResults, distributedActivePower);
    }

    public LoadFlowResult.SlackBusResult deserializeSlackBusResult(JsonParser parser) throws IOException {
        String id = null;
        Double activePowerMismatch = null;
        block8: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.currentName()) {
                case "id": {
                    parser.nextToken();
                    id = parser.getValueAsString();
                    continue block8;
                }
                case "activePowerMismatch": {
                    parser.nextToken();
                    activePowerMismatch = parser.getValueAsDouble();
                    continue block8;
                }
            }
            throw new IllegalStateException(UNEXPECTED_FIELD + parser.currentName());
        }
        if (id == null) {
            throw new IllegalStateException("Slack bus result: id field not found.");
        }
        if (activePowerMismatch == null) {
            throw new IllegalStateException("Slack bus result: active power mismatch field not found.");
        }
        return new LoadFlowResultImpl.SlackBusResultImpl(id, activePowerMismatch);
    }

    public void deserializeComponentResults(JsonParser parser, List<LoadFlowResult.ComponentResult> componentResults, String version) throws IOException {
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            componentResults.add(this.deserializeComponentResult(parser, version));
        }
    }

    public void deserializeSlackBusResults(JsonParser parser, List<LoadFlowResult.SlackBusResult> slackBusResults) throws IOException {
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            slackBusResults.add(this.deserializeSlackBusResult(parser));
        }
    }

    public LoadFlowResult deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        String version = null;
        Boolean ok = null;
        Map metrics = null;
        String log = null;
        ArrayList<LoadFlowResult.ComponentResult> componentResults = new ArrayList<LoadFlowResult.ComponentResult>();
        block12: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.currentName()) {
                case "version": {
                    parser.nextToken();
                    version = parser.getValueAsString();
                    continue block12;
                }
                case "isOK": {
                    parser.nextToken();
                    ok = (Boolean)parser.readValueAs(Boolean.class);
                    continue block12;
                }
                case "metrics": {
                    parser.nextToken();
                    metrics = (Map)parser.readValueAs(HashMap.class);
                    continue block12;
                }
                case "componentResults": {
                    JsonUtil.assertGreaterThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: componentResults", version, (String)"1.0");
                    parser.nextToken();
                    this.deserializeComponentResults(parser, componentResults, version);
                    continue block12;
                }
            }
            throw new IllegalStateException(UNEXPECTED_FIELD + parser.currentName());
        }
        if (ok == null) {
            throw new IllegalStateException("Ok field not found");
        }
        return new LoadFlowResultImpl(ok, metrics, log, componentResults);
    }

    public static LoadFlowResult read(InputStream is) throws IOException {
        Objects.requireNonNull(is);
        ObjectMapper objectMapper = JsonUtil.createObjectMapper();
        objectMapper.registerModule((Module)new LoadFlowResultJsonModule());
        return (LoadFlowResult)objectMapper.readValue(is, LoadFlowResult.class);
    }

    public static LoadFlowResult read(Path jsonFile) {
        LoadFlowResult loadFlowResult;
        block8: {
            Objects.requireNonNull(jsonFile);
            InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);
            try {
                loadFlowResult = LoadFlowResultDeserializer.read(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return loadFlowResult;
    }
}

