/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface LoadFlowResult {
    @Deprecated(since="6.1.0")
    public boolean isOk();

    public Status getStatus();

    default public boolean isFullyConverged() {
        return Status.FULLY_CONVERGED.equals((Object)this.getStatus());
    }

    default public boolean isPartiallyConverged() {
        return Status.PARTIALLY_CONVERGED.equals((Object)this.getStatus());
    }

    default public boolean isFailed() {
        return Status.FAILED.equals((Object)this.getStatus());
    }

    public Map<String, String> getMetrics();

    public String getLogs();

    default public List<ComponentResult> getComponentResults() {
        return Collections.emptyList();
    }

    public static enum Status {
        FULLY_CONVERGED,
        PARTIALLY_CONVERGED,
        FAILED;

    }

    public static interface ComponentResult {
        public int getConnectedComponentNum();

        public int getSynchronousComponentNum();

        public Status getStatus();

        public String getStatusText();

        public Map<String, String> getMetrics();

        public int getIterationCount();

        public String getReferenceBusId();

        public List<SlackBusResult> getSlackBusResults();

        @Deprecated(since="6.1.0")
        public String getSlackBusId();

        @Deprecated(since="6.1.0")
        public double getSlackBusActivePowerMismatch();

        public double getDistributedActivePower();

        public static enum Status {
            CONVERGED,
            MAX_ITERATION_REACHED,
            FAILED,
            NO_CALCULATION;

        }
    }

    public static interface SlackBusResult {
        public String getId();

        public double getActivePowerMismatch();
    }
}

