/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow;

import com.powsybl.loadflow.LoadFlowResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LoadFlowResultImpl
implements LoadFlowResult {
    private final boolean ok;
    private final LoadFlowResult.Status status;
    private final Map<String, String> metrics;
    private final String logs;
    private final List<LoadFlowResult.ComponentResult> componentResults;

    public LoadFlowResultImpl(boolean ok, Map<String, String> metrics, String logs) {
        this(ok, metrics, logs, Collections.emptyList());
    }

    public LoadFlowResultImpl(boolean ok, Map<String, String> metrics, String logs, List<LoadFlowResult.ComponentResult> componentResults) {
        this.ok = ok;
        this.metrics = Objects.requireNonNull(metrics);
        this.logs = logs;
        this.componentResults = Objects.requireNonNull(componentResults);
        this.status = this.computeStatus(componentResults);
    }

    private LoadFlowResult.Status computeStatus(List<LoadFlowResult.ComponentResult> componentResults) {
        int convergedCount = 0;
        int maxIterOrFailedCount = 0;
        for (LoadFlowResult.ComponentResult componentResult : componentResults) {
            LoadFlowResult.ComponentResult.Status componentResultStatus = Objects.requireNonNull(componentResult.getStatus());
            if (componentResultStatus == LoadFlowResult.ComponentResult.Status.CONVERGED) {
                ++convergedCount;
                continue;
            }
            if (componentResultStatus != LoadFlowResult.ComponentResult.Status.MAX_ITERATION_REACHED && componentResultStatus != LoadFlowResult.ComponentResult.Status.FAILED) continue;
            ++maxIterOrFailedCount;
        }
        if (convergedCount == 0) {
            return LoadFlowResult.Status.FAILED;
        }
        if (maxIterOrFailedCount > 0) {
            return LoadFlowResult.Status.PARTIALLY_CONVERGED;
        }
        return LoadFlowResult.Status.FULLY_CONVERGED;
    }

    @Override
    public boolean isOk() {
        return this.ok;
    }

    @Override
    public LoadFlowResult.Status getStatus() {
        return this.status;
    }

    @Override
    public Map<String, String> getMetrics() {
        return this.metrics;
    }

    @Override
    public String getLogs() {
        return this.logs;
    }

    @Override
    public List<LoadFlowResult.ComponentResult> getComponentResults() {
        return Collections.unmodifiableList(this.componentResults);
    }

    public static class ComponentResultImpl
    implements LoadFlowResult.ComponentResult {
        private final int connectedComponentNum;
        private final int synchronousComponentNum;
        private final LoadFlowResult.ComponentResult.Status status;
        private final String statusText;
        private final Map<String, String> metrics;
        private final int iterationCount;
        private final String referenceBusId;
        private final List<LoadFlowResult.SlackBusResult> slackBusResults;
        private final double distributedActivePower;

        public ComponentResultImpl(int connectedComponentNum, int synchronousComponentNum, LoadFlowResult.ComponentResult.Status status, int iterationCount, String slackBusId, double slackBusActivePowerMismatch, double distributedActivePower) {
            this.connectedComponentNum = ComponentResultImpl.checkComponentNum(connectedComponentNum);
            this.synchronousComponentNum = ComponentResultImpl.checkComponentNum(synchronousComponentNum);
            this.status = Objects.requireNonNull(status);
            this.statusText = status.name();
            this.metrics = Collections.emptyMap();
            this.iterationCount = ComponentResultImpl.checkIterationCount(iterationCount);
            this.referenceBusId = slackBusId;
            this.slackBusResults = Collections.singletonList(new SlackBusResultImpl(slackBusId, slackBusActivePowerMismatch));
            this.distributedActivePower = distributedActivePower;
        }

        public ComponentResultImpl(int connectedComponentNum, int synchronousComponentNum, LoadFlowResult.ComponentResult.Status status, String statusText, Map<String, String> metrics, int iterationCount, String referenceBusId, List<LoadFlowResult.SlackBusResult> slackBusResults, double distributedActivePower) {
            this.connectedComponentNum = ComponentResultImpl.checkComponentNum(connectedComponentNum);
            this.synchronousComponentNum = ComponentResultImpl.checkComponentNum(synchronousComponentNum);
            this.status = Objects.requireNonNull(status);
            this.statusText = Objects.requireNonNullElse(statusText, status.name());
            this.metrics = Objects.requireNonNull(metrics);
            this.iterationCount = ComponentResultImpl.checkIterationCount(iterationCount);
            this.referenceBusId = referenceBusId;
            this.slackBusResults = Objects.requireNonNull(slackBusResults);
            this.distributedActivePower = distributedActivePower;
        }

        private static int checkComponentNum(int componentNum) {
            if (componentNum < 0) {
                throw new IllegalArgumentException("Invalid component number: " + componentNum);
            }
            return componentNum;
        }

        private static int checkIterationCount(int iterationCount) {
            if (iterationCount < 0) {
                throw new IllegalArgumentException("Invalid iteration count: " + iterationCount);
            }
            return iterationCount;
        }

        @Override
        public int getConnectedComponentNum() {
            return this.connectedComponentNum;
        }

        @Override
        public int getSynchronousComponentNum() {
            return this.synchronousComponentNum;
        }

        @Override
        public LoadFlowResult.ComponentResult.Status getStatus() {
            return this.status;
        }

        @Override
        public String getStatusText() {
            return this.statusText;
        }

        @Override
        public Map<String, String> getMetrics() {
            return this.metrics;
        }

        @Override
        public int getIterationCount() {
            return this.iterationCount;
        }

        @Override
        public String getReferenceBusId() {
            return this.referenceBusId;
        }

        @Override
        public List<LoadFlowResult.SlackBusResult> getSlackBusResults() {
            return Collections.unmodifiableList(this.slackBusResults);
        }

        @Override
        public String getSlackBusId() {
            if (this.slackBusResults.isEmpty()) {
                return "";
            }
            if (this.slackBusResults.size() == 1) {
                return this.slackBusResults.get(0).getId();
            }
            throw new IllegalStateException("Deprecated method: cannot return a value in the case of multiple slack results. Please migrate to new API.");
        }

        @Override
        public double getSlackBusActivePowerMismatch() {
            if (this.slackBusResults.isEmpty()) {
                return 0.0;
            }
            if (this.slackBusResults.size() == 1) {
                return this.slackBusResults.get(0).getActivePowerMismatch();
            }
            throw new IllegalStateException("Deprecated method: cannot return a value in the case of multiple slack results. Please migrate to new API.");
        }

        @Override
        public double getDistributedActivePower() {
            return this.distributedActivePower;
        }
    }

    public static class SlackBusResultImpl
    implements LoadFlowResult.SlackBusResult {
        private final String id;
        private final double activePowerMismatch;

        public SlackBusResultImpl(String id, double activePowerMismatch) {
            this.id = Objects.requireNonNull(id);
            this.activePowerMismatch = activePowerMismatch;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public double getActivePowerMismatch() {
            return this.activePowerMismatch;
        }
    }
}

