/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.tools;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.io.table.AsciiTableFormatterFactory;
import com.powsybl.commons.io.table.Column;
import com.powsybl.commons.io.table.CsvTableFormatterFactory;
import com.powsybl.commons.io.table.TableFormatter;
import com.powsybl.commons.io.table.TableFormatterConfig;
import com.powsybl.commons.io.table.TableFormatterFactory;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.network.Exporter;
import com.powsybl.iidm.network.ImportConfig;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.tools.ConversionToolUtils;
import com.powsybl.loadflow.LoadFlow;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.loadflow.json.JsonLoadFlowParameters;
import com.powsybl.loadflow.json.LoadFlowResultSerializer;
import com.powsybl.tools.Command;
import com.powsybl.tools.Tool;
import com.powsybl.tools.ToolRunningContext;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@AutoService(value={Tool.class})
public class RunLoadFlowTool
implements Tool {
    private static final String CASE_FILE = "case-file";
    private static final String PARAMETERS_FILE = "parameters-file";
    private static final String OUTPUT_FILE = "output-file";
    private static final String OUTPUT_FORMAT = "output-format";
    private static final String OUTPUT_CASE_FORMAT = "output-case-format";
    private static final String OUTPUT_CASE_FILE = "output-case-file";

    public Command getCommand() {
        return new Command(){

            public String getName() {
                return "loadflow";
            }

            public String getTheme() {
                return "Computation";
            }

            public String getDescription() {
                return "Run loadflow";
            }

            public Options getOptions() {
                Options options = new Options();
                options.addOption(Option.builder().longOpt(RunLoadFlowTool.CASE_FILE).desc("the case path").hasArg().argName("FILE").required().build());
                options.addOption(Option.builder().longOpt(RunLoadFlowTool.PARAMETERS_FILE).desc("loadflow parameters as JSON file").hasArg().argName("FILE").build());
                options.addOption(Option.builder().longOpt(RunLoadFlowTool.OUTPUT_FILE).desc("loadflow results output path").hasArg().argName("FILE").build());
                options.addOption(Option.builder().longOpt(RunLoadFlowTool.OUTPUT_FORMAT).desc("loadflow results output format " + Arrays.toString((Object[])Format.values())).hasArg().argName("FORMAT").build());
                options.addOption(Option.builder().longOpt(RunLoadFlowTool.OUTPUT_CASE_FORMAT).desc("modified network output format " + Exporter.getFormats()).hasArg().argName("CASEFORMAT").build());
                options.addOption(Option.builder().longOpt(RunLoadFlowTool.OUTPUT_CASE_FILE).desc("modified network base name").hasArg().argName("FILE").build());
                options.addOption(ConversionToolUtils.createImportParametersFileOption());
                options.addOption(ConversionToolUtils.createImportParameterOption());
                options.addOption(ConversionToolUtils.createExportParametersFileOption());
                options.addOption(ConversionToolUtils.createExportParameterOption());
                return options;
            }

            public String getUsageFooter() {
                return null;
            }
        };
    }

    public void run(CommandLine line, ToolRunningContext context) throws Exception {
        Path caseFile = context.getFileSystem().getPath(line.getOptionValue(CASE_FILE), new String[0]);
        Path outputFile = null;
        Format format = null;
        Path outputCaseFile = null;
        if (line.hasOption(OUTPUT_FILE)) {
            outputFile = context.getFileSystem().getPath(line.getOptionValue(OUTPUT_FILE), new String[0]);
            if (!line.hasOption(OUTPUT_FORMAT)) {
                throw new ParseException("Missing required option: output-format");
            }
            format = Format.valueOf(line.getOptionValue(OUTPUT_FORMAT));
        }
        if (line.hasOption(OUTPUT_CASE_FILE)) {
            outputCaseFile = context.getFileSystem().getPath(line.getOptionValue(OUTPUT_CASE_FILE), new String[0]);
            if (!line.hasOption(OUTPUT_CASE_FORMAT)) {
                throw new ParseException("Missing required option: output-case-format");
            }
        }
        context.getOutputStream().println("Loading network '" + caseFile + "'");
        Properties inputParams = ConversionToolUtils.readProperties((CommandLine)line, (ConversionToolUtils.OptionType)ConversionToolUtils.OptionType.IMPORT, (ToolRunningContext)context);
        Network network = Network.read((Path)caseFile, (ComputationManager)context.getShortTimeExecutionComputationManager(), (ImportConfig)ImportConfig.load(), (Properties)inputParams);
        if (network == null) {
            throw new PowsyblException("Case '" + caseFile + "' not found");
        }
        LoadFlowParameters params = LoadFlowParameters.load();
        if (line.hasOption(PARAMETERS_FILE)) {
            Path parametersFile = context.getFileSystem().getPath(line.getOptionValue(PARAMETERS_FILE), new String[0]);
            JsonLoadFlowParameters.update(params, parametersFile);
        }
        LoadFlowResult result = LoadFlow.run(network, context.getShortTimeExecutionComputationManager(), params);
        if (outputFile != null) {
            this.exportResult(result, context, outputFile, format);
        } else {
            this.printResult(result, context);
        }
        if (outputCaseFile != null) {
            String outputCaseFormat = line.getOptionValue(OUTPUT_CASE_FORMAT);
            Properties outputParams = ConversionToolUtils.readProperties((CommandLine)line, (ConversionToolUtils.OptionType)ConversionToolUtils.OptionType.EXPORT, (ToolRunningContext)context);
            network.write(outputCaseFormat, outputParams, outputCaseFile);
        }
    }

    private void printLoadFlowResult(LoadFlowResult result, Path outputFile, TableFormatterFactory formatterFactory, TableFormatterConfig formatterConfig) {
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            RunLoadFlowTool.printLoadFlowResult(result, writer, formatterFactory, formatterConfig);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static void printLoadFlowResult(LoadFlowResult result, Writer writer, TableFormatterFactory formatterFactory, TableFormatterConfig formatterConfig) {
        try (TableFormatter formatter = formatterFactory.create(writer, "Loadflow results", formatterConfig, new Column[]{new Column("Ok"), new Column("Status"), new Column("Metrics")});){
            formatter.writeCell(result.isOk());
            formatter.writeCell(result.getStatus().name());
            formatter.writeCell(result.getMetrics().toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        String csvSeparator = String.valueOf(formatterConfig.getCsvSeparator());
        if (!result.getComponentResults().isEmpty()) {
            try (TableFormatter formatter = formatterFactory.create(writer, "Components results", formatterConfig, new Column[]{new Column("Connected component"), new Column("Synchronous component"), new Column("Status"), new Column("Status text"), new Column("Metrics"), new Column("Iteration count"), new Column("Slack bus ID"), new Column("Slack bus mismatch (MW)"), new Column("Distributed Active Power (MW)")});){
                for (LoadFlowResult.ComponentResult componentResult : result.getComponentResults()) {
                    formatter.writeCell(componentResult.getConnectedComponentNum());
                    formatter.writeCell(componentResult.getSynchronousComponentNum());
                    formatter.writeCell(componentResult.getStatus().name());
                    formatter.writeCell(componentResult.getStatusText());
                    formatter.writeCell(componentResult.getMetrics().toString());
                    formatter.writeCell(componentResult.getIterationCount());
                    formatter.writeCell(componentResult.getSlackBusResults().stream().map(LoadFlowResult.SlackBusResult::getId).collect(Collectors.joining(csvSeparator)));
                    formatter.writeCell(componentResult.getSlackBusResults().stream().map(sbr -> String.format(formatterConfig.getLocale(), "%.2f", sbr.getActivePowerMismatch())).collect(Collectors.joining(csvSeparator)));
                    formatter.writeCell(componentResult.getDistributedActivePower());
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void printResult(LoadFlowResult result, ToolRunningContext context) {
        OutputStreamWriter writer = new OutputStreamWriter(context.getOutputStream());
        AsciiTableFormatterFactory asciiTableFormatterFactory = new AsciiTableFormatterFactory();
        RunLoadFlowTool.printLoadFlowResult(result, writer, (TableFormatterFactory)asciiTableFormatterFactory, TableFormatterConfig.load());
    }

    private void exportResult(LoadFlowResult result, ToolRunningContext context, Path outputFile, Format format) {
        context.getOutputStream().println("Writing results to '" + outputFile + "'");
        switch (format) {
            case CSV: {
                CsvTableFormatterFactory csvTableFormatterFactory = new CsvTableFormatterFactory();
                this.printLoadFlowResult(result, outputFile, (TableFormatterFactory)csvTableFormatterFactory, TableFormatterConfig.load());
                break;
            }
            case JSON: {
                LoadFlowResultSerializer.write(result, outputFile);
            }
        }
    }

    private static enum Format {
        CSV,
        JSON;

    }
}

