/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.local.LocalComputationManager;
import com.powsybl.loadflow.LoadFlowParameters;
import java.util.Objects;
import java.util.function.Supplier;

public class LoadFlowRunParameters {
    private static final Supplier<ComputationManager> DEFAULT_COMPUTATION_MANAGER_SUPPLIER = LocalComputationManager::getDefault;
    private static final Supplier<LoadFlowParameters> DEFAULT_LOAD_FLOW_PARAMETERS_SUPPLIER = LoadFlowParameters::load;
    private LoadFlowParameters parameters;
    private ComputationManager computationManager;
    private ReportNode reportNode = ReportNode.NO_OP;

    public static LoadFlowRunParameters getDefault() {
        return new LoadFlowRunParameters().setParameters(DEFAULT_LOAD_FLOW_PARAMETERS_SUPPLIER.get()).setComputationManager(DEFAULT_COMPUTATION_MANAGER_SUPPLIER.get());
    }

    public LoadFlowParameters getLoadFlowParameters() {
        if (this.parameters == null) {
            this.setParameters(DEFAULT_LOAD_FLOW_PARAMETERS_SUPPLIER.get());
        }
        return this.parameters;
    }

    public ComputationManager getComputationManager() {
        if (this.computationManager == null) {
            this.setComputationManager(DEFAULT_COMPUTATION_MANAGER_SUPPLIER.get());
        }
        return this.computationManager;
    }

    public ReportNode getReportNode() {
        return this.reportNode;
    }

    public LoadFlowRunParameters setParameters(LoadFlowParameters parameters) {
        Objects.requireNonNull(parameters, "LoadFlowRunParameters should not be null");
        this.parameters = parameters;
        return this;
    }

    public LoadFlowRunParameters setComputationManager(ComputationManager computationManager) {
        Objects.requireNonNull(computationManager, "ComputationManager should not be null");
        this.computationManager = computationManager;
        return this;
    }

    public LoadFlowRunParameters setReportNode(ReportNode reportNode) {
        Objects.requireNonNull(reportNode, "ReportNode should not be null");
        this.reportNode = reportNode;
        return this;
    }
}

