/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.resultscompletion;

import com.google.auto.service.AutoService;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerPhaseAngleClock;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerPhaseAngleClock;
import com.powsybl.iidm.network.util.BranchData;
import com.powsybl.iidm.network.util.TwtData;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.resultscompletion.LoadFlowResultsCompletionParameters;
import com.powsybl.loadflow.resultscompletion.z0flows.Z0FlowsCompletion;
import com.powsybl.loadflow.resultscompletion.z0flows.Z0LineChecker;
import com.powsybl.loadflow.validation.CandidateComputation;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={CandidateComputation.class})
public class LoadFlowResultsCompletion
implements CandidateComputation {
    public static final String NAME = "loadflowResultsCompletion";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadFlowResultsCompletion.class);
    private final LoadFlowResultsCompletionParameters parameters;
    private final LoadFlowParameters lfParameters;
    private final Z0LineChecker z0checker;

    public LoadFlowResultsCompletion(LoadFlowResultsCompletionParameters parameters, LoadFlowParameters lfParameters) {
        this.parameters = Objects.requireNonNull(parameters);
        this.lfParameters = Objects.requireNonNull(lfParameters);
        this.z0checker = l -> {
            boolean r;
            if (!l.getTerminal1().isConnected() || !l.getTerminal2().isConnected()) {
                return false;
            }
            Bus b1 = l.getTerminal1().getBusView().getBus();
            Bus b2 = l.getTerminal2().getBusView().getBus();
            Objects.requireNonNull(b1);
            Objects.requireNonNull(b2);
            double threshold = parameters.getZ0ThresholdDiffVoltageAngle();
            boolean bl = r = Math.abs(b1.getV() - b2.getV()) < threshold && Math.abs(b1.getAngle() - b2.getAngle()) < threshold;
            if (r) {
                LOGGER.debug("Line Z0 {} ({}) dV = {}, dA = {}", new Object[]{l.getNameOrId(), l.getId(), Math.abs(b1.getV() - b2.getV()), Math.abs(b1.getAngle() - b2.getAngle())});
            }
            return r;
        };
    }

    public LoadFlowResultsCompletion() {
        this(LoadFlowResultsCompletionParameters.load(), LoadFlowParameters.load());
    }

    public Z0LineChecker z0checker() {
        return this.z0checker;
    }

    public String getName() {
        return NAME;
    }

    public void run(Network network, ComputationManager computationManager) {
        Objects.requireNonNull(network);
        LOGGER.info("Running {} on network {}, variant {}", new Object[]{this.getName(), network.getId(), network.getVariantManager().getWorkingVariantId()});
        LOGGER.info("LoadFlowResultsCompletionParameters={}", (Object)this.parameters);
        LOGGER.info("LoadFlowParameters={}", (Object)this.lfParameters);
        network.getLoadStream().forEach(load -> this.completeTerminalData(load.getTerminal(), (Load)load));
        network.getGeneratorStream().forEach(generator -> this.completeTerminalData(generator.getTerminal(), (Generator)generator));
        network.getLineStream().filter(l -> l.getTerminal1().getBusView().getBus() != l.getTerminal2().getBusView().getBus()).forEach(line -> {
            BranchData lineData = new BranchData(line, (double)this.parameters.getEpsilonX(), this.parameters.isApplyReactanceCorrection());
            this.completeTerminalData(line.getTerminal(Branch.Side.ONE), Branch.Side.ONE, lineData);
            this.completeTerminalData(line.getTerminal(Branch.Side.TWO), Branch.Side.TWO, lineData);
        });
        network.getTwoWindingsTransformerStream().forEach(twt -> {
            int phaseAngleClock = 0;
            TwoWindingsTransformerPhaseAngleClock phaseAngleClockExtension = (TwoWindingsTransformerPhaseAngleClock)twt.getExtension(TwoWindingsTransformerPhaseAngleClock.class);
            if (phaseAngleClockExtension != null) {
                phaseAngleClock = phaseAngleClockExtension.getPhaseAngleClock();
            }
            BranchData twtData = new BranchData(twt, phaseAngleClock, (double)this.parameters.getEpsilonX(), this.parameters.isApplyReactanceCorrection(), this.lfParameters.isTwtSplitShuntAdmittance());
            this.completeTerminalData(twt.getTerminal(Branch.Side.ONE), Branch.Side.ONE, twtData);
            this.completeTerminalData(twt.getTerminal(Branch.Side.TWO), Branch.Side.TWO, twtData);
        });
        network.getShuntCompensatorStream().forEach(sh -> {
            Terminal terminal = sh.getTerminal();
            if (terminal.isConnected() && Double.isNaN(terminal.getQ()) && terminal.getBusView().getBus() != null && terminal.getBusView().getBus().isInMainConnectedComponent()) {
                double v = terminal.getBusView().getBus().getV();
                double q = -sh.getB() * v * v;
                LOGGER.debug("Shunt {}, setting q = {}", sh, (Object)q);
                terminal.setQ(q);
            }
        });
        network.getThreeWindingsTransformerStream().forEach(twt -> {
            int phaseAngleClock2 = 0;
            int phaseAngleClock3 = 0;
            ThreeWindingsTransformerPhaseAngleClock phaseAngleClockExtension = (ThreeWindingsTransformerPhaseAngleClock)twt.getExtension(ThreeWindingsTransformerPhaseAngleClock.class);
            if (phaseAngleClockExtension != null) {
                phaseAngleClock2 = phaseAngleClockExtension.getPhaseAngleClockLeg2();
                phaseAngleClock3 = phaseAngleClockExtension.getPhaseAngleClockLeg3();
            }
            TwtData twtData = new TwtData(twt, phaseAngleClock2, phaseAngleClock3, (double)this.parameters.getEpsilonX(), this.parameters.isApplyReactanceCorrection(), this.lfParameters.isTwtSplitShuntAdmittance());
            this.completeTerminalData(twt.getLeg1().getTerminal(), ThreeWindingsTransformer.Side.ONE, twtData);
            this.completeTerminalData(twt.getLeg2().getTerminal(), ThreeWindingsTransformer.Side.TWO, twtData);
            this.completeTerminalData(twt.getLeg3().getTerminal(), ThreeWindingsTransformer.Side.THREE, twtData);
        });
        Z0FlowsCompletion z0FlowsCompletion = new Z0FlowsCompletion(network, this.z0checker);
        z0FlowsCompletion.complete();
    }

    private void completeTerminalData(Terminal terminal, Load load) {
        if (terminal.isConnected() && terminal.getBusView().getBus() != null && terminal.getBusView().getBus().isInMainConnectedComponent()) {
            if (Double.isNaN(terminal.getP())) {
                LOGGER.debug("Load {}, setting p = {}", (Object)load.getId(), (Object)load.getP0());
                terminal.setP(load.getP0());
            }
            if (Double.isNaN(terminal.getQ())) {
                LOGGER.debug("Load {}, setting q = {}", (Object)load.getId(), (Object)load.getQ0());
                terminal.setQ(load.getQ0());
            }
        }
    }

    private void completeTerminalData(Terminal terminal, Generator generator) {
        if (terminal.isConnected() && terminal.getBusView().getBus() != null && terminal.getBusView().getBus().isInMainConnectedComponent()) {
            if (Double.isNaN(terminal.getP())) {
                LOGGER.debug("Generator {}, setting p = {}", (Object)generator.getId(), (Object)(-generator.getTargetP()));
                terminal.setP(-generator.getTargetP());
            }
            if (Double.isNaN(terminal.getQ())) {
                LOGGER.debug("Generator {}, setting q = {}", (Object)generator.getId(), (Object)(-generator.getTargetQ()));
                terminal.setQ(-generator.getTargetQ());
            }
        }
    }

    private void completeTerminalData(Terminal terminal, Branch.Side side, BranchData branchData) {
        if (terminal.isConnected() && terminal.getBusView().getBus() != null && terminal.getBusView().getBus().isInMainConnectedComponent()) {
            if (Double.isNaN(terminal.getP())) {
                LOGGER.debug("Branch {}, Side {}: setting p = {}", new Object[]{branchData.getId(), side, branchData.getComputedP(side)});
                terminal.setP(branchData.getComputedP(side));
            }
            if (Double.isNaN(terminal.getQ())) {
                LOGGER.debug("Branch {}, Side {}: setting q = {}", new Object[]{branchData.getId(), side, branchData.getComputedQ(side)});
                terminal.setQ(branchData.getComputedQ(side));
            }
        }
    }

    private void completeTerminalData(Terminal terminal, ThreeWindingsTransformer.Side side, TwtData twtData) {
        if (terminal.isConnected() && terminal.getBusView().getBus() != null && terminal.getBusView().getBus().isInMainConnectedComponent()) {
            if (Double.isNaN(terminal.getP())) {
                LOGGER.debug("Twt {}, Side {}: setting p = {}", new Object[]{twtData.getId(), side, twtData.getComputedP(side)});
                terminal.setP(twtData.getComputedP(side));
            }
            if (Double.isNaN(terminal.getQ())) {
                LOGGER.debug("Twt {}, Side {}: setting q = {}", new Object[]{twtData.getId(), side, twtData.getComputedQ(side)});
                terminal.setQ(twtData.getComputedQ(side));
            }
        }
    }
}

