/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.resultscompletion.z0flows;

import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyVisitor;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.loadflow.resultscompletion.z0flows.BranchTerminal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z0FlowFromBusBalance
implements TopologyVisitor {
    private final Bus bus;
    private final Line line;
    private boolean known;
    private double netP;
    private double netQ;
    private static final Logger LOG = LoggerFactory.getLogger(Z0FlowFromBusBalance.class);

    public Z0FlowFromBusBalance(Bus bus, Line line) {
        this.bus = Objects.requireNonNull(bus);
        this.line = Objects.requireNonNull(line);
        this.netP = 0.0;
        this.netQ = 0.0;
        this.known = true;
    }

    public void complete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Z0 flow for line {} from balance at bus {}", (Object)this.line, (Object)this.bus);
        }
        this.bus.visitConnectedEquipments((TopologyVisitor)this);
        if (this.known) {
            this.completeZ0Flow();
        }
    }

    private void addFlow(Terminal t) {
        if (Double.isNaN(t.getP()) || Double.isNaN(t.getQ())) {
            this.known = false;
            LOG.warn("Z0 flow    unknown P, Q flow at {}", (Object)t.getConnectable());
        } else {
            this.netP += t.getP();
            this.netQ += t.getQ();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Z0 flow    P,Q %10.4f %10.4f %s %s", t.getP(), t.getQ(), t.getConnectable().getNameOrId(), t.getConnectable().getId()));
            }
        }
    }

    private void addFlowQ(Terminal t) {
        if (Double.isNaN(t.getQ())) {
            this.known = false;
            LOG.warn("Z0 flow    unknown Q flow at {}", (Object)t.getConnectable());
        } else {
            this.netQ += t.getQ();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Z0 flow    Q   %10s %10.4f %s %s", "-", t.getQ(), t.getConnectable().getNameOrId(), t.getConnectable().getId()));
            }
        }
    }

    private void completeZ0Flow() {
        Terminal t = BranchTerminal.ofBus(this.line, this.bus);
        Objects.requireNonNull(t);
        t.setP(-this.netP);
        t.setQ(-this.netQ);
        Terminal other = BranchTerminal.ofOtherBus(this.line, this.bus);
        Objects.requireNonNull(other);
        other.setP(this.netP);
        other.setQ(this.netQ);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Z0 flow    Z0  %10.4f %10.4f", t.getP(), t.getQ()));
        }
    }

    public void visitBusbarSection(BusbarSection section) {
    }

    public void visitLine(Line line, TwoSides side) {
        if (line.equals(this.line)) {
            return;
        }
        if (!line.getTerminal1().isConnected() || !line.getTerminal2().isConnected()) {
            return;
        }
        this.addFlow(line.getTerminal(side));
    }

    public void visitTwoWindingsTransformer(TwoWindingsTransformer transformer, TwoSides side) {
        this.addFlow(transformer.getTerminal(side));
    }

    public void visitThreeWindingsTransformer(ThreeWindingsTransformer transformer, ThreeSides side) {
        this.addFlow(transformer.getTerminal(side));
    }

    public void visitGenerator(Generator generator) {
        this.addFlow(generator.getTerminal());
    }

    public void visitBattery(Battery battery) {
        this.addFlow(battery.getTerminal());
    }

    public void visitLoad(Load load) {
        this.addFlow(load.getTerminal());
    }

    public void visitShuntCompensator(ShuntCompensator sc) {
        this.addFlowQ(sc.getTerminal());
    }

    public void visitDanglingLine(DanglingLine danglingLine) {
        this.addFlow(danglingLine.getTerminal());
    }

    public void visitStaticVarCompensator(StaticVarCompensator staticVarCompensator) {
        this.addFlowQ(staticVarCompensator.getTerminal());
    }
}

