/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.resultscompletion.z0flows;

import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Terminal;
import java.util.Objects;

final class BranchTerminal {
    private BranchTerminal() {
    }

    static Terminal ofOtherBus(Branch<?> branch, Bus bus) {
        Objects.requireNonNull(branch);
        if (BranchTerminal.busAtTerminal(branch.getTerminal1()) == bus) {
            return branch.getTerminal2();
        }
        if (BranchTerminal.busAtTerminal(branch.getTerminal2()) == bus) {
            return branch.getTerminal1();
        }
        return null;
    }

    static Terminal ofBus(Branch<?> branch, Bus bus) {
        Objects.requireNonNull(branch);
        if (BranchTerminal.busAtTerminal(branch.getTerminal1()) == bus) {
            return branch.getTerminal1();
        }
        if (BranchTerminal.busAtTerminal(branch.getTerminal2()) == bus) {
            return branch.getTerminal2();
        }
        return null;
    }

    private static Bus busAtTerminal(Terminal t) {
        if (t.isConnected()) {
            return t.getBusView().getBus();
        }
        return null;
    }
}

