/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.resultscompletion;

import com.google.auto.service.AutoService;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.network.ImportPostProcessor;
import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.resultscompletion.LoadFlowResultsCompletion;
import com.powsybl.loadflow.resultscompletion.LoadFlowResultsCompletionParameters;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={ImportPostProcessor.class})
public class LoadFlowResultsCompletionPostProcessor
implements ImportPostProcessor {
    public static final String NAME = "loadflowResultsCompletion";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadFlowResultsCompletionPostProcessor.class);
    private final LoadFlowResultsCompletionParameters parameters;
    private final LoadFlowParameters lfParameters;

    public LoadFlowResultsCompletionPostProcessor() {
        this(PlatformConfig.defaultConfig());
    }

    public LoadFlowResultsCompletionPostProcessor(PlatformConfig platformConfig) {
        Objects.requireNonNull(platformConfig);
        this.parameters = LoadFlowResultsCompletionParameters.load(platformConfig);
        this.lfParameters = LoadFlowParameters.load((PlatformConfig)platformConfig);
    }

    public String getName() {
        return NAME;
    }

    public void process(Network network, ComputationManager computationManager) throws Exception {
        Objects.requireNonNull(network);
        LOGGER.info("Execute {} post processor on network {}", (Object)this.getName(), (Object)network.getId());
        new LoadFlowResultsCompletion(this.parameters, this.lfParameters).run(network, computationManager);
    }
}

