/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.resultscompletion;

import com.powsybl.commons.config.PlatformConfig;
import java.lang.constant.Constable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class LoadFlowResultsCompletionParameters {
    public static final float EPSILON_X_DEFAULT = 0.1f;
    public static final boolean APPLY_REACTANCE_CORRECTION_DEFAULT = false;
    public static final double Z0_THRESHOLD_DIFF_VOLTAGE_ANGLE = 1.0E-6;
    private final float epsilonX;
    private final boolean applyReactanceCorrection;
    private final double z0ThresholdDiffVoltageAngle;

    public static LoadFlowResultsCompletionParameters load() {
        return LoadFlowResultsCompletionParameters.load(PlatformConfig.defaultConfig());
    }

    public static LoadFlowResultsCompletionParameters load(PlatformConfig platformConfig) {
        Objects.requireNonNull(platformConfig);
        return platformConfig.getOptionalModuleConfig("loadflow-results-completion-parameters").map(config -> {
            float epsilonX = config.getFloatProperty("epsilon-x", 0.1f);
            boolean applyReactanceCorrection = config.getBooleanProperty("apply-reactance-correction", false);
            double z0ThresholdDiffVoltageAngle = config.getDoubleProperty("z0-threshold-diff-voltage-angle", 1.0E-6);
            return new LoadFlowResultsCompletionParameters(epsilonX, applyReactanceCorrection, z0ThresholdDiffVoltageAngle);
        }).orElseGet(() -> new LoadFlowResultsCompletionParameters(0.1f, false, 1.0E-6));
    }

    public LoadFlowResultsCompletionParameters(float epsilonX, boolean applyReactanceCorrection, double z0ThresholdDiffVoltageAngle) {
        this.epsilonX = epsilonX;
        this.applyReactanceCorrection = applyReactanceCorrection;
        this.z0ThresholdDiffVoltageAngle = z0ThresholdDiffVoltageAngle;
    }

    public LoadFlowResultsCompletionParameters() {
        this(0.1f, false, 1.0E-6);
    }

    public float getEpsilonX() {
        return this.epsilonX;
    }

    public boolean isApplyReactanceCorrection() {
        return this.applyReactanceCorrection;
    }

    public double getZ0ThresholdDiffVoltageAngle() {
        return this.z0ThresholdDiffVoltageAngle;
    }

    protected Map<String, Object> toMap() {
        LinkedHashMap<String, Constable> map = new LinkedHashMap<String, Constable>();
        map.put("epsilonX", Float.valueOf(this.epsilonX));
        map.put("applyReactanceCorrection", Boolean.valueOf(this.applyReactanceCorrection));
        map.put("z0ThresholdDiffVoltageAngle", Double.valueOf(this.z0ThresholdDiffVoltageAngle));
        return Collections.unmodifiableMap(map);
    }

    public String toString() {
        return this.toMap().toString();
    }
}

