/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.resultscompletion.z0flows;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.loadflow.resultscompletion.z0flows.BranchTerminal;
import com.powsybl.loadflow.resultscompletion.z0flows.Z0Edge;
import com.powsybl.loadflow.resultscompletion.z0flows.Z0FlowFromBusBalance;
import com.powsybl.loadflow.resultscompletion.z0flows.Z0LineChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.alg.interfaces.SpanningTreeAlgorithm;
import org.jgrapht.alg.spanning.KruskalMinimumSpanningTree;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z0BusGroup {
    private final Bus seed;
    private final Z0LineChecker z0checker;
    private final List<Bus> buses = new ArrayList<Bus>();
    private SimpleWeightedGraph<Bus, Z0Edge> graph;
    private SpanningTreeAlgorithm.SpanningTree<Z0Edge> tree;
    private List<List<Bus>> levels;
    private Map<Bus, Line> parent;
    private List<Line> loops;
    private static final Logger LOG = LoggerFactory.getLogger(Z0BusGroup.class);

    public Z0BusGroup(Bus bus, Z0LineChecker z0checker) {
        this.seed = bus;
        this.z0checker = z0checker;
    }

    public boolean contains(Bus bus) {
        return this.buses.contains(bus);
    }

    public boolean valid() {
        return this.buses.size() > 1 || this.loops != null && !this.loops.isEmpty();
    }

    public void exploreZ0(Set<Bus> processed) {
        Objects.requireNonNull(processed);
        this.buses.add(this.seed);
        processed.add(this.seed);
        for (int k = 0; k < this.buses.size(); ++k) {
            Bus b = this.buses.get(k);
            b.getLineStream().forEach(line -> {
                Bus other = Z0BusGroup.other(line, b);
                if (other != null && this.z0checker.isZ0((Line)line)) {
                    if (b == other) {
                        this.addLoop((Line)line);
                    } else {
                        this.addToGraph((Line)line, b, other);
                        if (!this.buses.contains(other)) {
                            this.buses.add(other);
                            processed.add(other);
                        }
                    }
                }
            });
        }
    }

    public void complete() {
        if (!this.valid()) {
            LOG.warn("Z0 flow group not valid for seed bus {}", (Object)this.seed);
            return;
        }
        if (this.loops != null) {
            this.assignZeroFlowToLoops();
        }
        if (this.graph != null) {
            this.computeTreeFromGraph();
            this.assignZeroFlowToEdgesOutsideTree();
            this.completeFlowsForEdgesInsideTree();
        }
    }

    private void computeTreeFromGraph() {
        Objects.requireNonNull(this.graph);
        this.tree = new KruskalMinimumSpanningTree(this.graph).getSpanningTree();
        this.levels = new ArrayList<List<Bus>>();
        this.parent = new HashMap<Bus, Line>();
        HashSet processed = new HashSet();
        HashMap linesInBus = new HashMap();
        this.tree.getEdges().forEach(e -> {
            Bus b1 = e.getLine().getTerminal1().getBusView().getBus();
            Bus b2 = e.getLine().getTerminal2().getBusView().getBus();
            linesInBus.computeIfAbsent(b1, b -> new ArrayList()).add(e);
            linesInBus.computeIfAbsent(b2, b -> new ArrayList()).add(e);
        });
        Bus root = this.buses.get(0);
        this.levels.add(new ArrayList<Bus>(Collections.singleton(root)));
        for (int level = 0; level < this.levels.size(); ++level) {
            ArrayList nextLevel = new ArrayList();
            this.levels.get(level).forEach(bus -> ((List)linesInBus.get(bus)).forEach(e -> {
                Bus other = Z0BusGroup.other(e.getLine(), bus);
                if (other == null) {
                    return;
                }
                if (processed.contains(e.getLine())) {
                    return;
                }
                nextLevel.add(other);
                this.parent.put(other, e.getLine());
                processed.add(e.getLine());
            }));
            if (nextLevel.isEmpty()) continue;
            this.levels.add(nextLevel);
        }
    }

    private void assignZeroFlowToEdgesOutsideTree() {
        Objects.requireNonNull(this.graph);
        this.graph.edgeSet().forEach(e -> {
            if (!this.tree.getEdges().contains(e)) {
                this.assignZeroFlowTo(e.getLine());
            }
        });
    }

    private void assignZeroFlowToLoops() {
        Objects.requireNonNull(this.loops);
        this.loops.forEach(this::assignZeroFlowTo);
    }

    private void assignZeroFlowTo(Line line) {
        Objects.requireNonNull(line);
        line.getTerminal1().setP(0.0);
        line.getTerminal1().setQ(0.0);
        line.getTerminal2().setP(0.0);
        line.getTerminal2().setQ(0.0);
        if (line.getB1() != 0.0 || line.getB2() != 0.0 || line.getG1() != 0.0 || line.getG2() != 0.0) {
            LOG.error("Z0 line {} has B1, G1, B2, G2 != 0", (Object)line);
        }
    }

    private void completeFlowsForEdgesInsideTree() {
        for (int level = this.levels.size() - 1; level >= 1; --level) {
            this.levels.get(level).forEach(bus -> {
                Line line = this.parent.get(bus);
                new Z0FlowFromBusBalance((Bus)bus, line).complete();
            });
        }
    }

    private static Bus other(Line line, Bus bus) {
        Terminal t = BranchTerminal.ofOtherBus(line, bus);
        if (t == null) {
            return null;
        }
        return t.getBusView().getBus();
    }

    private void addToGraph(Line line, Bus b1, Bus b2) {
        if (this.graph == null) {
            this.graph = new SimpleWeightedGraph(Z0Edge.class);
        }
        this.graph.addVertex((Object)b1);
        this.graph.addVertex((Object)b2);
        this.graph.addEdge((Object)b1, (Object)b2, (Object)new Z0Edge(line));
    }

    private void addLoop(Line line) {
        if (this.loops == null) {
            this.loops = new ArrayList<Line>();
        }
        this.loops.add(line);
    }
}

