/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.resultscompletion.z0flows;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.resultscompletion.z0flows.Z0BusGroup;
import com.powsybl.loadflow.resultscompletion.z0flows.Z0LineChecker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Z0FlowsCompletion {
    private final Network network;
    private final Z0LineChecker z0checker;
    private final Set<Bus> processed = new HashSet<Bus>();

    public Z0FlowsCompletion(Network network, Z0LineChecker z0checker) {
        this.network = Objects.requireNonNull(network);
        this.z0checker = Objects.requireNonNull(z0checker);
    }

    public void complete() {
        this.z0busGroups().forEach(Z0BusGroup::complete);
    }

    private List<Z0BusGroup> z0busGroups() {
        ArrayList<Z0BusGroup> z0busGroups = new ArrayList<Z0BusGroup>();
        this.network.getBusView().getBusStream().forEach(bus -> {
            if (!this.processed.contains(bus)) {
                Z0BusGroup z0bg = new Z0BusGroup((Bus)bus, this.z0checker);
                z0bg.exploreZ0(this.processed);
                if (z0bg.valid()) {
                    z0busGroups.add(z0bg);
                }
            }
        });
        return z0busGroups;
    }
}

