/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.validation.BalanceType;
import com.powsybl.loadflow.validation.KComputation;
import com.powsybl.loadflow.validation.ValidationUtils;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Stream;

public class BalanceTypeGuesser {
    private String slackCandidate;
    private double maxActivePowerDifference = 0.0;
    private final KComputation kMaxComputation = new KComputation();
    private final KComputation kTargetComputation = new KComputation();
    private final KComputation kHeadroomComputation = new KComputation();
    private BalanceType balanceType;
    private String slack;

    public BalanceTypeGuesser() {
        this.balanceType = BalanceType.NONE;
    }

    public BalanceTypeGuesser(Network network, double threshold) {
        Objects.requireNonNull(network);
        this.guess(network, threshold);
    }

    private void guess(Network network, double threshold) {
        int movedGeneratorsCount = network.getGeneratorStream().mapToInt(generator -> this.isMovedGenerator((Generator)generator, threshold)).sum();
        if (movedGeneratorsCount > 0) {
            this.balanceType = this.getBalanceType(this.kMaxComputation.getVarK(), this.kTargetComputation.getVarK(), this.kHeadroomComputation.getVarK());
        } else {
            this.balanceType = BalanceType.NONE;
            this.slack = this.slackCandidate;
        }
    }

    private BalanceType getBalanceType(double varKMax, double varKTarget, double varKHeadroom) {
        return Stream.of(new AbstractMap.SimpleEntry<BalanceType, Double>(BalanceType.PROPORTIONAL_TO_GENERATION_P_MAX, varKMax), new AbstractMap.SimpleEntry<BalanceType, Double>(BalanceType.PROPORTIONAL_TO_GENERATION_P, varKTarget), new AbstractMap.SimpleEntry<BalanceType, Double>(BalanceType.PROPORTIONAL_TO_GENERATION_HEADROOM, varKHeadroom)).min(Comparator.comparingDouble(AbstractMap.SimpleEntry::getValue)).map(AbstractMap.SimpleEntry::getKey).orElse(BalanceType.NONE);
    }

    private int isMovedGenerator(Generator generator, double threshold) {
        double p = -generator.getTerminal().getP();
        double targetP = generator.getTargetP();
        double maxP = generator.getMaxP();
        double minP = generator.getMinP();
        if (Math.abs(p - targetP) > this.maxActivePowerDifference) {
            this.slackCandidate = generator.getId();
            this.maxActivePowerDifference = Math.abs(p - targetP);
        }
        if (ValidationUtils.boundedWithin(Math.max(threshold, minP), maxP - threshold, targetP, 0.0) && ValidationUtils.boundedWithin(Math.max(0.0, minP), maxP, p, -threshold) && maxP >= threshold && Math.abs(p - targetP) >= threshold) {
            this.kMaxComputation.addGeneratorValues(p, targetP, maxP);
            this.kTargetComputation.addGeneratorValues(p, targetP, targetP);
            this.kHeadroomComputation.addGeneratorValues(p, targetP, maxP - targetP);
            return 1;
        }
        return 0;
    }

    public BalanceType getBalanceType() {
        return this.balanceType;
    }

    public String getSlack() {
        return this.slack;
    }

    public double getKMax() {
        return this.kMaxComputation.getK();
    }

    public double getKTarget() {
        return this.kTargetComputation.getK();
    }

    public double getKHeadroom() {
        return this.kHeadroomComputation.getK();
    }
}

