/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.loadflow.validation.AbstractTransformersValidation;
import com.powsybl.loadflow.validation.ValidationConfig;
import com.powsybl.loadflow.validation.ValidationType;
import com.powsybl.loadflow.validation.ValidationUtils;
import com.powsybl.loadflow.validation.io.ValidationWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransformersValidation
extends AbstractTransformersValidation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformersValidation.class);
    public static final TransformersValidation INSTANCE = new TransformersValidation();

    private TransformersValidation() {
    }

    @Override
    public boolean checkTransformers(Network network, ValidationConfig config, ValidationWriter twtsWriter) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(config);
        Objects.requireNonNull(twtsWriter);
        LOGGER.info("Checking transformers of network {}", (Object)network.getId());
        return network.getTwoWindingsTransformerStream().filter(TransformersValidation::filterTwt).sorted(Comparator.comparing(Identifiable::getId)).map(twt -> this.checkTransformer((TwoWindingsTransformer)twt, config, twtsWriter)).reduce(Boolean::logicalAnd).orElse(true);
    }

    private static boolean filterTwt(TwoWindingsTransformer twt) {
        return twt.hasRatioTapChanger() && twt.getRatioTapChanger().isRegulating();
    }

    public boolean checkTransformer(TwoWindingsTransformer twt, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(twt);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter twtsWriter = ValidationUtils.createValidationWriter(twt.getId(), config, writer, ValidationType.TWTS);
            try {
                bl = this.checkTransformer(twt, config, twtsWriter);
                if (twtsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (twtsWriter != null) {
                        try {
                            twtsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            twtsWriter.close();
        }
        return bl;
    }

    public boolean checkTransformer(TwoWindingsTransformer twt, ValidationConfig config, ValidationWriter twtsWriter) {
        Branch.Side regulatedSide;
        Objects.requireNonNull(twt);
        Objects.requireNonNull(config);
        Objects.requireNonNull(twtsWriter);
        RatioTapChanger ratioTapChanger = twt.getRatioTapChanger();
        int tapPosition = ratioTapChanger.getTapPosition();
        int lowTapPosition = ratioTapChanger.getLowTapPosition();
        int highTapPosition = ratioTapChanger.getHighTapPosition();
        double rho = ((RatioTapChangerStep)ratioTapChanger.getCurrentStep()).getRho();
        double rhoPreviousStep = tapPosition == lowTapPosition ? Double.NaN : ((RatioTapChangerStep)ratioTapChanger.getStep(tapPosition - 1)).getRho();
        double rhoNextStep = tapPosition == highTapPosition ? Double.NaN : ((RatioTapChangerStep)ratioTapChanger.getStep(tapPosition + 1)).getRho();
        double targetV = ratioTapChanger.getTargetV();
        if (twt.getTerminal1().equals(ratioTapChanger.getRegulationTerminal())) {
            regulatedSide = Branch.Side.ONE;
        } else if (twt.getTerminal2().equals(ratioTapChanger.getRegulationTerminal())) {
            regulatedSide = Branch.Side.TWO;
        } else {
            LOGGER.warn("{} {}: {}: Unexpected regulation terminal (side 1 or 2 of transformer is expected), skipping validation", new Object[]{ValidationType.TWTS, "validation warning", twt.getId()});
            try {
                twtsWriter.write(twt.getId(), Double.NaN, Double.NaN, Double.NaN, rho, rhoPreviousStep, rhoNextStep, tapPosition, lowTapPosition, highTapPosition, targetV, null, Double.NaN, false, false, true);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return true;
        }
        Bus bus = ratioTapChanger.getRegulationTerminal().getBusView().getBus();
        double v = bus != null ? bus.getV() : Double.NaN;
        boolean connected = bus != null;
        Bus connectableBus = ratioTapChanger.getRegulationTerminal().getBusView().getConnectableBus();
        boolean connectableMainComponent = connectableBus != null && connectableBus.isInMainConnectedComponent();
        boolean mainComponent = bus != null ? bus.isInMainConnectedComponent() : connectableMainComponent;
        return this.checkTransformer(twt.getId(), rho, rhoPreviousStep, rhoNextStep, tapPosition, lowTapPosition, highTapPosition, targetV, regulatedSide, v, connected, mainComponent, config, twtsWriter);
    }

    public boolean checkTransformer(String id, double rho, double rhoPreviousStep, double rhoNextStep, int tapPosition, int lowTapPosition, int highTapPosition, double targetV, Branch.Side regulatedSide, double v, boolean connected, boolean mainComponent, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(id);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter twtsWriter = ValidationUtils.createValidationWriter(id, config, writer, ValidationType.TWTS);
            try {
                bl = this.checkTransformer(id, rho, rhoPreviousStep, rhoNextStep, tapPosition, lowTapPosition, highTapPosition, targetV, regulatedSide, v, connected, mainComponent, config, twtsWriter);
                if (twtsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (twtsWriter != null) {
                        try {
                            twtsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            twtsWriter.close();
        }
        return bl;
    }

    public boolean checkTransformer(String id, double rho, double rhoPreviousStep, double rhoNextStep, int tapPosition, int lowTapPosition, int highTapPosition, double targetV, Branch.Side regulatedSide, double v, boolean connected, boolean mainComponent, ValidationConfig config, ValidationWriter twtsWriter) {
        double downIncrement;
        Objects.requireNonNull(id);
        Objects.requireNonNull(config);
        Objects.requireNonNull(twtsWriter);
        boolean validated = true;
        double error = v - targetV;
        double upIncrement = Double.isNaN(rhoNextStep) ? Double.NaN : TransformersValidation.evaluateVoltage(regulatedSide, v, rho, rhoNextStep) - v;
        double d = downIncrement = Double.isNaN(rhoPreviousStep) ? Double.NaN : TransformersValidation.evaluateVoltage(regulatedSide, v, rho, rhoPreviousStep) - v;
        if (connected && ValidationUtils.isMainComponent(config, mainComponent)) {
            validated = TransformersValidation.checkTransformerSide(id, regulatedSide, error, upIncrement, downIncrement, config);
        }
        try {
            twtsWriter.write(id, error, upIncrement, downIncrement, rho, rhoPreviousStep, rhoNextStep, tapPosition, lowTapPosition, highTapPosition, targetV, regulatedSide, v, connected, mainComponent, validated);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return validated;
    }

    private static double evaluateVoltage(Branch.Side regulatedSide, double voltage, double ratio, double nextRatio) {
        switch (regulatedSide) {
            case ONE: {
                return voltage * ratio / nextRatio;
            }
            case TWO: {
                return voltage * nextRatio / ratio;
            }
        }
        throw new IllegalStateException("Unexpected Side value: " + regulatedSide);
    }

    private static boolean checkTransformerSide(String id, Branch.Side side, double error, double upIncrement, double downIncrement, ValidationConfig config) {
        double upDeadband;
        double downDeadband;
        boolean validated = true;
        double maxIncrease = TransformersValidation.getMaxVoltageIncrease(upIncrement, downIncrement);
        double maxDecrease = TransformersValidation.getMaxVoltageDecrease(upIncrement, downIncrement);
        if (ValidationUtils.areNaN(config, error)) {
            LOGGER.warn("{} {}: {} side {}: error {}", new Object[]{ValidationType.TWTS, "validation error", id, side, error});
            return false;
        }
        if (error < 0.0 && !Double.isNaN(maxIncrease) && error + (downDeadband = maxIncrease) < -config.getThreshold()) {
            LOGGER.warn("{} {}: {} side {}: error {} upIncrement {} downIncrement {}", new Object[]{ValidationType.TWTS, "validation error", id, side, error, upIncrement, downIncrement});
            validated = false;
        }
        if (error > 0.0 && !Double.isNaN(maxDecrease) && error - (upDeadband = -maxDecrease) > config.getThreshold()) {
            LOGGER.warn("{} {}: {} side {}: error {} upIncrement {} downIncrement {}", new Object[]{ValidationType.TWTS, "validation error", id, side, error, upIncrement, downIncrement});
            validated = false;
        }
        return validated;
    }

    private static double getMaxVoltageIncrease(double upIncrement, double downIncrement) {
        if (Double.isNaN(downIncrement) && Double.isNaN(upIncrement)) {
            return Double.NaN;
        }
        if (Double.isNaN(upIncrement)) {
            return downIncrement > 0.0 ? downIncrement : Double.NaN;
        }
        if (Double.isNaN(downIncrement)) {
            return upIncrement > 0.0 ? upIncrement : Double.NaN;
        }
        return Math.max(upIncrement, downIncrement);
    }

    private static double getMaxVoltageDecrease(double upIncrement, double downIncrement) {
        if (Double.isNaN(downIncrement) && Double.isNaN(upIncrement)) {
            return Double.NaN;
        }
        if (Double.isNaN(upIncrement)) {
            return downIncrement < 0.0 ? downIncrement : Double.NaN;
        }
        if (Double.isNaN(downIncrement)) {
            return upIncrement < 0.0 ? upIncrement : Double.NaN;
        }
        return Math.min(upIncrement, downIncrement);
    }
}

