/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation.io;

import com.powsybl.commons.io.table.Column;
import com.powsybl.commons.io.table.TableFormatterConfig;
import com.powsybl.commons.io.table.TableFormatterFactory;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.util.TwtData;
import com.powsybl.loadflow.validation.ValidationType;
import com.powsybl.loadflow.validation.io.AbstractValidationFormatterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import org.apache.commons.lang3.ArrayUtils;

public class ValidationFormatterCsvMultilineWriter
extends AbstractValidationFormatterWriter {
    private final boolean verbose;

    public ValidationFormatterCsvMultilineWriter(String id, Class<? extends TableFormatterFactory> formatterFactoryClass, TableFormatterConfig formatterConfig, Writer writer, boolean verbose, ValidationType validationType, boolean compareResults) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(formatterFactoryClass);
        Objects.requireNonNull(writer);
        this.verbose = verbose;
        this.validationType = Objects.requireNonNull(validationType);
        this.compareResults = compareResults;
        this.formatter = this.createTableFormatter(id, formatterFactoryClass, formatterConfig, writer, validationType);
        this.invalidString = formatterConfig.getInvalidString();
    }

    public ValidationFormatterCsvMultilineWriter(String id, Class<? extends TableFormatterFactory> formatterFactoryClass, Writer writer, boolean verbose, ValidationType validationType, boolean compareResults) {
        this(id, formatterFactoryClass, TableFormatterConfig.load(), writer, verbose, validationType, compareResults);
    }

    @Override
    protected Column[] getColumns() {
        Object[] columns = new Column[]{new Column("id"), new Column("characteristic"), new Column("value")};
        if (this.compareResults) {
            columns = (Column[])ArrayUtils.add((Object[])columns, (Object)new Column("value_postComp"));
        }
        return columns;
    }

    @Override
    protected void write(String branchId, double p1, double p1Calc, double q1, double q1Calc, double p2, double p2Calc, double q2, double q2Calc, double r, double x, double g1, double g2, double b1, double b2, double rho1, double rho2, double alpha1, double alpha2, double u1, double u2, double theta1, double theta2, double z, double y, double ksi, int phaseAngleClock, boolean connected1, boolean connected2, boolean mainComponent1, boolean mainComponent2, boolean validated, AbstractValidationFormatterWriter.FlowData flowData, boolean found, boolean writeValues) throws IOException {
        this.write(branchId, "network_p1", found, flowData.p1, writeValues, p1);
        this.write(branchId, "expected_p1", found, flowData.p1Calc, writeValues, p1Calc);
        this.write(branchId, "network_q1", found, flowData.q1, writeValues, q1);
        this.write(branchId, "expected_q1", found, flowData.q1Calc, writeValues, q1Calc);
        this.write(branchId, "network_p2", found, flowData.p2, writeValues, p2);
        this.write(branchId, "expected_p2", found, flowData.p2Calc, writeValues, p2Calc);
        this.write(branchId, "network_q2", found, flowData.q2, writeValues, q2);
        this.write(branchId, "expected_q2", found, flowData.q2Calc, writeValues, q2Calc);
        if (this.verbose) {
            this.write(branchId, "r", found, flowData.r, writeValues, r);
            this.write(branchId, "x", found, flowData.x, writeValues, x);
            this.write(branchId, "g1", found, flowData.g1, writeValues, g1);
            this.write(branchId, "g2", found, flowData.g2, writeValues, g2);
            this.write(branchId, "b1", found, flowData.b1, writeValues, b1);
            this.write(branchId, "b2", found, flowData.b2, writeValues, b2);
            this.write(branchId, "rho1", found, flowData.rho1, writeValues, rho1);
            this.write(branchId, "rho2", found, flowData.rho2, writeValues, rho2);
            this.write(branchId, "alpha1", found, flowData.alpha1, writeValues, alpha1);
            this.write(branchId, "alpha2", found, flowData.alpha2, writeValues, alpha2);
            this.write(branchId, "u1", found, flowData.u1, writeValues, u1);
            this.write(branchId, "u2", found, flowData.u2, writeValues, u2);
            this.write(branchId, "theta1", found, flowData.theta1, writeValues, theta1);
            this.write(branchId, "theta2", found, flowData.theta2, writeValues, theta2);
            this.write(branchId, "z", found, flowData.z, writeValues, z);
            this.write(branchId, "y", found, flowData.y, writeValues, y);
            this.write(branchId, "ksi", found, flowData.ksi, writeValues, ksi);
            this.write(branchId, "phaseAngleClock", found, flowData.phaseAngleClock, writeValues, phaseAngleClock);
            this.write(branchId, "connected1", found, flowData.connected1, writeValues, connected1);
            this.write(branchId, "connected2", found, flowData.connected2, writeValues, connected2);
            this.write(branchId, "mainComponent1", found, flowData.mainComponent1, writeValues, mainComponent1);
            this.write(branchId, "mainComponent2", found, flowData.mainComponent2, writeValues, mainComponent2);
            this.write(branchId, "validation", found, this.getValidated(flowData.validated), writeValues, this.getValidated(validated));
        }
    }

    @Override
    protected void write(String generatorId, double p, double q, double v, double targetP, double targetQ, double targetV, double expectedP, boolean connected, boolean voltageRegulatorOn, double minP, double maxP, double minQ, double maxQ, boolean mainComponent, boolean validated, AbstractValidationFormatterWriter.GeneratorData generatorData, boolean found, boolean writeValues) throws IOException {
        this.write(generatorId, "p", found, -generatorData.p, writeValues, -p);
        this.write(generatorId, "q", found, -generatorData.q, writeValues, -q);
        this.write(generatorId, "v", found, generatorData.v, writeValues, v);
        this.write(generatorId, "targetP", found, generatorData.targetP, writeValues, targetP);
        this.write(generatorId, "targetQ", found, generatorData.targetQ, writeValues, targetQ);
        this.write(generatorId, "targetV", found, generatorData.targetV, writeValues, targetV);
        this.write(generatorId, "expectedP", found, generatorData.expectedP, writeValues, expectedP);
        if (this.verbose) {
            this.write(generatorId, "connected", found, generatorData.connected, writeValues, connected);
            this.write(generatorId, "voltageRegulatorOn", found, generatorData.voltageRegulatorOn, writeValues, voltageRegulatorOn);
            this.write(generatorId, "minP", found, generatorData.minP, writeValues, minP);
            this.write(generatorId, "maxP", found, generatorData.maxP, writeValues, maxP);
            this.write(generatorId, "minQ", found, generatorData.minQ, writeValues, minQ);
            this.write(generatorId, "maxQ", found, generatorData.maxQ, writeValues, maxQ);
            this.write(generatorId, "mainComponent", found, generatorData.mainComponent, writeValues, mainComponent);
            this.write(generatorId, "validation", found, this.getValidated(generatorData.validated), writeValues, this.getValidated(validated));
        }
    }

    @Override
    protected void write(String busId, double incomingP, double incomingQ, double loadP, double loadQ, double genP, double genQ, double batP, double batQ, double shuntP, double shuntQ, double svcP, double svcQ, double vscCSP, double vscCSQ, double lineP, double lineQ, double danglingLineP, double danglingLineQ, double twtP, double twtQ, double tltP, double tltQ, boolean validated, boolean mainComponent, AbstractValidationFormatterWriter.BusData busData, boolean found, boolean writeValues) throws IOException {
        this.write(busId, "incomingP", found, busData.incomingP, writeValues, incomingP);
        this.write(busId, "incomingQ", found, busData.incomingQ, writeValues, incomingQ);
        this.write(busId, "loadP", found, busData.loadP, writeValues, loadP);
        this.write(busId, "loadQ", found, busData.loadQ, writeValues, loadQ);
        if (this.verbose) {
            this.write(busId, "genP", found, busData.genP, writeValues, genP);
            this.write(busId, "genQ", found, busData.genQ, writeValues, genQ);
            this.write(busId, "batP", found, busData.batP, writeValues, batP);
            this.write(busId, "batQ", found, busData.batQ, writeValues, batQ);
            this.write(busId, "shuntP", found, busData.shuntP, writeValues, shuntP);
            this.write(busId, "shuntQ", found, busData.shuntQ, writeValues, shuntQ);
            this.write(busId, "svcP", found, busData.svcP, writeValues, svcP);
            this.write(busId, "svcQ", found, busData.svcQ, writeValues, svcQ);
            this.write(busId, "vscCSP", found, busData.vscCSP, writeValues, vscCSP);
            this.write(busId, "vscCSQ", found, busData.vscCSQ, writeValues, vscCSQ);
            this.write(busId, "lineP", found, busData.lineP, writeValues, lineP);
            this.write(busId, "lineQ", found, busData.lineQ, writeValues, lineQ);
            this.write(busId, "danglingLineP", found, busData.danglingLineP, writeValues, danglingLineP);
            this.write(busId, "danglingLineQ", found, busData.danglingLineQ, writeValues, danglingLineQ);
            this.write(busId, "twtP", found, busData.twtP, writeValues, twtP);
            this.write(busId, "twtQ", found, busData.twtQ, writeValues, twtQ);
            this.write(busId, "tltP", found, busData.tltP, writeValues, tltP);
            this.write(busId, "tltQ", found, busData.tltQ, writeValues, tltQ);
            this.write(busId, "mainComponent", found, busData.mainComponent, writeValues, mainComponent);
            this.write(busId, "validation", found, this.getValidated(busData.validated), writeValues, this.getValidated(validated));
        }
    }

    @Override
    protected void write(String svcId, double p, double q, double vControlled, double vController, double nominalVcontroller, double reactivePowerSetpoint, double voltageSetpoint, boolean connected, StaticVarCompensator.RegulationMode regulationMode, double bMin, double bMax, boolean mainComponent, boolean validated, AbstractValidationFormatterWriter.SvcData svcData, boolean found, boolean writeValues) throws IOException {
        this.write(svcId, "p", found, -svcData.p, writeValues, -p);
        this.write(svcId, "q", found, -svcData.q, writeValues, -q);
        this.write(svcId, "vControlled", found, svcData.vControlled, writeValues, vControlled);
        this.write(svcId, "vController", found, svcData.vController, writeValues, vController);
        this.write(svcId, "nominalV", found, svcData.nominalVcontroller, writeValues, nominalVcontroller);
        this.write(svcId, "reactivePowerSetpoint", found, svcData.reactivePowerSetpoint, writeValues, reactivePowerSetpoint);
        this.write(svcId, "voltageSetpoint", found, svcData.voltageSetpoint, writeValues, voltageSetpoint);
        if (this.verbose) {
            this.write(svcId, "connected", found, svcData.connected, writeValues, connected);
            this.write(svcId, "regulationMode", found, svcData.regulationMode.name(), writeValues, regulationMode.name());
            this.write(svcId, "bMin", found, svcData.bMin, writeValues, bMin);
            this.write(svcId, "bMax", found, svcData.bMax, writeValues, bMax);
            this.write(svcId, "mainComponent", found, svcData.mainComponent, writeValues, mainComponent);
            this.write(svcId, "validation", found, this.getValidated(svcData.validated), writeValues, this.getValidated(validated));
        }
    }

    @Override
    protected void write(String shuntId, double q, double expectedQ, double p, int currentSectionCount, int maximumSectionCount, double bPerSection, double v, boolean connected, double qMax, double nominalV, boolean mainComponent, boolean validated, AbstractValidationFormatterWriter.ShuntData shuntData, boolean found, boolean writeValues) throws IOException {
        this.write(shuntId, "q", found, shuntData.q, writeValues, q);
        this.write(shuntId, "expectedQ", found, shuntData.expectedQ, writeValues, expectedQ);
        if (this.verbose) {
            this.write(shuntId, "p", found, shuntData.p, writeValues, p);
            this.write(shuntId, "currentSectionCount", found, shuntData.currentSectionCount, writeValues, currentSectionCount);
            this.write(shuntId, "maximumSectionCount", found, shuntData.maximumSectionCount, writeValues, maximumSectionCount);
            this.write(shuntId, "bPerSection", found, shuntData.bPerSection, writeValues, bPerSection);
            this.write(shuntId, "v", found, shuntData.v, writeValues, v);
            this.write(shuntId, "connected", found, shuntData.connected, writeValues, connected);
            this.write(shuntId, "qMax", found, shuntData.qMax, writeValues, qMax);
            this.write(shuntId, "nominalV", found, shuntData.nominalV, writeValues, nominalV);
            this.write(shuntId, "mainComponent", found, shuntData.mainComponent, writeValues, mainComponent);
            this.write(shuntId, "validation", found, this.getValidated(shuntData.validated), writeValues, this.getValidated(validated));
        }
    }

    @Override
    protected void write(String twtId, double error, double upIncrement, double downIncrement, double rho, double rhoPreviousStep, double rhoNextStep, int tapPosition, int lowTapPosition, int highTapPosition, double targetV, Branch.Side regulatedSide, double v, boolean connected, boolean mainComponent, boolean validated, AbstractValidationFormatterWriter.TransformerData twtData, boolean found, boolean writeValues) throws IOException {
        this.write(twtId, "error", found, twtData.error, writeValues, error);
        this.write(twtId, "upIncrement", found, twtData.upIncrement, writeValues, upIncrement);
        this.write(twtId, "downIncrement", found, twtData.downIncrement, writeValues, downIncrement);
        if (this.verbose) {
            this.write(twtId, "rho", found, twtData.rho, writeValues, rho);
            this.write(twtId, "rhoPreviousStep", found, twtData.rhoPreviousStep, writeValues, rhoPreviousStep);
            this.write(twtId, "rhoNextStep", found, twtData.rhoNextStep, writeValues, rhoNextStep);
            this.write(twtId, "tapPosition", found, twtData.tapPosition, writeValues, tapPosition);
            this.write(twtId, "lowTapPosition", found, twtData.lowTapPosition, writeValues, lowTapPosition);
            this.write(twtId, "highTapPosition", found, twtData.highTapPosition, writeValues, highTapPosition);
            this.write(twtId, "tapChangerTargetV", found, twtData.targetV, writeValues, targetV);
            this.write(twtId, "regulatedSide", found, twtData.regulatedSide != null ? twtData.regulatedSide.name() : this.invalidString, writeValues, regulatedSide != null ? regulatedSide.name() : this.invalidString);
            this.write(twtId, "v", found, twtData.v, writeValues, v);
            this.write(twtId, "connected", found, twtData.connected, writeValues, connected);
            this.write(twtId, "mainComponent", found, twtData.mainComponent, writeValues, mainComponent);
            this.write(twtId, "validation", found, this.getValidated(twtData.validated), writeValues, this.getValidated(validated));
        }
    }

    private double getTwtSideValue(boolean bool, TwtData twtData, ThreeWindingsTransformer.Side side, BiFunction<TwtData, ThreeWindingsTransformer.Side, Double> f) {
        return bool ? f.apply(twtData, side) : Double.NaN;
    }

    private double getTwtValue(boolean bool, TwtData twtData, ToDoubleFunction<TwtData> f) {
        return bool ? f.applyAsDouble(twtData) : Double.NaN;
    }

    private int getTwtValue(boolean bool, TwtData twtData, ToIntFunction<TwtData> f) {
        return bool ? f.applyAsInt(twtData) : 0;
    }

    @Override
    protected void write(String twtId, AbstractValidationFormatterWriter.Transformer3WData transformer3WData1, AbstractValidationFormatterWriter.Transformer3WData transformer3WData2, boolean found, boolean writeValues) throws IOException {
        TwtData twtData1 = transformer3WData1.twtData;
        TwtData twtData2 = transformer3WData2.twtData;
        this.write(twtId, "network_p1", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.ONE, TwtData::getP), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.ONE, TwtData::getP));
        this.write(twtId, "expected_p1", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.ONE, TwtData::getComputedP), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.ONE, TwtData::getComputedP));
        this.write(twtId, "network_q1", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.ONE, TwtData::getQ), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.ONE, TwtData::getQ));
        this.write(twtId, "expected_q1", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.ONE, TwtData::getComputedQ), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.ONE, TwtData::getComputedQ));
        this.write(twtId, "network_p2", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.TWO, TwtData::getP), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.TWO, TwtData::getP));
        this.write(twtId, "expected_p2", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.TWO, TwtData::getComputedP), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.TWO, TwtData::getComputedP));
        this.write(twtId, "network_q2", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.TWO, TwtData::getQ), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.TWO, TwtData::getQ));
        this.write(twtId, "expected_q2", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.TWO, TwtData::getComputedQ), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.TWO, TwtData::getComputedQ));
        this.write(twtId, "network_p3", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.THREE, TwtData::getP), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.THREE, TwtData::getP));
        this.write(twtId, "expected_p3", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.THREE, TwtData::getComputedP), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.THREE, TwtData::getComputedP));
        this.write(twtId, "network_q3", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.THREE, TwtData::getQ), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.THREE, TwtData::getQ));
        this.write(twtId, "expected_q3", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.THREE, TwtData::getComputedQ), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.THREE, TwtData::getComputedQ));
        if (this.verbose) {
            this.write(twtId, "u1", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.ONE, TwtData::getU), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.ONE, TwtData::getU));
            this.write(twtId, "u2", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.TWO, TwtData::getU), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.TWO, TwtData::getU));
            this.write(twtId, "u3", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.THREE, TwtData::getU), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.THREE, TwtData::getU));
            this.write(twtId, "starU", found, this.getTwtValue(found, twtData2, TwtData::getStarU), writeValues, this.getTwtValue(writeValues, twtData1, TwtData::getStarU));
            this.write(twtId, "theta1", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.ONE, TwtData::getTheta), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.ONE, TwtData::getTheta));
            this.write(twtId, "theta2", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.TWO, TwtData::getTheta), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.TWO, TwtData::getTheta));
            this.write(twtId, "theta3", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.THREE, TwtData::getTheta), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.THREE, TwtData::getTheta));
            this.write(twtId, "starTheta", found, this.getTwtValue(found, twtData2, TwtData::getStarTheta), writeValues, this.getTwtValue(writeValues, twtData1, TwtData::getStarTheta));
            this.write(twtId, "g11", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.ONE, TwtData::getG1), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.ONE, TwtData::getG1));
            this.write(twtId, "b11", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.ONE, TwtData::getB1), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.ONE, TwtData::getB1));
            this.write(twtId, "g12", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.ONE, TwtData::getG2), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.ONE, TwtData::getG2));
            this.write(twtId, "b12", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.ONE, TwtData::getB2), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.ONE, TwtData::getB2));
            this.write(twtId, "g21", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.TWO, TwtData::getG1), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.TWO, TwtData::getG1));
            this.write(twtId, "b21", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.TWO, TwtData::getB1), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.TWO, TwtData::getB1));
            this.write(twtId, "g22", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.TWO, TwtData::getG2), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.TWO, TwtData::getG2));
            this.write(twtId, "b22", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.TWO, TwtData::getB2), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.TWO, TwtData::getB2));
            this.write(twtId, "g31", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.THREE, TwtData::getG1), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.THREE, TwtData::getG1));
            this.write(twtId, "b31", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.THREE, TwtData::getB1), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.THREE, TwtData::getB1));
            this.write(twtId, "g32", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.THREE, TwtData::getG2), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.THREE, TwtData::getG2));
            this.write(twtId, "b32", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.THREE, TwtData::getB2), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.THREE, TwtData::getB2));
            this.write(twtId, "r1", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.ONE, TwtData::getR), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.ONE, TwtData::getR));
            this.write(twtId, "r2", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.TWO, TwtData::getR), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.TWO, TwtData::getR));
            this.write(twtId, "r3", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.THREE, TwtData::getR), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.THREE, TwtData::getR));
            this.write(twtId, "x1", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.ONE, TwtData::getX), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.ONE, TwtData::getX));
            this.write(twtId, "x2", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.TWO, TwtData::getX), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.TWO, TwtData::getX));
            this.write(twtId, "x3", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.THREE, TwtData::getX), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.THREE, TwtData::getX));
            this.write(twtId, "ratedU1", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.ONE, TwtData::getRatedU), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.ONE, TwtData::getRatedU));
            this.write(twtId, "ratedU2", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.TWO, TwtData::getRatedU), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.TWO, TwtData::getRatedU));
            this.write(twtId, "ratedU3", found, this.getTwtSideValue(found, twtData2, ThreeWindingsTransformer.Side.THREE, TwtData::getRatedU), writeValues, this.getTwtSideValue(writeValues, twtData1, ThreeWindingsTransformer.Side.THREE, TwtData::getRatedU));
            this.write(twtId, "phaseAngleClock2", found, this.getTwtValue(found, twtData2, TwtData::getPhaseAngleClock2), writeValues, this.getTwtValue(writeValues, twtData1, TwtData::getPhaseAngleClock2));
            this.write(twtId, "phaseAngleClock3", found, this.getTwtValue(found, twtData2, TwtData::getPhaseAngleClock3), writeValues, this.getTwtValue(writeValues, twtData1, TwtData::getPhaseAngleClock3));
            this.write(twtId, "ratedU0", found, this.getTwtValue(found, twtData2, TwtData::getRatedU0), writeValues, this.getTwtValue(writeValues, twtData1, TwtData::getRatedU0));
            this.write(twtId, "connected1", found, found && twtData2.isConnected(ThreeWindingsTransformer.Side.ONE), writeValues, writeValues && twtData1.isConnected(ThreeWindingsTransformer.Side.ONE));
            this.write(twtId, "connected2", found, found && twtData2.isConnected(ThreeWindingsTransformer.Side.TWO), writeValues, writeValues && twtData1.isConnected(ThreeWindingsTransformer.Side.TWO));
            this.write(twtId, "connected3", found, found && twtData2.isConnected(ThreeWindingsTransformer.Side.THREE), writeValues, writeValues && twtData1.isConnected(ThreeWindingsTransformer.Side.THREE));
            this.write(twtId, "mainComponent1", found, found && twtData2.isMainComponent(ThreeWindingsTransformer.Side.ONE), writeValues, writeValues && twtData1.isMainComponent(ThreeWindingsTransformer.Side.ONE));
            this.write(twtId, "mainComponent2", found, found && twtData2.isMainComponent(ThreeWindingsTransformer.Side.TWO), writeValues, writeValues && twtData1.isMainComponent(ThreeWindingsTransformer.Side.TWO));
            this.write(twtId, "mainComponent3", found, found && twtData2.isMainComponent(ThreeWindingsTransformer.Side.THREE), writeValues, writeValues && twtData1.isMainComponent(ThreeWindingsTransformer.Side.THREE));
            this.write(twtId, "validation", found, this.getValidated(transformer3WData2.validated), writeValues, this.getValidated(transformer3WData1.validated));
        }
    }

    private void write(String id, String label, boolean writeFirst, double first, boolean writeSecond, double second) throws IOException {
        this.formatter.writeCell(id).writeCell(label);
        if (this.compareResults) {
            this.formatter = writeFirst ? this.formatter.writeCell(first) : this.formatter.writeEmptyCell();
        }
        this.formatter = writeSecond ? this.formatter.writeCell(second) : this.formatter.writeEmptyCell();
    }

    private void write(String id, String label, boolean writeFirst, int first, boolean writeSecond, int second) throws IOException {
        this.formatter.writeCell(id).writeCell(label);
        if (this.compareResults) {
            this.formatter = writeFirst ? this.formatter.writeCell(first) : this.formatter.writeEmptyCell();
        }
        this.formatter = writeSecond ? this.formatter.writeCell(second) : this.formatter.writeEmptyCell();
    }

    private void write(String id, String label, boolean writeFirst, boolean first, boolean writeSecond, boolean second) throws IOException {
        this.formatter.writeCell(id).writeCell(label);
        if (this.compareResults) {
            this.formatter = writeFirst ? this.formatter.writeCell(first) : this.formatter.writeEmptyCell();
        }
        this.formatter = writeSecond ? this.formatter.writeCell(second) : this.formatter.writeEmptyCell();
    }

    private void write(String id, String label, boolean writeFirst, String first, boolean writeSecond, String second) throws IOException {
        this.formatter.writeCell(id).writeCell(label);
        if (this.compareResults) {
            this.formatter = writeFirst ? this.formatter.writeCell(first) : this.formatter.writeEmptyCell();
        }
        this.formatter = writeSecond ? this.formatter.writeCell(second) : this.formatter.writeEmptyCell();
    }
}

