/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerPhaseAngleClock;
import com.powsybl.iidm.network.util.TwtData;
import com.powsybl.loadflow.validation.AbstractTransformersValidation;
import com.powsybl.loadflow.validation.ValidationConfig;
import com.powsybl.loadflow.validation.ValidationType;
import com.powsybl.loadflow.validation.ValidationUtils;
import com.powsybl.loadflow.validation.io.ValidationWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Transformers3WValidation
extends AbstractTransformersValidation {
    private static final Logger LOGGER = LoggerFactory.getLogger(Transformers3WValidation.class);
    public static final Transformers3WValidation INSTANCE = new Transformers3WValidation();

    private Transformers3WValidation() {
    }

    @Override
    public boolean checkTransformers(Network network, ValidationConfig config, ValidationWriter twtsWriter) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(config);
        Objects.requireNonNull(twtsWriter);
        LOGGER.info("Checking 3W transformers of network {}", (Object)network.getId());
        return network.getThreeWindingsTransformerStream().sorted(Comparator.comparing(Identifiable::getId)).map(twt -> this.checkTransformer((ThreeWindingsTransformer)twt, config, twtsWriter)).reduce(Boolean::logicalAnd).orElse(true);
    }

    public boolean checkTransformer(ThreeWindingsTransformer twt, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(twt);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter twtsWriter = ValidationUtils.createValidationWriter(twt.getId(), config, writer, ValidationType.TWTS3W);
            try {
                bl = this.checkTransformer(twt, config, twtsWriter);
                if (twtsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (twtsWriter != null) {
                        try {
                            twtsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            twtsWriter.close();
        }
        return bl;
    }

    public boolean checkTransformer(ThreeWindingsTransformer twt, ValidationConfig config, ValidationWriter twtsWriter) {
        Objects.requireNonNull(twt);
        Objects.requireNonNull(config);
        Objects.requireNonNull(twtsWriter);
        int phaseAngleClock2 = 0;
        int phaseAngleClock3 = 0;
        ThreeWindingsTransformerPhaseAngleClock phaseAngleClockExtension = (ThreeWindingsTransformerPhaseAngleClock)twt.getExtension(ThreeWindingsTransformerPhaseAngleClock.class);
        if (phaseAngleClockExtension != null) {
            phaseAngleClock2 = phaseAngleClockExtension.getPhaseAngleClockLeg2();
            phaseAngleClock3 = phaseAngleClockExtension.getPhaseAngleClockLeg3();
        }
        boolean validated = true;
        TwtData twtData = new TwtData(twt, phaseAngleClock2, phaseAngleClock3, config.getEpsilonX(), config.applyReactanceCorrection(), config.getLoadFlowParameters().isTwtSplitShuntAdmittance());
        validated &= Transformers3WValidation.checkLeg(twtData, ThreeSides.ONE, config);
        validated &= Transformers3WValidation.checkLeg(twtData, ThreeSides.TWO, config);
        validated &= Transformers3WValidation.checkLeg(twtData, ThreeSides.THREE, config);
        try {
            twtsWriter.write(twt.getId(), twtData, validated);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return validated;
    }

    private static boolean checkLeg(TwtData twtData, ThreeSides side, ValidationConfig config) {
        boolean validated = true;
        if (twtData.isConnected(side) && twtData.isMainComponent(side)) {
            if (ValidationUtils.areNaN(config, twtData.getP(side), twtData.getComputedP(side)) || Math.abs(twtData.getP(side) - twtData.getComputedP(side)) > config.getThreshold()) {
                LOGGER.warn("{} {}: {} side {}, P {} {}", new Object[]{ValidationType.TWTS3W, "validation error", twtData.getId(), side, twtData.getP(side), twtData.getComputedP(side)});
                validated = false;
            }
            if (ValidationUtils.areNaN(config, twtData.getQ(side), twtData.getComputedQ(side)) || Math.abs(twtData.getQ(side) - twtData.getComputedQ(side)) > config.getThreshold()) {
                LOGGER.warn("{} {}: {} side {}, Q {} {}", new Object[]{ValidationType.TWTS3W, "validation error", twtData.getId(), side, twtData.getQ(side), twtData.getComputedQ(side)});
                validated = false;
            }
        }
        return validated;
    }
}

