/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.io.table.CsvTableFormatterFactory;
import com.powsybl.commons.io.table.TableFormatterFactory;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.validation.ValidationOutputWriter;
import java.util.Objects;
import java.util.Optional;

public class ValidationConfig {
    public static final double THRESHOLD_DEFAULT = 0.0;
    public static final boolean VERBOSE_DEFAULT = false;
    public static final Class<? extends TableFormatterFactory> TABLE_FORMATTER_FACTORY_DEFAULT = CsvTableFormatterFactory.class;
    public static final double EPSILON_X_DEFAULT = 0.1;
    public static final boolean APPLY_REACTANCE_CORRECTION_DEFAULT = false;
    public static final ValidationOutputWriter VALIDATION_OUTPUT_WRITER_DEFAULT = ValidationOutputWriter.CSV_MULTILINE;
    public static final boolean OK_MISSING_VALUES_DEFAULT = false;
    public static final boolean NO_REQUIREMENT_IF_REACTIVE_BOUND_INVERSION_DEFAULT = false;
    public static final boolean COMPARE_RESULTS_DEFAULT = false;
    public static final boolean CHECK_MAIN_COMPONENT_ONLY_DEFAULT = true;
    public static final boolean NO_REQUIREMENT_IF_SETPOINT_OUTSIDE_POWERS_BOUNDS = false;
    private double threshold;
    private boolean verbose;
    private String loadFlowName;
    private Class<? extends TableFormatterFactory> tableFormatterFactory;
    private double epsilonX;
    private boolean applyReactanceCorrection;
    private ValidationOutputWriter validationOutputWriter;
    private LoadFlowParameters loadFlowParameters;
    private boolean okMissingValues;
    private boolean noRequirementIfReactiveBoundInversion;
    private boolean compareResults;
    private boolean checkMainComponentOnly;
    private boolean noRequirementIfSetpointOutsidePowerBounds;

    public static ValidationConfig load() {
        return ValidationConfig.load(PlatformConfig.defaultConfig());
    }

    public static ValidationConfig load(PlatformConfig platformConfig) {
        LoadFlowParameters loadFlowParameter = LoadFlowParameters.load((PlatformConfig)platformConfig);
        Optional config = platformConfig.getOptionalModuleConfig("loadflow-validation");
        double threshold = config.map(c -> c.getOptionalDoubleProperty("threshold").orElse(0.0)).orElse(0.0);
        boolean verbose = config.flatMap(c -> c.getOptionalBooleanProperty("verbose")).orElse(false);
        String loadFlowName = config.flatMap(c -> c.getOptionalStringProperty("load-flow-name")).orElse(null);
        Class<? extends TableFormatterFactory> tableFormatterFactory = config.flatMap(c -> c.getOptionalClassProperty("table-formatter-factory", TableFormatterFactory.class)).orElse(TABLE_FORMATTER_FACTORY_DEFAULT);
        double epsilonX = config.map(c -> c.getOptionalDoubleProperty("epsilon-x").orElse(0.1)).orElse(0.1);
        boolean applyReactanceCorrection = config.flatMap(c -> c.getOptionalBooleanProperty("apply-reactance-correction")).orElse(false);
        ValidationOutputWriter validationOutputWriter = config.flatMap(c -> c.getOptionalEnumProperty("output-writer", ValidationOutputWriter.class)).orElse(VALIDATION_OUTPUT_WRITER_DEFAULT);
        boolean okMissingValues = config.flatMap(c -> c.getOptionalBooleanProperty("ok-missing-values")).orElse(false);
        boolean noRequirementIfReactiveBoundInversion = config.flatMap(c -> c.getOptionalBooleanProperty("no-requirement-if-reactive-bound-inversion")).orElse(false);
        boolean compareResults = config.flatMap(c -> c.getOptionalBooleanProperty("compare-results")).orElse(false);
        boolean checkMainComponentOnly = config.flatMap(c -> c.getOptionalBooleanProperty("check-main-component-only")).orElse(true);
        boolean noRequirementIfSetpointOutsidePowerBounds = config.flatMap(c -> c.getOptionalBooleanProperty("no-requirement-if-setpoint-outside-power-bounds")).orElse(false);
        return new ValidationConfig(threshold, verbose, loadFlowName, tableFormatterFactory, epsilonX, applyReactanceCorrection, validationOutputWriter, loadFlowParameter, okMissingValues, noRequirementIfReactiveBoundInversion, compareResults, checkMainComponentOnly, noRequirementIfSetpointOutsidePowerBounds);
    }

    public ValidationConfig(double threshold, boolean verbose, String loadFlowName, Class<? extends TableFormatterFactory> tableFormatterFactory, double epsilonX, boolean applyReactanceCorrection, ValidationOutputWriter validationOutputWriter, LoadFlowParameters loadFlowParameters, boolean okMissingValues, boolean noRequirementIfReactiveBoundInversion, boolean compareResults, boolean checkMainComponentOnly, boolean noRequirementIfSetpointOutsidePowerBounds) {
        if (threshold < 0.0) {
            throw new IllegalArgumentException("Negative values for threshold not permitted");
        }
        if (epsilonX < 0.0) {
            throw new IllegalArgumentException("Negative values for epsilonX not permitted");
        }
        this.threshold = threshold;
        this.verbose = verbose;
        this.loadFlowName = loadFlowName;
        this.tableFormatterFactory = Objects.requireNonNull(tableFormatterFactory);
        this.epsilonX = epsilonX;
        this.applyReactanceCorrection = applyReactanceCorrection;
        this.validationOutputWriter = Objects.requireNonNull(validationOutputWriter);
        this.loadFlowParameters = Objects.requireNonNull(loadFlowParameters);
        this.okMissingValues = okMissingValues;
        this.noRequirementIfReactiveBoundInversion = noRequirementIfReactiveBoundInversion;
        this.compareResults = compareResults;
        this.checkMainComponentOnly = checkMainComponentOnly;
        this.noRequirementIfSetpointOutsidePowerBounds = noRequirementIfSetpointOutsidePowerBounds;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Optional<String> getLoadFlowName() {
        return Optional.ofNullable(this.loadFlowName);
    }

    public Class<? extends TableFormatterFactory> getTableFormatterFactory() {
        return this.tableFormatterFactory;
    }

    public double getEpsilonX() {
        return this.epsilonX;
    }

    public ValidationOutputWriter getValidationOutputWriter() {
        return this.validationOutputWriter;
    }

    public boolean applyReactanceCorrection() {
        return this.applyReactanceCorrection;
    }

    public LoadFlowParameters getLoadFlowParameters() {
        return this.loadFlowParameters;
    }

    public boolean areOkMissingValues() {
        return this.okMissingValues;
    }

    public boolean isNoRequirementIfReactiveBoundInversion() {
        return this.noRequirementIfReactiveBoundInversion;
    }

    public boolean isCompareResults() {
        return this.compareResults;
    }

    public boolean isCheckMainComponentOnly() {
        return this.checkMainComponentOnly;
    }

    public boolean isNoRequirementIfSetpointOutsidePowerBounds() {
        return this.noRequirementIfSetpointOutsidePowerBounds;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setLoadFlowName(String loadFlowName) {
        this.loadFlowName = loadFlowName;
    }

    public void setTableFormatterFactory(Class<? extends TableFormatterFactory> tableFormatterFactory) {
        this.tableFormatterFactory = Objects.requireNonNull(tableFormatterFactory);
    }

    public void setEpsilonX(double epsilonX) {
        this.epsilonX = epsilonX;
    }

    public void setApplyReactanceCorrection(boolean applyReactanceCorrection) {
        this.applyReactanceCorrection = applyReactanceCorrection;
    }

    public void setValidationOutputWriter(ValidationOutputWriter validationOutputWriter) {
        this.validationOutputWriter = Objects.requireNonNull(validationOutputWriter);
    }

    public void setLoadFlowParameters(LoadFlowParameters loadFlowParameters) {
        this.loadFlowParameters = Objects.requireNonNull(loadFlowParameters);
    }

    public void setOkMissingValues(boolean okMissingValues) {
        this.okMissingValues = okMissingValues;
    }

    public void setNoRequirementIfReactiveBoundInversion(boolean noRequirementIfReactiveBoundInversion) {
        this.noRequirementIfReactiveBoundInversion = noRequirementIfReactiveBoundInversion;
    }

    public void setCompareResults(boolean compareResults) {
        this.compareResults = compareResults;
    }

    public void setCheckMainComponentOnly(boolean checkMainComponentOnly) {
        this.checkMainComponentOnly = checkMainComponentOnly;
    }

    public void setNoRequirementIfSetpointOutsidePowerBounds(boolean noRequirementIfSetpointOutsidePowerBounds) {
        this.noRequirementIfSetpointOutsidePowerBounds = noRequirementIfSetpointOutsidePowerBounds;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [threshold=" + this.threshold + ", verbose=" + this.verbose + ", loadFlowName=" + this.loadFlowName + ", tableFormatterFactory=" + this.tableFormatterFactory + ", epsilonX=" + this.epsilonX + ", applyReactanceCorrection=" + this.applyReactanceCorrection + ", validationOutputWriter=" + this.validationOutputWriter + ", loadFlowParameters=" + this.loadFlowParameters + ", okMissingValues=" + this.okMissingValues + ", noRequirementIfReactiveBoundInversion=" + this.noRequirementIfReactiveBoundInversion + ", compareResults=" + this.compareResults + ", checkMainComponentOnly=" + this.checkMainComponentOnly + ", noRequirementIfSetpointOutsidePowerBounds=" + this.noRequirementIfSetpointOutsidePowerBounds + "]";
    }
}

