/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.loadflow.validation.ValidationConfig;
import com.powsybl.loadflow.validation.ValidationType;
import com.powsybl.loadflow.validation.ValidationUtils;
import com.powsybl.loadflow.validation.io.ValidationWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BusesValidation {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusesValidation.class);
    public static final BusesValidation INSTANCE = new BusesValidation();

    private BusesValidation() {
    }

    public boolean checkBuses(Network network, ValidationConfig config, Path file) throws IOException {
        Objects.requireNonNull(network);
        Objects.requireNonNull(config);
        Objects.requireNonNull(file);
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            boolean bl = this.checkBuses(network, config, (Writer)writer);
            return bl;
        }
    }

    public boolean checkBuses(Network network, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(network);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter busesWriter = ValidationUtils.createValidationWriter(network.getId(), config, writer, ValidationType.BUSES);
            try {
                bl = this.checkBuses(network, config, busesWriter);
                if (busesWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (busesWriter != null) {
                        try {
                            busesWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            busesWriter.close();
        }
        return bl;
    }

    public boolean checkBuses(Network network, ValidationConfig config, ValidationWriter busesWriter) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(config);
        Objects.requireNonNull(busesWriter);
        LOGGER.info("Checking buses of network {}", (Object)network.getId());
        return network.getBusView().getBusStream().sorted(Comparator.comparing(Identifiable::getId)).map(bus -> this.checkBuses((Bus)bus, config, busesWriter)).reduce(Boolean::logicalAnd).orElse(true);
    }

    public boolean checkBuses(Bus bus, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(bus);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter bussWriter = ValidationUtils.createValidationWriter(bus.getId(), config, writer, ValidationType.BUSES);
            try {
                bl = this.checkBuses(bus, config, bussWriter);
                if (bussWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bussWriter != null) {
                        try {
                            bussWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            bussWriter.close();
        }
        return bl;
    }

    public boolean checkBuses(Bus bus, ValidationConfig config, ValidationWriter busesWriter) {
        Objects.requireNonNull(bus);
        Objects.requireNonNull(config);
        Objects.requireNonNull(busesWriter);
        double loadP = bus.getLoadStream().map(Injection::getTerminal).mapToDouble(Terminal::getP).sum();
        double loadQ = bus.getLoadStream().map(Injection::getTerminal).mapToDouble(Terminal::getQ).sum();
        double genP = bus.getGeneratorStream().map(Injection::getTerminal).mapToDouble(Terminal::getP).sum();
        double genQ = bus.getGeneratorStream().map(Injection::getTerminal).mapToDouble(Terminal::getQ).sum();
        double batP = bus.getBatteryStream().map(Injection::getTerminal).mapToDouble(Terminal::getP).sum();
        double batQ = bus.getBatteryStream().map(Injection::getTerminal).mapToDouble(Terminal::getQ).sum();
        double shuntP = bus.getShuntCompensatorStream().map(Injection::getTerminal).mapToDouble(Terminal::getP).map(p -> Double.isNaN(p) ? 0.0 : p).sum();
        double shuntQ = bus.getShuntCompensatorStream().map(Injection::getTerminal).mapToDouble(Terminal::getQ).sum();
        double svcP = bus.getStaticVarCompensatorStream().map(Injection::getTerminal).mapToDouble(Terminal::getP).sum();
        double svcQ = bus.getStaticVarCompensatorStream().map(Injection::getTerminal).mapToDouble(Terminal::getQ).sum();
        double vscCSP = bus.getVscConverterStationStream().map(Injection::getTerminal).mapToDouble(Terminal::getP).sum();
        double vscCSQ = bus.getVscConverterStationStream().map(Injection::getTerminal).mapToDouble(Terminal::getQ).sum();
        double lineP = bus.getLineStream().map(line -> BusesValidation.getBranchTerminal((Branch)line, bus)).mapToDouble(Terminal::getP).sum();
        double lineQ = bus.getLineStream().map(line -> BusesValidation.getBranchTerminal((Branch)line, bus)).mapToDouble(Terminal::getQ).sum();
        double danglingLineP = bus.getDanglingLineStream(DanglingLineFilter.ALL).map(Injection::getTerminal).mapToDouble(Terminal::getP).sum();
        double danglingLineQ = bus.getDanglingLineStream(DanglingLineFilter.ALL).map(Injection::getTerminal).mapToDouble(Terminal::getQ).sum();
        double t2wtP = bus.getTwoWindingsTransformerStream().map(twt -> BusesValidation.getBranchTerminal((Branch)twt, bus)).mapToDouble(Terminal::getP).sum();
        double t2wtQ = bus.getTwoWindingsTransformerStream().map(twt -> BusesValidation.getBranchTerminal((Branch)twt, bus)).mapToDouble(Terminal::getQ).sum();
        double t3wtP = bus.getThreeWindingsTransformerStream().map(tlt -> BusesValidation.getThreeWindingsTransformerTerminal(tlt, bus)).mapToDouble(Terminal::getP).sum();
        double t3wtQ = bus.getThreeWindingsTransformerStream().map(tlt -> BusesValidation.getThreeWindingsTransformerTerminal(tlt, bus)).mapToDouble(Terminal::getQ).sum();
        boolean mainComponent = bus.isInMainConnectedComponent();
        return this.checkBuses(bus.getId(), loadP, loadQ, BusesValidation.getValue(genP), BusesValidation.getValue(genQ), batP, batQ, shuntP, shuntQ, svcP, svcQ, vscCSP, vscCSQ, lineP, lineQ, danglingLineP, danglingLineQ, t2wtP, t2wtQ, t3wtP, t3wtQ, mainComponent, config, busesWriter);
    }

    private static double getValue(double value) {
        return Double.isNaN(value) ? 0.0 : value;
    }

    private static Terminal getBranchTerminal(Branch branch, Bus bus) {
        if (branch.getTerminal1().isConnected() && bus.getId().equals(branch.getTerminal1().getBusView().getBus().getId())) {
            return branch.getTerminal1();
        }
        return branch.getTerminal2();
    }

    private static Terminal getThreeWindingsTransformerTerminal(ThreeWindingsTransformer tlt, Bus bus) {
        if (tlt.getLeg1().getTerminal().isConnected() && bus.getId().equals(tlt.getLeg1().getTerminal().getBusView().getBus().getId())) {
            return tlt.getLeg1().getTerminal();
        }
        if (tlt.getLeg2().getTerminal().isConnected() && bus.getId().equals(tlt.getLeg2().getTerminal().getBusView().getBus().getId())) {
            return tlt.getLeg2().getTerminal();
        }
        return tlt.getLeg3().getTerminal();
    }

    public boolean checkBuses(String id, double loadP, double loadQ, double genP, double genQ, double batP, double batQ, double shuntP, double shuntQ, double svcP, double svcQ, double vscCSP, double vscCSQ, double lineP, double lineQ, double danglingLineP, double danglingLineQ, double t2wtP, double t2wtQ, double t3wtP, double t3wtQ, boolean mainComponent, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(id);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter busesWriter = ValidationUtils.createValidationWriter(id, config, writer, ValidationType.BUSES);
            try {
                bl = this.checkBuses(id, loadP, loadQ, genP, genQ, batP, batQ, shuntP, shuntQ, svcP, svcQ, vscCSP, vscCSQ, lineP, lineQ, danglingLineP, danglingLineQ, t2wtP, t2wtQ, t3wtP, t3wtQ, mainComponent, config, busesWriter);
                if (busesWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (busesWriter != null) {
                        try {
                            busesWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            busesWriter.close();
        }
        return bl;
    }

    public boolean checkBuses(String id, double loadP, double loadQ, double genP, double genQ, double batP, double batQ, double shuntP, double shuntQ, double svcP, double svcQ, double vscCSP, double vscCSQ, double lineP, double lineQ, double danglingLineP, double danglingLineQ, double t2wtP, double t2wtQ, double t3wtP, double t3wtQ, boolean mainComponent, ValidationConfig config, ValidationWriter busesWriter) {
        Objects.requireNonNull(id);
        boolean validated = true;
        double incomingP = genP + batP + shuntP + svcP + vscCSP + lineP + danglingLineP + t2wtP + t3wtP;
        double incomingQ = genQ + batQ + shuntQ + svcQ + vscCSQ + lineQ + danglingLineQ + t2wtQ + t3wtQ;
        if (ValidationUtils.isMainComponent(config, mainComponent)) {
            if (ValidationUtils.areNaN(config, incomingP, loadP) || Math.abs(incomingP + loadP) > config.getThreshold()) {
                LOGGER.warn("{} {}: {} P {} {}", new Object[]{ValidationType.BUSES, "validation error", id, incomingP, loadP});
                validated = false;
            }
            if (ValidationUtils.areNaN(config, incomingQ, loadQ) || Math.abs(incomingQ + loadQ) > config.getThreshold()) {
                LOGGER.warn("{} {}: {} Q {} {}", new Object[]{ValidationType.BUSES, "validation error", id, incomingQ, loadQ});
                validated = false;
            }
        }
        try {
            busesWriter.write(id, incomingP, incomingQ, loadP, loadQ, genP, genQ, batP, batQ, shuntP, shuntQ, svcP, svcQ, vscCSP, vscCSQ, lineP, lineQ, danglingLineP, danglingLineQ, t2wtP, t2wtQ, t3wtP, t3wtQ, mainComponent, validated);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return validated;
    }
}

