/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.powsybl.commons.PowsyblException;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.network.ImportConfig;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.tools.ConversionToolUtils;
import com.powsybl.loadflow.LoadFlow;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.validation.CandidateComputation;
import com.powsybl.loadflow.validation.CandidateComputations;
import com.powsybl.loadflow.validation.ValidationConfig;
import com.powsybl.loadflow.validation.ValidationOutputWriter;
import com.powsybl.loadflow.validation.ValidationType;
import com.powsybl.loadflow.validation.io.ValidationWriters;
import com.powsybl.tools.Command;
import com.powsybl.tools.Tool;
import com.powsybl.tools.ToolRunningContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@AutoService(value={Tool.class})
public class ValidationTool
implements Tool {
    private static final String CASE_FILE = "case-file";
    private static final String OUTPUT_FOLDER = "output-folder";
    private static final String LOAD_FLOW = "load-flow";
    private static final String VERBOSE = "verbose";
    private static final String OUTPUT_FORMAT = "output-format";
    private static final String TYPES = "types";
    private static final String COMPARE_RESULTS = "compare-results";
    private static final String RUN_COMPUTATION = "run-computation";
    private static final String COMPARE_CASE_FILE = "compare-case-file";
    private static final Command COMMAND = new Command(){

        public String getName() {
            return "loadflow-validation";
        }

        public String getTheme() {
            return "Computation";
        }

        public String getDescription() {
            return "Validate load-flow results of a network";
        }

        public Options getOptions() {
            Options options = new Options();
            options.addOption(Option.builder().longOpt(ValidationTool.CASE_FILE).desc("case file path").hasArg().argName("FILE").required().build());
            options.addOption(Option.builder().longOpt(ValidationTool.OUTPUT_FOLDER).desc("output folder path").hasArg().argName("FOLDER").required().build());
            options.addOption(Option.builder().longOpt(ValidationTool.LOAD_FLOW).desc("run loadflow").build());
            options.addOption(Option.builder().longOpt(ValidationTool.RUN_COMPUTATION).desc("run a computation on the network before validation, available computations are " + Arrays.toString(CandidateComputations.getComputationsNames().toArray())).hasArg().argName("COMPUTATION").build());
            options.addOption(Option.builder().longOpt(ValidationTool.VERBOSE).desc("verbose output").build());
            options.addOption(Option.builder().longOpt(ValidationTool.OUTPUT_FORMAT).desc("output format " + Arrays.toString((Object[])ValidationOutputWriter.values())).hasArg().argName("VALIDATION_WRITER").build());
            options.addOption(Option.builder().longOpt(ValidationTool.TYPES).desc("validation types " + Arrays.toString((Object[])ValidationType.values()) + " to run, all of them if the option if not specified").hasArg().argName("VALIDATION_TYPE,VALIDATION_TYPE,...").build());
            options.addOption(Option.builder().longOpt(ValidationTool.COMPARE_RESULTS).desc("compare results of two validations, printing output files with results of both ones. Available comparisons are " + Arrays.toString((Object[])ComparisonType.values())).hasArg().argName("COMPARISON_TYPE").build());
            options.addOption(Option.builder().longOpt(ValidationTool.COMPARE_CASE_FILE).desc("path to the case file to compare").hasArg().argName("FILE").build());
            options.addOption(ConversionToolUtils.createImportParametersFileOption());
            options.addOption(ConversionToolUtils.createImportParameterOption());
            return options;
        }

        public String getUsageFooter() {
            return null;
        }
    };

    public Command getCommand() {
        return COMMAND;
    }

    public void run(CommandLine line, ToolRunningContext context) throws Exception {
        Path caseFile = Paths.get(line.getOptionValue(CASE_FILE), new String[0]);
        Path outputFolder = Paths.get(line.getOptionValue(OUTPUT_FOLDER), new String[0]);
        if (!Files.exists(outputFolder, new LinkOption[0])) {
            Files.createDirectories(outputFolder, new FileAttribute[0]);
        }
        ValidationConfig config = ValidationConfig.load();
        if (line.hasOption(VERBOSE)) {
            config.setVerbose(true);
        }
        if (line.hasOption(OUTPUT_FORMAT)) {
            config.setValidationOutputWriter(ValidationOutputWriter.valueOf(line.getOptionValue(OUTPUT_FORMAT)));
        }
        ComparisonType comparisonType = null;
        if (line.hasOption(COMPARE_RESULTS)) {
            config.setCompareResults(true);
            comparisonType = ComparisonType.valueOf(line.getOptionValue(COMPARE_RESULTS));
        }
        Set<Object> validationTypes = Sets.newHashSet((Object[])ValidationType.values());
        if (line.hasOption(TYPES)) {
            validationTypes = Arrays.stream(line.getOptionValue(TYPES).split(",")).map(ValidationType::valueOf).collect(Collectors.toSet());
        }
        Network network = this.loadNetwork(caseFile, line, context);
        try (ValidationWriters validationWriters = new ValidationWriters(network.getId(), validationTypes, outputFolder, config);){
            if (config.isCompareResults() && ComparisonType.COMPUTATION.equals((Object)comparisonType)) {
                Preconditions.checkArgument((line.hasOption(LOAD_FLOW) || line.hasOption(RUN_COMPUTATION) ? 1 : 0) != 0, (Object)"Computation results comparison requires to run a computation (options --load-flow or --run-computation).");
                context.getOutputStream().println("Running pre-loadflow validation on network " + network.getId());
                this.runValidation(network, config, validationTypes, validationWriters, context);
            }
            if (line.hasOption(LOAD_FLOW)) {
                this.runLoadflow(network, config, context);
                context.getOutputStream().println("Running post-loadflow validation on network " + network.getId());
            } else if (line.hasOption(RUN_COMPUTATION)) {
                this.runComputation(line.getOptionValue(RUN_COMPUTATION), network, context);
                context.getOutputStream().println("Running post-computation validation on network " + network.getId());
            }
            this.runValidation(network, config, validationTypes, validationWriters, context);
            if (config.isCompareResults() && ComparisonType.BASECASE.equals((Object)comparisonType)) {
                Preconditions.checkArgument((boolean)line.hasOption(COMPARE_CASE_FILE), (Object)"Basecases comparison requires to provide a second basecase (option --compare-case-file).");
                Path compareCaseFile = Paths.get(line.getOptionValue(COMPARE_CASE_FILE), new String[0]);
                Network compareNetwork = this.loadNetwork(compareCaseFile, line, context);
                context.getOutputStream().println("Running validation on network " + compareNetwork.getId() + " to compare");
                this.runValidation(compareNetwork, config, validationTypes, validationWriters, context);
            }
        }
    }

    private Network loadNetwork(Path caseFile, CommandLine line, ToolRunningContext context) throws IOException {
        context.getOutputStream().println("Loading case " + caseFile);
        Properties inputParams = ConversionToolUtils.readProperties((CommandLine)line, (ConversionToolUtils.OptionType)ConversionToolUtils.OptionType.IMPORT, (ToolRunningContext)context);
        Network network = Network.read((Path)caseFile, (ComputationManager)context.getShortTimeExecutionComputationManager(), (ImportConfig)ImportConfig.load(), (Properties)inputParams);
        if (network == null) {
            throw new PowsyblException("Case " + caseFile + " not found");
        }
        return network;
    }

    private void runValidation(Network network, ValidationConfig config, Set<ValidationType> validationTypes, ValidationWriters validationWriter, ToolRunningContext context) {
        validationTypes.forEach(validationType -> {
            context.getOutputStream().println("Validate load-flow results of network " + network.getId() + " - validation type: " + validationType + " - result: " + (validationType.check(network, config, validationWriter.getWriter((ValidationType)((Object)validationType))) ? "success" : "fail"));
            validationWriter.getWriter((ValidationType)((Object)validationType)).setValidationCompleted();
        });
    }

    private void runLoadflow(Network network, ValidationConfig config, ToolRunningContext context) {
        context.getOutputStream().println("Running loadflow on network " + network.getId());
        LoadFlowParameters parameters = LoadFlowParameters.load();
        String loadFlowName = config.getLoadFlowName().orElse(null);
        ((CompletableFuture)LoadFlow.find((String)loadFlowName).runAsync(network, "InitialState", context.getShortTimeExecutionComputationManager(), parameters).thenAccept(loadFlowResult -> {
            if (!loadFlowResult.isOk()) {
                throw new PowsyblException("Loadflow on network " + network.getId() + " does not converge");
            }
        })).join();
    }

    private void runComputation(String computationName, Network network, ToolRunningContext context) {
        CandidateComputation computation = CandidateComputations.getComputation(computationName).orElseThrow(() -> new IllegalArgumentException("Unknown computation type : " + computationName));
        context.getOutputStream().format("Running computation '%s' on network '%s'", computationName, network.getId()).println();
        computation.run(network, context.getShortTimeExecutionComputationManager());
    }

    static enum ComparisonType {
        COMPUTATION("compare the validation of a basecase before and after the computation"),
        BASECASE("compare the validation of two basecases");

        private final String description;

        private ComparisonType(String description) {
            this.description = Objects.requireNonNull(description);
        }

        public String toString() {
            return this.name() + " (" + this.description + ")";
        }
    }
}

