/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.validation.BalanceTypeGuesser;
import com.powsybl.loadflow.validation.ValidationConfig;
import com.powsybl.loadflow.validation.ValidationType;
import com.powsybl.loadflow.validation.ValidationUtils;
import com.powsybl.loadflow.validation.io.ValidationWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneratorsValidation {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratorsValidation.class);
    public static final GeneratorsValidation INSTANCE = new GeneratorsValidation();

    private GeneratorsValidation() {
    }

    public boolean checkGenerators(Network network, ValidationConfig config, Path file) throws IOException {
        Objects.requireNonNull(network);
        Objects.requireNonNull(config);
        Objects.requireNonNull(file);
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            boolean bl = this.checkGenerators(network, config, (Writer)writer);
            return bl;
        }
    }

    public boolean checkGenerators(Network network, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(network);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter generatorsWriter = ValidationUtils.createValidationWriter(network.getId(), config, writer, ValidationType.GENERATORS);
            try {
                bl = this.checkGenerators(network, config, generatorsWriter);
                if (generatorsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (generatorsWriter != null) {
                        try {
                            generatorsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            generatorsWriter.close();
        }
        return bl;
    }

    public boolean checkGenerators(Network network, ValidationConfig config, ValidationWriter generatorsWriter) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(config);
        Objects.requireNonNull(generatorsWriter);
        LOGGER.info("Checking generators of network {}", (Object)network.getId());
        BalanceTypeGuesser guesser = new BalanceTypeGuesser(network, config.getThreshold());
        LOGGER.info("Using {} balance type", (Object)guesser.getBalanceType());
        return network.getGeneratorStream().sorted(Comparator.comparing(Identifiable::getId)).map(gen -> this.checkGenerators((Generator)gen, config, generatorsWriter, guesser)).reduce(Boolean::logicalAnd).orElse(true);
    }

    public boolean checkGenerators(Generator gen, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(gen);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter generatorsWriter = ValidationUtils.createValidationWriter(gen.getId(), config, writer, ValidationType.GENERATORS);
            try {
                bl = this.checkGenerators(gen, config, generatorsWriter, new BalanceTypeGuesser());
                if (generatorsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (generatorsWriter != null) {
                        try {
                            generatorsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            generatorsWriter.close();
        }
        return bl;
    }

    public boolean checkGenerators(Generator gen, ValidationConfig config, ValidationWriter generatorsWriter, BalanceTypeGuesser guesser) {
        Objects.requireNonNull(gen);
        Objects.requireNonNull(config);
        Objects.requireNonNull(generatorsWriter);
        double p = gen.getTerminal().getP();
        double q = gen.getTerminal().getQ();
        Bus bus = gen.getTerminal().getBusView().getBus();
        double targetP = gen.getTargetP();
        double targetQ = gen.getTargetQ();
        double targetV = gen.getTargetV();
        boolean voltageRegulatorOn = gen.isVoltageRegulatorOn();
        double minP = gen.getMinP();
        double maxP = gen.getMaxP();
        double minQ = gen.getReactiveLimits().getMinQ(targetP);
        double maxQ = gen.getReactiveLimits().getMaxQ(targetP);
        double v = bus != null ? bus.getV() : Double.NaN;
        boolean connected = bus != null;
        Bus connectableBus = gen.getTerminal().getBusView().getConnectableBus();
        boolean connectableMainComponent = connectableBus != null && connectableBus.isInMainConnectedComponent();
        boolean mainComponent = bus != null ? bus.isInMainConnectedComponent() : connectableMainComponent;
        return this.checkGenerators(gen.getId(), p, q, v, targetP, targetQ, targetV, voltageRegulatorOn, minP, maxP, minQ, maxQ, connected, mainComponent, config, generatorsWriter, guesser);
    }

    public boolean checkGenerators(String id, double p, double q, double v, double targetP, double targetQ, double targetV, boolean voltageRegulatorOn, double minP, double maxP, double minQ, double maxQ, boolean connected, boolean mainComponent, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(id);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter generatorsWriter = ValidationUtils.createValidationWriter(id, config, writer, ValidationType.GENERATORS);
            try {
                bl = this.checkGenerators(id, p, q, v, targetP, targetQ, targetV, voltageRegulatorOn, minP, maxP, minQ, maxQ, connected, mainComponent, config, generatorsWriter, new BalanceTypeGuesser());
                if (generatorsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (generatorsWriter != null) {
                        try {
                            generatorsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            generatorsWriter.close();
        }
        return bl;
    }

    public boolean checkGenerators(String id, double p, double q, double v, double targetP, double targetQ, double targetV, boolean voltageRegulatorOn, double minP, double maxP, double minQ, double maxQ, boolean connected, boolean mainComponent, ValidationConfig config, ValidationWriter generatorsWriter, BalanceTypeGuesser guesser) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(config);
        Objects.requireNonNull(generatorsWriter);
        boolean validated = true;
        double expectedP = GeneratorsValidation.getExpectedP(guesser, id, p, targetP, minP, maxP, config.getThreshold());
        if (connected && ValidationUtils.isMainComponent(config, mainComponent)) {
            validated = Double.isNaN(p) || Double.isNaN(q) ? GeneratorsValidation.checkGeneratorsNaNValues(id, p, q, targetP, targetQ) : (GeneratorsValidation.checkReactiveBoundInversion(minQ, maxQ, config) ? true : (GeneratorsValidation.checkSetpointOutsidePowerBounds(targetP, minP, maxP, config) ? true : GeneratorsValidation.checkGeneratorsValues(id, p, q, v, expectedP, targetQ, targetV, voltageRegulatorOn, minQ, maxQ, config)));
        }
        try {
            generatorsWriter.write(id, p, q, v, targetP, targetQ, targetV, expectedP, connected, voltageRegulatorOn, minP, maxP, minQ, maxQ, mainComponent, validated);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return validated;
    }

    private static double getExpectedP(BalanceTypeGuesser guesser, String id, double p, double targetP, double minP, double maxP, double threshold) {
        if (Math.abs(p + targetP) <= threshold) {
            return targetP;
        }
        switch (guesser.getBalanceType()) {
            case NONE: {
                return id.equals(guesser.getSlack()) ? -p : targetP;
            }
            case PROPORTIONAL_TO_GENERATION_P_MAX: {
                return Math.max(Math.max(0.0, minP), Math.min(maxP, targetP + maxP * guesser.getKMax()));
            }
            case PROPORTIONAL_TO_GENERATION_P: {
                return Math.max(Math.max(0.0, minP), Math.min(maxP, targetP + targetP * guesser.getKTarget()));
            }
            case PROPORTIONAL_TO_GENERATION_HEADROOM: {
                return Math.max(Math.max(0.0, minP), Math.min(maxP, targetP + (maxP - targetP) * guesser.getKHeadroom()));
            }
        }
        throw new IllegalStateException("Unhandled Balance Type: " + guesser.getBalanceType());
    }

    private static boolean checkGeneratorsNaNValues(String id, double p, double q, double targetP, double targetQ) {
        if (!Double.isNaN(targetP) && targetP != 0.0 || !Double.isNaN(targetQ) && targetQ != 0.0) {
            LOGGER.warn("{} {}: {}: P={} targetP={} - Q={} targetQ={}", new Object[]{ValidationType.GENERATORS, "validation error", id, p, targetP, q, targetQ});
            return false;
        }
        return true;
    }

    private static boolean checkGeneratorsValues(String id, double p, double q, double v, double expectedP, double targetQ, double targetV, boolean voltageRegulatorOn, double minQ, double maxQ, ValidationConfig config) {
        boolean validated = true;
        if (ValidationUtils.areNaN(config, expectedP) || Math.abs(p + expectedP) > config.getThreshold()) {
            LOGGER.warn("{} {}: {}: P={} expectedP={}", new Object[]{ValidationType.GENERATORS, "validation error", id, p, expectedP});
            validated = false;
        }
        if (!voltageRegulatorOn && (ValidationUtils.areNaN(config, targetQ) || Math.abs(q + targetQ) > config.getThreshold())) {
            LOGGER.warn("{} {}: {}: voltage regulator off - Q={} targetQ={}", new Object[]{ValidationType.GENERATORS, "validation error", id, q, targetQ});
            validated = false;
        }
        double qGen = -q;
        if (voltageRegulatorOn && (ValidationUtils.areNaN(config, minQ, maxQ, targetV) || v > targetV + config.getThreshold() && Math.abs(qGen - GeneratorsValidation.getMinQ(minQ, maxQ)) > config.getThreshold() || v < targetV - config.getThreshold() && Math.abs(qGen - GeneratorsValidation.getMaxQ(minQ, maxQ)) > config.getThreshold() || Math.abs(v - targetV) <= config.getThreshold() && !ValidationUtils.boundedWithin(minQ, maxQ, qGen, config.getThreshold()))) {
            LOGGER.warn("{} {}: {}: voltage regulator on - Q={} minQ={} maxQ={} - V={} targetV={}", new Object[]{ValidationType.GENERATORS, "validation error", id, qGen, minQ, maxQ, v, targetV});
            validated = false;
        }
        return validated;
    }

    private static double getMaxQ(double minQ, double maxQ) {
        return maxQ < minQ ? minQ : maxQ;
    }

    private static double getMinQ(double minQ, double maxQ) {
        return maxQ < minQ ? maxQ : minQ;
    }

    private static boolean checkReactiveBoundInversion(double minQ, double maxQ, ValidationConfig config) {
        return maxQ < minQ - config.getThreshold() && config.isNoRequirementIfReactiveBoundInversion();
    }

    private static boolean checkSetpointOutsidePowerBounds(double targetP, double minP, double maxP, ValidationConfig config) {
        return (targetP < minP - config.getThreshold() || targetP > maxP + config.getThreshold()) && config.isNoRequirementIfSetpointOutsidePowerBounds();
    }
}

