/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.loadflow.validation.ValidationConfig;
import com.powsybl.loadflow.validation.ValidationType;
import com.powsybl.loadflow.validation.ValidationUtils;
import com.powsybl.loadflow.validation.io.ValidationWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StaticVarCompensatorsValidation {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticVarCompensatorsValidation.class);
    public static final StaticVarCompensatorsValidation INSTANCE = new StaticVarCompensatorsValidation();

    private StaticVarCompensatorsValidation() {
    }

    public boolean checkSVCs(Network network, ValidationConfig config, Path file) throws IOException {
        Objects.requireNonNull(file);
        Objects.requireNonNull(config);
        Objects.requireNonNull(file);
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            boolean bl = this.checkSVCs(network, config, (Writer)writer);
            return bl;
        }
    }

    public boolean checkSVCs(Network network, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(network);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter svcsWriter = ValidationUtils.createValidationWriter(network.getId(), config, writer, ValidationType.SVCS);
            try {
                bl = this.checkSVCs(network, config, svcsWriter);
                if (svcsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (svcsWriter != null) {
                        try {
                            svcsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            svcsWriter.close();
        }
        return bl;
    }

    public boolean checkSVCs(Network network, ValidationConfig config, ValidationWriter svcsWriter) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(config);
        Objects.requireNonNull(svcsWriter);
        LOGGER.info("Checking static var compensators of network {}", (Object)network.getId());
        return network.getStaticVarCompensatorStream().sorted(Comparator.comparing(Identifiable::getId)).map(svc -> this.checkSVCs((StaticVarCompensator)svc, config, svcsWriter)).reduce(Boolean::logicalAnd).orElse(true);
    }

    public boolean checkSVCs(StaticVarCompensator svc, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(svc);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter svcsWriter = ValidationUtils.createValidationWriter(svc.getId(), config, writer, ValidationType.SVCS);
            try {
                bl = this.checkSVCs(svc, config, svcsWriter);
                if (svcsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (svcsWriter != null) {
                        try {
                            svcsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            svcsWriter.close();
        }
        return bl;
    }

    public boolean checkSVCs(StaticVarCompensator svc, ValidationConfig config, ValidationWriter svcsWriter) {
        Bus controlledBus;
        double vController;
        Objects.requireNonNull(svc);
        Objects.requireNonNull(config);
        Objects.requireNonNull(svcsWriter);
        double p = svc.getTerminal().getP();
        double q = svc.getTerminal().getQ();
        Bus bus = svc.getTerminal().getBusView().getBus();
        double reactivePowerSetpoint = svc.getReactivePowerSetpoint();
        double voltageSetpoint = svc.getVoltageSetpoint();
        StaticVarCompensator.RegulationMode regulationMode = svc.getRegulationMode();
        double bMin = svc.getBmin();
        double bMax = svc.getBmax();
        double nominalVcontroller = svc.getTerminal().getVoltageLevel().getNominalV();
        double d = vController = bus != null ? bus.getV() : Double.NaN;
        double vControlled = svc.getRegulatingTerminal() != null ? ((controlledBus = svc.getRegulatingTerminal().getBusView().getBus()) != null ? controlledBus.getV() : Double.NaN) : vController;
        boolean connected = bus != null;
        Bus connectableBus = svc.getTerminal().getBusView().getConnectableBus();
        boolean connectableMainComponent = connectableBus != null && connectableBus.isInMainConnectedComponent();
        boolean mainComponent = bus != null ? bus.isInMainConnectedComponent() : connectableMainComponent;
        return this.checkSVCs(svc.getId(), p, q, vControlled, vController, nominalVcontroller, reactivePowerSetpoint, voltageSetpoint, regulationMode, bMin, bMax, connected, mainComponent, config, svcsWriter);
    }

    public boolean checkSVCs(String id, double p, double q, double vControlled, double vController, double nominalVcontroller, double reactivePowerSetpoint, double voltageSetpoint, StaticVarCompensator.RegulationMode regulationMode, double bMin, double bMax, boolean connected, boolean mainComponent, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(id);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter svcsWriter = ValidationUtils.createValidationWriter(id, config, writer, ValidationType.SVCS);
            try {
                bl = this.checkSVCs(id, p, q, vControlled, vController, nominalVcontroller, reactivePowerSetpoint, voltageSetpoint, regulationMode, bMin, bMax, connected, mainComponent, config, svcsWriter);
                if (svcsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (svcsWriter != null) {
                        try {
                            svcsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            svcsWriter.close();
        }
        return bl;
    }

    public boolean checkSVCs(String id, double p, double q, double vControlled, double vController, double nominalVcontroller, double reactivePowerSetpoint, double voltageSetpoint, StaticVarCompensator.RegulationMode regulationMode, double bMin, double bMax, boolean connected, boolean mainComponent, ValidationConfig config, ValidationWriter svcsWriter) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(config);
        Objects.requireNonNull(svcsWriter);
        boolean validated = true;
        if (connected && ValidationUtils.isMainComponent(config, mainComponent)) {
            validated = Double.isNaN(p) || Double.isNaN(q) ? StaticVarCompensatorsValidation.checkSVCsNaNValues(id, p, q, reactivePowerSetpoint) : StaticVarCompensatorsValidation.checkSVCsValues(id, p, q, vControlled, vController, nominalVcontroller, reactivePowerSetpoint, voltageSetpoint, regulationMode, bMin, bMax, config);
        }
        try {
            svcsWriter.write(id, p, q, vControlled, vController, nominalVcontroller, reactivePowerSetpoint, voltageSetpoint, connected, regulationMode, bMin, bMax, mainComponent, validated);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return validated;
    }

    private static boolean checkSVCsNaNValues(String id, double p, double q, double reactivePowerSetpoint) {
        if (!Double.isNaN(reactivePowerSetpoint) && reactivePowerSetpoint != 0.0) {
            LOGGER.warn("{} {}: {}: P={} Q={} reactivePowerSetpoint={}", new Object[]{ValidationType.SVCS, "validation error", id, p, q, reactivePowerSetpoint});
            return false;
        }
        return true;
    }

    private static boolean checkSVCsValues(String id, double p, double q, double vControlled, double vController, double nominalVcontroller, double reactivePowerSetpoint, double voltageSetpoint, StaticVarCompensator.RegulationMode regulationMode, double bMin, double bMax, ValidationConfig config) {
        double qMax;
        double qMin;
        double vAux;
        boolean validated = true;
        if (Math.abs(p) > config.getThreshold()) {
            LOGGER.warn("{} {}: {}: P={}", new Object[]{ValidationType.SVCS, "validation error", id, p});
            validated = false;
        }
        if ((vAux = vController) == 0.0 || Double.isNaN(vAux)) {
            vAux = nominalVcontroller;
        }
        if (StaticVarCompensatorsValidation.reactivePowerRegulationModeKo(regulationMode, q, qMin = -bMax * vAux * vAux, qMax = -bMin * vAux * vAux, reactivePowerSetpoint, config)) {
            LOGGER.warn("{} {}: {}: regulator mode={} - Q={} qMin={} qMax={} bMin={} bMax={} Vcontroller={} nominalV={} reactivePowerSetpoint={}", new Object[]{ValidationType.SVCS, "validation error", id, regulationMode, q, qMin, qMax, bMin, bMax, vController, nominalVcontroller, reactivePowerSetpoint});
            validated = false;
        }
        if (StaticVarCompensatorsValidation.voltageRegulationModeKo(regulationMode, q, qMin, qMax, vControlled, voltageSetpoint, config)) {
            LOGGER.warn("{} {}: {}: regulator mode={} - Q={} qMin={} qMax={} bMin={} bMax={} Vcontroller={} Vcontrolled={} targetV={}", new Object[]{ValidationType.SVCS, "validation error", id, regulationMode, q, qMin, qMax, bMin, bMax, vController, vControlled, voltageSetpoint});
            validated = false;
        }
        if (StaticVarCompensatorsValidation.offRegulationModeKo(regulationMode, q, config)) {
            LOGGER.warn("{} {}: {}: regulator mode={} - Q={} ", new Object[]{ValidationType.SVCS, "validation error", id, regulationMode, q});
            validated = false;
        }
        return validated;
    }

    private static boolean reactivePowerRegulationModeKo(StaticVarCompensator.RegulationMode regulationMode, double q, double qMin, double qMax, double reactivePowerSetpoint, ValidationConfig config) {
        if (regulationMode != StaticVarCompensator.RegulationMode.REACTIVE_POWER) {
            return false;
        }
        if (ValidationUtils.areNaN(config, reactivePowerSetpoint, qMin, qMax)) {
            return true;
        }
        return Math.abs(q - reactivePowerSetpoint) > config.getThreshold();
    }

    private static boolean voltageRegulationModeKo(StaticVarCompensator.RegulationMode regulationMode, double q, double qMin, double qMax, double vControlled, double voltageSetpoint, ValidationConfig config) {
        if (regulationMode != StaticVarCompensator.RegulationMode.VOLTAGE) {
            return false;
        }
        if (ValidationUtils.areNaN(config, qMin, qMax, vControlled, voltageSetpoint)) {
            return true;
        }
        if (vControlled < voltageSetpoint - config.getThreshold() && Math.abs(q - qMax) > config.getThreshold()) {
            return true;
        }
        if (vControlled > voltageSetpoint + config.getThreshold() && Math.abs(q - qMin) > config.getThreshold()) {
            return true;
        }
        return Math.abs(vControlled - voltageSetpoint) < config.getThreshold() && !ValidationUtils.boundedWithin(qMin, qMax, q, config.getThreshold());
    }

    private static boolean offRegulationModeKo(StaticVarCompensator.RegulationMode regulationMode, double q, ValidationConfig config) {
        if (regulationMode != StaticVarCompensator.RegulationMode.OFF) {
            return false;
        }
        return Math.abs(q) > config.getThreshold();
    }
}

