/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.powsybl.commons.config.ConfigurationException;
import com.powsybl.loadflow.validation.ValidationConfig;
import com.powsybl.loadflow.validation.ValidationType;
import com.powsybl.loadflow.validation.io.ValidationWriter;
import com.powsybl.loadflow.validation.io.ValidationWriterFactory;
import java.io.Writer;
import java.util.Objects;

public final class ValidationUtils {
    public static final String VALIDATION_ERROR = "validation error";
    public static final String VALIDATION_WARNING = "validation warning";

    private ValidationUtils() {
    }

    public static ValidationWriter createValidationWriter(String id, ValidationConfig config, Writer writer, ValidationType validationType) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(config);
        Objects.requireNonNull(writer);
        Objects.requireNonNull(validationType);
        try {
            ValidationWriterFactory factory = config.getValidationOutputWriter().getValidationWriterFactory().newInstance();
            return factory.create(id, config.getTableFormatterFactory(), writer, config.isVerbose(), validationType, config.isCompareResults());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public static boolean areNaN(ValidationConfig config, float ... values) {
        Objects.requireNonNull(config);
        if (config.areOkMissingValues()) {
            return false;
        }
        boolean areNaN = false;
        for (float value : values) {
            if (!Float.isNaN(value)) continue;
            areNaN = true;
            break;
        }
        return areNaN;
    }

    public static boolean areNaN(ValidationConfig config, double ... values) {
        Objects.requireNonNull(config);
        if (config.areOkMissingValues()) {
            return false;
        }
        boolean areNaN = false;
        for (double value : values) {
            if (!Double.isNaN(value)) continue;
            areNaN = true;
            break;
        }
        return areNaN;
    }

    public static boolean boundedWithin(double lowerBound, double upperBound, double value, double margin) {
        if (Double.isNaN(value) || Double.isNaN(lowerBound) && Double.isNaN(upperBound)) {
            return false;
        }
        if (Double.isNaN(lowerBound)) {
            return value - margin <= upperBound;
        }
        if (Double.isNaN(upperBound)) {
            return value + margin >= lowerBound;
        }
        return value + margin >= lowerBound && value - margin <= upperBound;
    }

    public static boolean isMainComponent(ValidationConfig config, boolean mainComponent) {
        Objects.requireNonNull(config);
        return config.isCheckMainComponentOnly() ? mainComponent : true;
    }
}

