/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.validation.ValidationConfig;
import com.powsybl.loadflow.validation.ValidationType;
import com.powsybl.loadflow.validation.ValidationUtils;
import com.powsybl.loadflow.validation.io.ValidationWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

abstract class AbstractTransformersValidation {
    AbstractTransformersValidation() {
    }

    public boolean checkTransformers(Network network, ValidationConfig config, Path file) throws IOException {
        Objects.requireNonNull(network);
        Objects.requireNonNull(config);
        Objects.requireNonNull(file);
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            boolean bl = this.checkTransformers(network, config, writer);
            return bl;
        }
    }

    public boolean checkTransformers(Network network, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(network);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter twtsWriter = ValidationUtils.createValidationWriter(network.getId(), config, writer, ValidationType.TWTS3W);
            try {
                bl = this.checkTransformers(network, config, twtsWriter);
                if (twtsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (twtsWriter != null) {
                        try {
                            twtsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            twtsWriter.close();
        }
        return bl;
    }

    public abstract boolean checkTransformers(Network var1, ValidationConfig var2, ValidationWriter var3);
}

