/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerPhaseAngleClock;
import com.powsybl.iidm.network.util.BranchData;
import com.powsybl.loadflow.validation.ValidationConfig;
import com.powsybl.loadflow.validation.ValidationType;
import com.powsybl.loadflow.validation.ValidationUtils;
import com.powsybl.loadflow.validation.io.ValidationWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlowsValidation {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowsValidation.class);
    public static final FlowsValidation INSTANCE = new FlowsValidation();

    private FlowsValidation() {
    }

    public boolean checkFlows(BranchData branch, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(branch);
            Objects.requireNonNull(branch.getId());
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter flowsWriter = ValidationUtils.createValidationWriter(branch.getId(), config, writer, ValidationType.FLOWS);
            try {
                bl = this.checkFlows(branch, config, flowsWriter);
                if (flowsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (flowsWriter != null) {
                        try {
                            flowsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            flowsWriter.close();
        }
        return bl;
    }

    public boolean checkFlows(BranchData branch, ValidationConfig config, ValidationWriter flowsWriter) {
        Objects.requireNonNull(branch);
        Objects.requireNonNull(branch.getId());
        Objects.requireNonNull(config);
        Objects.requireNonNull(flowsWriter);
        boolean validated = true;
        if (!branch.isConnected1()) {
            validated &= FlowsValidation.checkDisconnectedTerminal(branch.getId(), "1", branch.getP1(), branch.getComputedP1(), branch.getQ1(), branch.getComputedQ1(), config);
        }
        if (!branch.isConnected2()) {
            validated &= FlowsValidation.checkDisconnectedTerminal(branch.getId(), "2", branch.getP2(), branch.getComputedP2(), branch.getQ2(), branch.getComputedQ2(), config);
        }
        if (branch.isConnected1() && ValidationUtils.isMainComponent(config, branch.isMainComponent1())) {
            validated &= FlowsValidation.checkConnectedTerminal(branch.getId(), "1", branch.getP1(), branch.getComputedP1(), branch.getQ1(), branch.getComputedQ1(), config);
        }
        if (branch.isConnected2() && ValidationUtils.isMainComponent(config, branch.isMainComponent2())) {
            validated &= FlowsValidation.checkConnectedTerminal(branch.getId(), "2", branch.getP2(), branch.getComputedP2(), branch.getQ2(), branch.getComputedQ2(), config);
        }
        try {
            flowsWriter.write(branch.getId(), branch.getP1(), branch.getComputedP1(), branch.getQ1(), branch.getComputedQ1(), branch.getP2(), branch.getComputedP2(), branch.getQ2(), branch.getComputedQ2(), branch.getR(), branch.getX(), branch.getG1(), branch.getG2(), branch.getB1(), branch.getB2(), branch.getRho1(), branch.getRho2(), branch.getAlpha1(), branch.getAlpha2(), branch.getU1(), branch.getU2(), branch.getTheta1(), branch.getTheta2(), branch.getZ(), branch.getY(), branch.getKsi(), branch.getPhaseAngleClock(), branch.isConnected1(), branch.isConnected2(), branch.isMainComponent1(), branch.isMainComponent2(), validated);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return validated;
    }

    private static boolean checkDisconnectedTerminal(String id, String terminalNumber, double p, double pCalc, double q, double qCalc, ValidationConfig config) {
        boolean validated = true;
        if (!Double.isNaN(p) && Math.abs(p) > config.getThreshold()) {
            LOGGER.warn("{} {}: {} disconnected P{} {} {}", new Object[]{ValidationType.FLOWS, "validation error", id, terminalNumber, p, pCalc});
            validated = false;
        }
        if (!Double.isNaN(q) && Math.abs(q) > config.getThreshold()) {
            LOGGER.warn("{} {}: {} disconnected Q{} {} {}", new Object[]{ValidationType.FLOWS, "validation error", id, terminalNumber, q, qCalc});
            validated = false;
        }
        return validated;
    }

    private static boolean checkConnectedTerminal(String id, String terminalNumber, double p, double pCalc, double q, double qCalc, ValidationConfig config) {
        boolean validated = true;
        if (ValidationUtils.areNaN(config, pCalc) || Math.abs(p - pCalc) > config.getThreshold()) {
            LOGGER.warn("{} {}: {} P{} {} {}", new Object[]{ValidationType.FLOWS, "validation error", id, terminalNumber, p, pCalc});
            validated = false;
        }
        if (ValidationUtils.areNaN(config, qCalc) || Math.abs(q - qCalc) > config.getThreshold()) {
            LOGGER.warn("{} {}: {} Q{} {} {}", new Object[]{ValidationType.FLOWS, "validation error", id, terminalNumber, q, qCalc});
            validated = false;
        }
        return validated;
    }

    public boolean checkFlows(Line l, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(l);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter flowsWriter = ValidationUtils.createValidationWriter(l.getId(), config, writer, ValidationType.FLOWS);
            try {
                bl = this.checkFlows(l, config, flowsWriter);
                if (flowsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (flowsWriter != null) {
                        try {
                            flowsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            flowsWriter.close();
        }
        return bl;
    }

    public boolean checkFlows(Line l, ValidationConfig config, ValidationWriter flowsWriter) {
        Objects.requireNonNull(l);
        Objects.requireNonNull(config);
        Objects.requireNonNull(flowsWriter);
        BranchData branch = new BranchData(l, config.getEpsilonX(), config.applyReactanceCorrection());
        return this.checkFlows(branch, config, flowsWriter);
    }

    public boolean checkFlows(TwoWindingsTransformer twt, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(twt);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter flowsWriter = ValidationUtils.createValidationWriter(twt.getId(), config, writer, ValidationType.FLOWS);
            try {
                bl = this.checkFlows(twt, config, flowsWriter);
                if (flowsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (flowsWriter != null) {
                        try {
                            flowsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            flowsWriter.close();
        }
        return bl;
    }

    public boolean checkFlows(TwoWindingsTransformer twt, ValidationConfig config, ValidationWriter flowsWriter) {
        Objects.requireNonNull(twt);
        Objects.requireNonNull(config);
        Objects.requireNonNull(flowsWriter);
        int phaseAngleClock = 0;
        TwoWindingsTransformerPhaseAngleClock phaseAngleClockExtension = (TwoWindingsTransformerPhaseAngleClock)twt.getExtension(TwoWindingsTransformerPhaseAngleClock.class);
        if (phaseAngleClockExtension != null) {
            phaseAngleClock = phaseAngleClockExtension.getPhaseAngleClock();
        }
        BranchData branch = new BranchData(twt, phaseAngleClock, config.getEpsilonX(), config.applyReactanceCorrection(), config.getLoadFlowParameters().isTwtSplitShuntAdmittance());
        return this.checkFlows(branch, config, flowsWriter);
    }

    public boolean checkFlows(TieLine tl, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(tl);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter flowsWriter = ValidationUtils.createValidationWriter(tl.getId(), config, writer, ValidationType.FLOWS);
            try {
                bl = this.checkFlows(tl, config, flowsWriter);
                if (flowsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (flowsWriter != null) {
                        try {
                            flowsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            flowsWriter.close();
        }
        return bl;
    }

    public boolean checkFlows(TieLine tl, ValidationConfig config, ValidationWriter flowsWriter) {
        Objects.requireNonNull(tl);
        Objects.requireNonNull(config);
        Objects.requireNonNull(flowsWriter);
        BranchData branch = new BranchData(tl, config.getEpsilonX(), config.applyReactanceCorrection());
        return this.checkFlows(branch, config, flowsWriter);
    }

    public boolean checkFlows(Network network, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(network);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter flowsWriter = ValidationUtils.createValidationWriter(network.getId(), config, writer, ValidationType.FLOWS);
            try {
                bl = this.checkFlows(network, config, flowsWriter);
                if (flowsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (flowsWriter != null) {
                        try {
                            flowsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            flowsWriter.close();
        }
        return bl;
    }

    public boolean checkFlows(Network network, ValidationConfig config, Path file) throws IOException {
        Objects.requireNonNull(network);
        Objects.requireNonNull(config);
        Objects.requireNonNull(file);
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            boolean bl = this.checkFlows(network, config, (Writer)writer);
            return bl;
        }
    }

    public boolean checkFlows(Network network, ValidationConfig config, ValidationWriter flowsWriter) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(config);
        Objects.requireNonNull(flowsWriter);
        LOGGER.info("Checking flows of network {}", (Object)network.getId());
        boolean linesValidated = network.getLineStream().sorted(Comparator.comparing(Identifiable::getId)).map(l -> this.checkFlows((Line)l, config, flowsWriter)).reduce(Boolean::logicalAnd).orElse(true);
        boolean transformersValidated = network.getTwoWindingsTransformerStream().sorted(Comparator.comparing(Identifiable::getId)).map(t -> this.checkFlows((TwoWindingsTransformer)t, config, flowsWriter)).reduce(Boolean::logicalAnd).orElse(true);
        boolean tieLinesValidated = network.getTieLineStream().sorted(Comparator.comparing(Identifiable::getId)).map(tl -> this.checkFlows((TieLine)tl, config, flowsWriter)).reduce(Boolean::logicalAnd).orElse(true);
        return linesValidated && transformersValidated && tieLinesValidated;
    }
}

