/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.LoadFlow;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.loadflow.validation.CandidateComputation;
import com.powsybl.loadflow.validation.ValidationConfig;
import java.util.Objects;

@AutoService(value={CandidateComputation.class})
public class LoadFlowComputation
implements CandidateComputation {
    @Override
    public String getName() {
        return "loadflow";
    }

    @Override
    public void run(Network network, ComputationManager computationManager) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(computationManager);
        LoadFlowParameters parameters = LoadFlowParameters.load();
        String loadFlowName = ValidationConfig.load().getLoadFlowName().orElse(null);
        LoadFlowResult result = LoadFlow.find((String)loadFlowName).run(network, "InitialState", computationManager, parameters);
        if (!result.isOk()) {
            throw new PowsyblException("Loadflow on network " + network.getId() + " does not converge");
        }
    }
}

