/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.validation.BusesValidation;
import com.powsybl.loadflow.validation.FlowsValidation;
import com.powsybl.loadflow.validation.GeneratorsValidation;
import com.powsybl.loadflow.validation.ShuntCompensatorsValidation;
import com.powsybl.loadflow.validation.StaticVarCompensatorsValidation;
import com.powsybl.loadflow.validation.Transformers3WValidation;
import com.powsybl.loadflow.validation.TransformersValidation;
import com.powsybl.loadflow.validation.ValidationConfig;
import com.powsybl.loadflow.validation.io.ValidationWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;

public enum ValidationType {
    FLOWS("branches_flows.csv"),
    GENERATORS("generators.csv"),
    BUSES("buses.csv"),
    SVCS("svcs.csv"),
    SHUNTS("shunts.csv"),
    TWTS("twt.csv"),
    TWTS3W("twt3w.csv");

    private final String file;
    private static final String UNEXPECTED_VALIDATION_TYPE_VALUE = "Unexpected ValidationType value: ";

    private ValidationType(String file) {
        this.file = Objects.requireNonNull(file);
    }

    public boolean check(Network network, ValidationConfig config, Path folder) throws IOException {
        Objects.requireNonNull(network);
        Objects.requireNonNull(config);
        Objects.requireNonNull(folder);
        switch (this) {
            case FLOWS: {
                return FlowsValidation.INSTANCE.checkFlows(network, config, folder.resolve(this.file));
            }
            case GENERATORS: {
                return GeneratorsValidation.INSTANCE.checkGenerators(network, config, folder.resolve(this.file));
            }
            case BUSES: {
                return BusesValidation.INSTANCE.checkBuses(network, config, folder.resolve(this.file));
            }
            case SVCS: {
                return StaticVarCompensatorsValidation.INSTANCE.checkSVCs(network, config, folder.resolve(this.file));
            }
            case SHUNTS: {
                return ShuntCompensatorsValidation.INSTANCE.checkShunts(network, config, folder.resolve(this.file));
            }
            case TWTS: {
                return TransformersValidation.INSTANCE.checkTransformers(network, config, folder.resolve(this.file));
            }
            case TWTS3W: {
                return Transformers3WValidation.INSTANCE.checkTransformers(network, config, folder.resolve(this.file));
            }
        }
        throw new IllegalStateException(UNEXPECTED_VALIDATION_TYPE_VALUE + this);
    }

    public boolean check(Network network, ValidationConfig config, ValidationWriter validationWriter) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(config);
        Objects.requireNonNull(validationWriter);
        switch (this) {
            case FLOWS: {
                return FlowsValidation.INSTANCE.checkFlows(network, config, validationWriter);
            }
            case GENERATORS: {
                return GeneratorsValidation.INSTANCE.checkGenerators(network, config, validationWriter);
            }
            case BUSES: {
                return BusesValidation.INSTANCE.checkBuses(network, config, validationWriter);
            }
            case SVCS: {
                return StaticVarCompensatorsValidation.INSTANCE.checkSVCs(network, config, validationWriter);
            }
            case SHUNTS: {
                return ShuntCompensatorsValidation.INSTANCE.checkShunts(network, config, validationWriter);
            }
            case TWTS: {
                return TransformersValidation.INSTANCE.checkTransformers(network, config, validationWriter);
            }
            case TWTS3W: {
                return Transformers3WValidation.INSTANCE.checkTransformers(network, config, validationWriter);
            }
        }
        throw new IllegalStateException(UNEXPECTED_VALIDATION_TYPE_VALUE + this);
    }

    public Path getOutputFile(Path folder) {
        return folder.resolve(this.file);
    }
}

