/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.powsybl.loadflow.validation.CandidateComputation;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public final class CandidateComputations {
    private static final Supplier<List<CandidateComputation>> COMPUTATIONS = Suppliers.memoize(() -> ImmutableList.copyOf(ServiceLoader.load(CandidateComputation.class, CandidateComputations.class.getClassLoader())));

    private CandidateComputations() {
    }

    public static List<CandidateComputation> getComputations() {
        return COMPUTATIONS.get();
    }

    public static List<String> getComputationsNames() {
        return CandidateComputations.getComputations().stream().map(CandidateComputation::getName).toList();
    }

    public static Optional<CandidateComputation> getComputation(String name) {
        return CandidateComputations.getComputations().stream().filter(c -> c.getName().equals(name)).findFirst();
    }
}

