/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorLinearModel;
import com.powsybl.iidm.network.ShuntCompensatorModelType;
import com.powsybl.loadflow.validation.ValidationConfig;
import com.powsybl.loadflow.validation.ValidationType;
import com.powsybl.loadflow.validation.ValidationUtils;
import com.powsybl.loadflow.validation.io.ValidationWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShuntCompensatorsValidation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShuntCompensatorsValidation.class);
    public static final ShuntCompensatorsValidation INSTANCE = new ShuntCompensatorsValidation();

    private ShuntCompensatorsValidation() {
    }

    public boolean checkShunts(Network network, ValidationConfig config, Path file) throws IOException {
        Objects.requireNonNull(file);
        Objects.requireNonNull(config);
        Objects.requireNonNull(file);
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            boolean bl = this.checkShunts(network, config, (Writer)writer);
            return bl;
        }
    }

    public boolean checkShunts(Network network, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(network);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter shuntsWriter = ValidationUtils.createValidationWriter(network.getId(), config, writer, ValidationType.SHUNTS);
            try {
                bl = this.checkShunts(network, config, shuntsWriter);
                if (shuntsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (shuntsWriter != null) {
                        try {
                            shuntsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            shuntsWriter.close();
        }
        return bl;
    }

    public boolean checkShunts(Network network, ValidationConfig config, ValidationWriter shuntsWriter) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(config);
        Objects.requireNonNull(shuntsWriter);
        LOGGER.info("Checking shunt compensators of network {}", (Object)network.getId());
        return network.getShuntCompensatorStream().sorted(Comparator.comparing(Identifiable::getId)).map(shunt -> this.checkShunts((ShuntCompensator)shunt, config, shuntsWriter)).reduce(Boolean::logicalAnd).orElse(true);
    }

    public boolean checkShunts(ShuntCompensator shunt, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(shunt);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter shuntsWriter = ValidationUtils.createValidationWriter(shunt.getId(), config, writer, ValidationType.SHUNTS);
            try {
                bl = this.checkShunts(shunt, config, shuntsWriter);
                if (shuntsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (shuntsWriter != null) {
                        try {
                            shuntsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            shuntsWriter.close();
        }
        return bl;
    }

    public boolean checkShunts(ShuntCompensator shunt, ValidationConfig config, ValidationWriter shuntsWriter) {
        Objects.requireNonNull(shunt);
        Objects.requireNonNull(config);
        Objects.requireNonNull(shuntsWriter);
        if (shunt.getModelType() == ShuntCompensatorModelType.NON_LINEAR) {
            throw new PowsyblException("non linear shunt not supported yet");
        }
        double p = shunt.getTerminal().getP();
        double q = shunt.getTerminal().getQ();
        int currentSectionCount = shunt.getSectionCount();
        int maximumSectionCount = shunt.getMaximumSectionCount();
        double bPerSection = ((ShuntCompensatorLinearModel)shunt.getModel(ShuntCompensatorLinearModel.class)).getBPerSection();
        double nominalV = shunt.getTerminal().getVoltageLevel().getNominalV();
        double qMax = bPerSection * (double)maximumSectionCount * nominalV * nominalV;
        Bus bus = shunt.getTerminal().getBusView().getBus();
        double v = bus != null ? bus.getV() : Double.NaN;
        boolean connected = bus != null;
        Bus connectableBus = shunt.getTerminal().getBusView().getConnectableBus();
        boolean connectableMainComponent = connectableBus != null && connectableBus.isInMainConnectedComponent();
        boolean mainComponent = bus != null ? bus.isInMainConnectedComponent() : connectableMainComponent;
        return this.checkShunts(shunt.getId(), p, q, currentSectionCount, maximumSectionCount, bPerSection, v, qMax, nominalV, connected, mainComponent, config, shuntsWriter);
    }

    public boolean checkShunts(String id, double p, double q, int currentSectionCount, int maximumSectionCount, double bPerSection, double v, double qMax, double nominalV, boolean connected, boolean mainComponent, ValidationConfig config, Writer writer) {
        boolean bl;
        block8: {
            Objects.requireNonNull(id);
            Objects.requireNonNull(config);
            Objects.requireNonNull(writer);
            ValidationWriter shuntsWriter = ValidationUtils.createValidationWriter(id, config, writer, ValidationType.SHUNTS);
            try {
                bl = this.checkShunts(id, p, q, currentSectionCount, maximumSectionCount, bPerSection, v, qMax, nominalV, connected, mainComponent, config, shuntsWriter);
                if (shuntsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (shuntsWriter != null) {
                        try {
                            shuntsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            shuntsWriter.close();
        }
        return bl;
    }

    public boolean checkShunts(String id, double p, double q, int currentSectionCount, int maximumSectionCount, double bPerSection, double v, double qMax, double nominalV, boolean connected, boolean mainComponent, ValidationConfig config, ValidationWriter shuntsWriter) {
        boolean validated = true;
        if (!connected && !Double.isNaN(q) && q != 0.0) {
            LOGGER.warn("{} {}: {}: disconnected shunt Q {}", new Object[]{ValidationType.SHUNTS, "validation error", id, q});
            validated = false;
        }
        double expectedQ = -bPerSection * (double)currentSectionCount * v * v;
        if (connected && ValidationUtils.isMainComponent(config, mainComponent)) {
            if (!Double.isNaN(p)) {
                LOGGER.warn("{} {}: {}: P={}", new Object[]{ValidationType.SHUNTS, "validation error", id, p});
                validated = false;
            }
            if (ValidationUtils.areNaN(config, q, expectedQ) || Math.abs(q - expectedQ) > config.getThreshold()) {
                LOGGER.warn("{} {}: {}:  Q {} {}", new Object[]{ValidationType.SHUNTS, "validation error", id, q, expectedQ});
                validated = false;
            }
        }
        try {
            shuntsWriter.write(id, q, expectedQ, p, currentSectionCount, maximumSectionCount, bPerSection, v, connected, qMax, nominalV, mainComponent, validated);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return validated;
    }
}

