/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation.io;

import com.powsybl.commons.io.table.Column;
import com.powsybl.commons.io.table.TableFormatter;
import com.powsybl.commons.io.table.TableFormatterConfig;
import com.powsybl.commons.io.table.TableFormatterFactory;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.util.TwtData;
import com.powsybl.loadflow.validation.ValidationType;
import com.powsybl.loadflow.validation.io.AbstractValidationFormatterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

public class ValidationFormatterCsvWriter
extends AbstractValidationFormatterWriter {
    private final boolean verbose;

    public ValidationFormatterCsvWriter(String id, Class<? extends TableFormatterFactory> formatterFactoryClass, TableFormatterConfig formatterConfig, Writer writer, boolean verbose, ValidationType validationType, boolean compareResults) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(formatterFactoryClass);
        Objects.requireNonNull(writer);
        this.verbose = verbose;
        this.validationType = Objects.requireNonNull(validationType);
        this.compareResults = compareResults;
        this.formatter = this.createTableFormatter(id, formatterFactoryClass, formatterConfig, writer, validationType);
        this.invalidString = formatterConfig.getInvalidString();
    }

    public ValidationFormatterCsvWriter(String id, Class<? extends TableFormatterFactory> formatterFactoryClass, Writer writer, boolean verbose, ValidationType validationType, boolean compareResults) {
        this(id, formatterFactoryClass, TableFormatterConfig.load(), writer, verbose, validationType, compareResults);
    }

    @Override
    protected Column[] getColumns() {
        switch (this.validationType) {
            case FLOWS: {
                return this.getFlowColumns();
            }
            case GENERATORS: {
                return this.getGeneratorColumns();
            }
            case BUSES: {
                return this.getBusColumns();
            }
            case SVCS: {
                return this.getSvcColumns();
            }
            case SHUNTS: {
                return this.getShuntColumns();
            }
            case TWTS: {
                return this.getTwtColumns();
            }
            case TWTS3W: {
                return this.getTwt3wColumns();
            }
        }
        throw new IllegalStateException("Unexpected ValidationType value: " + this.validationType);
    }

    private Column[] getFlowColumns() {
        Object[] flowColumns = new Column[]{new Column("id"), new Column("network_p1"), new Column("expected_p1"), new Column("network_q1"), new Column("expected_q1"), new Column("network_p2"), new Column("expected_p2"), new Column("network_q2"), new Column("expected_q2")};
        if (this.verbose) {
            flowColumns = (Column[])ArrayUtils.addAll((Object[])flowColumns, (Object[])new Column[]{new Column("r"), new Column("x"), new Column("g1"), new Column("g2"), new Column("b1"), new Column("b2"), new Column("rho1"), new Column("rho2"), new Column("alpha1"), new Column("alpha2"), new Column("u1"), new Column("u2"), new Column("theta1"), new Column("theta2"), new Column("z"), new Column("y"), new Column("ksi"), new Column("phaseAngleClock"), new Column("connected1"), new Column("connected2"), new Column("mainComponent1"), new Column("mainComponent2"), new Column("validation")});
        }
        if (this.compareResults) {
            flowColumns = (Column[])ArrayUtils.addAll((Object[])flowColumns, (Object[])new Column[]{new Column("network_p1_postComp"), new Column("expected_p1_postComp"), new Column("network_q1_postComp"), new Column("expected_q1_postComp"), new Column("network_p2_postComp"), new Column("expected_p2_postComp"), new Column("network_q2_postComp"), new Column("expected_q2_postComp")});
            if (this.verbose) {
                flowColumns = (Column[])ArrayUtils.addAll((Object[])flowColumns, (Object[])new Column[]{new Column("r_postComp"), new Column("x_postComp"), new Column("g1_postComp"), new Column("g2_postComp"), new Column("b1_postComp"), new Column("b2_postComp"), new Column("rho1_postComp"), new Column("rho2_postComp"), new Column("alpha1_postComp"), new Column("alpha2_postComp"), new Column("u1_postComp"), new Column("u2_postComp"), new Column("theta1_postComp"), new Column("theta2_postComp"), new Column("z_postComp"), new Column("y_postComp"), new Column("ksi_postComp"), new Column("phaseAngleClock_postComp"), new Column("connected1_postComp"), new Column("connected2_postComp"), new Column("mainComponent1_postComp"), new Column("mainComponent2_postComp"), new Column("validation_postComp")});
            }
        }
        return flowColumns;
    }

    private Column[] getGeneratorColumns() {
        Object[] generatorColumns = new Column[]{new Column("id"), new Column("p"), new Column("q"), new Column("v"), new Column("targetP"), new Column("targetQ"), new Column("targetV"), new Column("expectedP")};
        if (this.verbose) {
            generatorColumns = (Column[])ArrayUtils.addAll((Object[])generatorColumns, (Object[])new Column[]{new Column("connected"), new Column("voltageRegulatorOn"), new Column("minP"), new Column("maxP"), new Column("minQ"), new Column("maxQ"), new Column("mainComponent"), new Column("validation")});
        }
        if (this.compareResults) {
            generatorColumns = (Column[])ArrayUtils.addAll((Object[])generatorColumns, (Object[])new Column[]{new Column("p_postComp"), new Column("q_postComp"), new Column("v_postComp"), new Column("targetP_postComp"), new Column("targetQ_postComp"), new Column("targetV_postComp"), new Column("expectedP_postComp")});
            if (this.verbose) {
                generatorColumns = (Column[])ArrayUtils.addAll((Object[])generatorColumns, (Object[])new Column[]{new Column("connected_postComp"), new Column("voltageRegulatorOn_postComp"), new Column("minP_postComp"), new Column("maxP_postComp"), new Column("minQ_postComp"), new Column("maxQ_postComp"), new Column("mainComponent_postComp"), new Column("validation_postComp")});
            }
        }
        return generatorColumns;
    }

    private Column[] getBusColumns() {
        Object[] busColumns = new Column[]{new Column("id"), new Column("incomingP"), new Column("incomingQ"), new Column("loadP"), new Column("loadQ")};
        if (this.verbose) {
            busColumns = (Column[])ArrayUtils.addAll((Object[])busColumns, (Object[])new Column[]{new Column("genP"), new Column("genQ"), new Column("shuntP"), new Column("shuntQ"), new Column("svcP"), new Column("svcQ"), new Column("vscCSP"), new Column("vscCSQ"), new Column("lineP"), new Column("lineQ"), new Column("danglingLineP"), new Column("danglingLineQ"), new Column("twtP"), new Column("twtQ"), new Column("tltP"), new Column("tltQ"), new Column("mainComponent"), new Column("validation")});
        }
        if (this.compareResults) {
            busColumns = (Column[])ArrayUtils.addAll((Object[])busColumns, (Object[])new Column[]{new Column("incomingP_postComp"), new Column("incomingQ_postComp"), new Column("loadP_postComp"), new Column("loadQ_postComp")});
            if (this.verbose) {
                busColumns = (Column[])ArrayUtils.addAll((Object[])busColumns, (Object[])new Column[]{new Column("genP_postComp"), new Column("genQ_postComp"), new Column("shuntP_postComp"), new Column("shuntQ_postComp"), new Column("svcP_postComp"), new Column("svcQ_postComp"), new Column("vscCSP_postComp"), new Column("vscCSQ_postComp"), new Column("lineP_postComp"), new Column("lineQ_postComp"), new Column("danglingLineP_postComp"), new Column("danglingLineQ_postComp"), new Column("twtP_postComp"), new Column("twtQ_postComp"), new Column("tltP_postComp"), new Column("tltQ_postComp"), new Column("mainComponent_postComp"), new Column("validation_postComp")});
            }
        }
        return busColumns;
    }

    private Column[] getSvcColumns() {
        Object[] svcColumns = new Column[]{new Column("id"), new Column("p"), new Column("q"), new Column("vControlled"), new Column("vController"), new Column("nominalV"), new Column("reactivePowerSetpoint"), new Column("voltageSetpoint")};
        if (this.verbose) {
            svcColumns = (Column[])ArrayUtils.addAll((Object[])svcColumns, (Object[])new Column[]{new Column("connected"), new Column("regulationMode"), new Column("bMin"), new Column("bMax"), new Column("mainComponent"), new Column("validation")});
        }
        if (this.compareResults) {
            svcColumns = (Column[])ArrayUtils.addAll((Object[])svcColumns, (Object[])new Column[]{new Column("p_postComp"), new Column("q_postComp"), new Column("vControlled_postComp"), new Column("vController_postComp"), new Column("nominalV_postComp"), new Column("reactivePowerSetpoint_postComp"), new Column("voltageSetpoint_postComp")});
            if (this.verbose) {
                svcColumns = (Column[])ArrayUtils.addAll((Object[])svcColumns, (Object[])new Column[]{new Column("connected_postComp"), new Column("regulationMode_postComp"), new Column("bMin_postComp"), new Column("bMax_postComp"), new Column("mainComponent_postComp"), new Column("validation_postComp")});
            }
        }
        return svcColumns;
    }

    private Column[] getShuntColumns() {
        Object[] shuntColumns = new Column[]{new Column("id"), new Column("q"), new Column("expectedQ")};
        if (this.verbose) {
            shuntColumns = (Column[])ArrayUtils.addAll((Object[])shuntColumns, (Object[])new Column[]{new Column("p"), new Column("currentSectionCount"), new Column("maximumSectionCount"), new Column("bPerSection"), new Column("v"), new Column("connected"), new Column("qMax"), new Column("nominalV"), new Column("mainComponent"), new Column("validation")});
        }
        if (this.compareResults) {
            shuntColumns = (Column[])ArrayUtils.addAll((Object[])shuntColumns, (Object[])new Column[]{new Column("q_postComp"), new Column("expectedQ_postComp")});
            if (this.verbose) {
                shuntColumns = (Column[])ArrayUtils.addAll((Object[])shuntColumns, (Object[])new Column[]{new Column("p_postComp"), new Column("currentSectionCount_postComp"), new Column("maximumSectionCount_postComp"), new Column("bPerSection_postComp"), new Column("v_postComp"), new Column("connected_postComp"), new Column("qMax_postComp"), new Column("nominalV_postComp"), new Column("mainComponent_postComp"), new Column("validation_postComp")});
            }
        }
        return shuntColumns;
    }

    private Column[] getTwtColumns() {
        Object[] twtColumns = new Column[]{new Column("id"), new Column("error"), new Column("upIncrement"), new Column("downIncrement")};
        if (this.verbose) {
            twtColumns = (Column[])ArrayUtils.addAll((Object[])twtColumns, (Object[])new Column[]{new Column("rho"), new Column("rhoPreviousStep"), new Column("rhoNextStep"), new Column("tapPosition"), new Column("lowTapPosition"), new Column("highTapPosition"), new Column("tapChangerTargetV"), new Column("regulatedSide"), new Column("v"), new Column("connected"), new Column("mainComponent"), new Column("validation")});
        }
        if (this.compareResults) {
            twtColumns = (Column[])ArrayUtils.addAll((Object[])twtColumns, (Object[])new Column[]{new Column("error_postComp"), new Column("upIncrement_postComp"), new Column("downIncrement_postComp")});
            if (this.verbose) {
                twtColumns = (Column[])ArrayUtils.addAll((Object[])twtColumns, (Object[])new Column[]{new Column("rho_postComp"), new Column("rhoPreviousStep_postComp"), new Column("rhoNextStep_postComp"), new Column("tapPosition_postComp"), new Column("lowTapPosition_postComp"), new Column("highTapPosition_postComp"), new Column("tapChangerTargetV_postComp"), new Column("regulatedSide_postComp"), new Column("v_postComp"), new Column("connected_postComp"), new Column("mainComponent_postComp"), new Column("validation_postComp")});
            }
        }
        return twtColumns;
    }

    private Column[] getTwt3wColumns() {
        Object[] twt3wColumns = new Column[]{new Column("id"), new Column("network_p1"), new Column("expected_p1"), new Column("network_q1"), new Column("expected_q1"), new Column("network_p2"), new Column("expected_p2"), new Column("network_q2"), new Column("expected_q2"), new Column("network_p3"), new Column("expected_p3"), new Column("network_q3"), new Column("expected_q3")};
        if (this.verbose) {
            twt3wColumns = (Column[])ArrayUtils.addAll((Object[])twt3wColumns, (Object[])new Column[]{new Column("u1"), new Column("u2"), new Column("u3"), new Column("starU"), new Column("theta1"), new Column("theta2"), new Column("theta3"), new Column("starTheta"), new Column("g11"), new Column("b11"), new Column("g12"), new Column("b12"), new Column("g21"), new Column("b21"), new Column("g22"), new Column("b22"), new Column("g31"), new Column("b31"), new Column("g32"), new Column("b32"), new Column("r1"), new Column("r2"), new Column("r3"), new Column("x1"), new Column("x2"), new Column("x3"), new Column("ratedU1"), new Column("ratedU2"), new Column("ratedU3"), new Column("phaseAngleClock2"), new Column("phaseAngleClock3"), new Column("ratedU0"), new Column("connected1"), new Column("connected2"), new Column("connected3"), new Column("mainComponent1"), new Column("mainComponent2"), new Column("mainComponent3"), new Column("validation")});
        }
        if (this.compareResults) {
            twt3wColumns = (Column[])ArrayUtils.addAll((Object[])twt3wColumns, (Object[])new Column[]{new Column("network_p1_postComp"), new Column("expected_p1_postComp"), new Column("network_q1_postComp"), new Column("expected_q1_postComp"), new Column("network_p2_postComp"), new Column("expected_p2_postComp"), new Column("network_q2_postComp"), new Column("expected_q2_postComp"), new Column("network_p3_postComp"), new Column("expected_p3_postComp"), new Column("network_q3_postComp"), new Column("expected_q3_postComp")});
            if (this.verbose) {
                twt3wColumns = (Column[])ArrayUtils.addAll((Object[])twt3wColumns, (Object[])new Column[]{new Column("u1_postComp"), new Column("u2_postComp"), new Column("u3_postComp"), new Column("starU_postComp"), new Column("theta1_postComp"), new Column("theta2_postComp"), new Column("theta3_postComp"), new Column("starTheta_postComp"), new Column("g11_postComp"), new Column("b11_postComp"), new Column("g12_postComp"), new Column("b12_postComp"), new Column("g21_postComp"), new Column("b21_postComp"), new Column("g22_postComp"), new Column("b22_postComp"), new Column("g31_postComp"), new Column("b31_postComp"), new Column("g32_postComp"), new Column("b32_postComp"), new Column("r1_postComp"), new Column("r2_postComp"), new Column("r3_postComp"), new Column("x1_postComp"), new Column("x2_postComp"), new Column("x3_postComp"), new Column("ratedU1_postComp"), new Column("ratedU2_postComp"), new Column("ratedU3_postComp"), new Column("phaseAngleClock2_postComp"), new Column("phaseAngleClock3_postComp"), new Column("ratedU0_postComp"), new Column("connected1_postComp"), new Column("connected2_postComp"), new Column("connected3_postComp"), new Column("mainComponent1_postComp"), new Column("mainComponent2_postComp"), new Column("mainComponent3_postComp"), new Column("validation_postComp")});
            }
        }
        return twt3wColumns;
    }

    @Override
    protected void write(String branchId, double p1, double p1Calc, double q1, double q1Calc, double p2, double p2Calc, double q2, double q2Calc, double r, double x, double g1, double g2, double b1, double b2, double rho1, double rho2, double alpha1, double alpha2, double u1, double u2, double theta1, double theta2, double z, double y, double ksi, int phaseAngleClock, boolean connected1, boolean connected2, boolean mainComponent1, boolean mainComponent2, boolean validated, AbstractValidationFormatterWriter.FlowData flowData, boolean found, boolean writeValues) throws IOException {
        this.formatter.writeCell(branchId);
        if (this.compareResults) {
            this.formatter = found ? this.write(found, flowData.p1, flowData.p1Calc, flowData.q1, flowData.q1Calc, flowData.p2, flowData.p2Calc, flowData.q2, flowData.q2Calc, flowData.r, flowData.x, flowData.g1, flowData.g2, flowData.b1, flowData.b2, flowData.rho1, flowData.rho2, flowData.alpha1, flowData.alpha2, flowData.u1, flowData.u2, flowData.theta1, flowData.theta2, flowData.z, flowData.y, flowData.ksi, flowData.phaseAngleClock, flowData.connected1, flowData.connected2, flowData.mainComponent1, flowData.mainComponent2, flowData.validated) : this.write(found, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, 0, false, false, false, false, false);
        }
        this.formatter = this.write(writeValues, p1, p1Calc, q1, q1Calc, p2, p2Calc, q2, q2Calc, r, x, g1, g2, b1, b2, rho1, rho2, alpha1, alpha2, u1, u2, theta1, theta2, z, y, ksi, phaseAngleClock, connected1, connected2, mainComponent1, mainComponent2, validated);
    }

    private TableFormatter write(boolean writeValues, double p1, double p1Calc, double q1, double q1Calc, double p2, double p2Calc, double q2, double q2Calc, double r, double x, double g1, double g2, double b1, double b2, double rho1, double rho2, double alpha1, double alpha2, double u1, double u2, double theta1, double theta2, double z, double y, double ksi, int phaseAngleClock, boolean connected1, boolean connected2, boolean mainComponent1, boolean mainComponent2, boolean validated) throws IOException {
        TableFormatter tableFormatter = this.formatter = writeValues ? this.formatter.writeCell(p1).writeCell(p1Calc).writeCell(q1).writeCell(q1Calc).writeCell(p2).writeCell(p2Calc).writeCell(q2).writeCell(q2Calc) : this.formatter.writeEmptyCells(8);
        if (this.verbose) {
            this.formatter = writeValues ? this.formatter.writeCell(r).writeCell(x).writeCell(g1).writeCell(g2).writeCell(b1).writeCell(b2).writeCell(rho1).writeCell(rho2).writeCell(alpha1).writeCell(alpha2).writeCell(u1).writeCell(u2).writeCell(theta1).writeCell(theta2).writeCell(z).writeCell(y).writeCell(ksi).writeCell(phaseAngleClock).writeCell(connected1).writeCell(connected2).writeCell(mainComponent1).writeCell(mainComponent2).writeCell(this.getValidated(validated)) : this.formatter.writeEmptyCells(23);
        }
        return this.formatter;
    }

    @Override
    protected void write(String generatorId, double p, double q, double v, double targetP, double targetQ, double targetV, double expectedP, boolean connected, boolean voltageRegulatorOn, double minP, double maxP, double minQ, double maxQ, boolean mainComponent, boolean validated, AbstractValidationFormatterWriter.GeneratorData generatorData, boolean found, boolean writeValues) throws IOException {
        this.formatter.writeCell(generatorId);
        if (this.compareResults) {
            this.formatter = found ? this.write(found, generatorData.p, generatorData.q, generatorData.v, generatorData.targetP, generatorData.targetQ, generatorData.targetV, generatorData.expectedP, generatorData.connected, generatorData.voltageRegulatorOn, generatorData.minP, generatorData.maxP, generatorData.minQ, generatorData.maxQ, generatorData.mainComponent, generatorData.validated) : this.write(found, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, false, false, Double.NaN, Double.NaN, Double.NaN, Double.NaN, false, false);
        }
        this.formatter = this.write(writeValues, p, q, v, targetP, targetQ, targetV, expectedP, connected, voltageRegulatorOn, minP, maxP, minQ, maxQ, mainComponent, validated);
    }

    private TableFormatter write(boolean writeValues, double p, double q, double v, double targetP, double targetQ, double targetV, double expectedP, boolean connected, boolean voltageRegulatorOn, double minP, double maxP, double minQ, double maxQ, boolean mainComponent, boolean validated) throws IOException {
        TableFormatter tableFormatter = this.formatter = writeValues ? this.formatter.writeCell(-p).writeCell(-q).writeCell(v).writeCell(targetP).writeCell(targetQ).writeCell(targetV).writeCell(expectedP) : this.formatter.writeEmptyCells(7);
        if (this.verbose) {
            this.formatter = writeValues ? this.formatter.writeCell(connected).writeCell(voltageRegulatorOn).writeCell(minP).writeCell(maxP).writeCell(minQ).writeCell(maxQ).writeCell(mainComponent).writeCell(this.getValidated(validated)) : this.formatter.writeEmptyCells(8);
        }
        return this.formatter;
    }

    private TableFormatter write(boolean writeValues, double incomingP, double incomingQ, double loadP, double loadQ, double genP, double genQ, double shuntP, double shuntQ, double svcP, double svcQ, double vscCSP, double vscCSQ, double lineP, double lineQ, double danglingLineP, double danglingLineQ, double twtP, double twtQ, double tltP, double tltQ, boolean mainComponent, boolean validated) throws IOException {
        TableFormatter tableFormatter = this.formatter = writeValues ? this.formatter.writeCell(incomingP).writeCell(incomingQ).writeCell(loadP).writeCell(loadQ) : this.formatter.writeEmptyCells(4);
        if (this.verbose) {
            this.formatter = writeValues ? this.formatter.writeCell(genP).writeCell(genQ).writeCell(shuntP).writeCell(shuntQ).writeCell(svcP).writeCell(svcQ).writeCell(vscCSP).writeCell(vscCSQ).writeCell(lineP).writeCell(lineQ).writeCell(danglingLineP).writeCell(danglingLineQ).writeCell(twtP).writeCell(twtQ).writeCell(tltP).writeCell(tltQ).writeCell(mainComponent).writeCell(this.getValidated(validated)) : this.formatter.writeEmptyCells(18);
        }
        return this.formatter;
    }

    @Override
    protected void write(String busId, double incomingP, double incomingQ, double loadP, double loadQ, double genP, double genQ, double batP, double batQ, double shuntP, double shuntQ, double svcP, double svcQ, double vscCSP, double vscCSQ, double lineP, double lineQ, double danglingLineP, double danglingLineQ, double twtP, double twtQ, double tltP, double tltQ, boolean mainComponent, boolean validated, AbstractValidationFormatterWriter.BusData busData, boolean found, boolean writeValues) throws IOException {
        this.formatter.writeCell(busId);
        if (this.compareResults) {
            this.formatter = found ? this.write(found, busData.incomingP, busData.incomingQ, busData.loadP, busData.loadQ, busData.genP, busData.genQ, busData.shuntP, busData.shuntQ, busData.svcP, busData.svcQ, busData.vscCSP, busData.vscCSQ, busData.lineP, busData.lineQ, busData.danglingLineP, busData.danglingLineQ, busData.twtP, busData.twtQ, busData.tltP, busData.tltQ, busData.mainComponent, busData.validated) : this.write(found, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, false, false);
        }
        this.formatter = this.write(writeValues, incomingP, incomingQ, loadP, loadQ, genP, genQ, shuntP, shuntQ, svcP, svcQ, vscCSP, vscCSQ, lineP, lineQ, danglingLineP, danglingLineQ, twtP, twtQ, tltP, tltQ, mainComponent, validated);
    }

    @Override
    protected void write(String svcId, double p, double q, double vControlled, double vController, double nominalVcontroller, double reactivePowerSetpoint, double voltageSetpoint, boolean connected, StaticVarCompensator.RegulationMode regulationMode, double bMin, double bMax, boolean mainComponent, boolean validated, AbstractValidationFormatterWriter.SvcData svcData, boolean found, boolean writeValues) throws IOException {
        this.formatter.writeCell(svcId);
        if (this.compareResults) {
            this.formatter = found ? this.write(found, svcData.p, svcData.q, svcData.vControlled, svcData.vController, svcData.nominalVcontroller, svcData.reactivePowerSetpoint, svcData.voltageSetpoint, svcData.connected, svcData.regulationMode, svcData.bMin, svcData.bMax, svcData.mainComponent, svcData.validated) : this.write(found, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, false, null, Double.NaN, Double.NaN, false, false);
        }
        this.formatter = this.write(writeValues, p, q, vControlled, vController, nominalVcontroller, reactivePowerSetpoint, voltageSetpoint, connected, regulationMode, bMin, bMax, mainComponent, validated);
    }

    private TableFormatter write(boolean writeValues, double p, double q, double vControlled, double vController, double nominalVcontroller, double reactivePowerSetpoint, double voltageSetpoint, boolean connected, StaticVarCompensator.RegulationMode regulationMode, double bMin, double bMax, boolean mainComponent, boolean validated) throws IOException {
        TableFormatter tableFormatter = this.formatter = writeValues ? this.formatter.writeCell(-p).writeCell(-q).writeCell(vControlled).writeCell(vController).writeCell(nominalVcontroller).writeCell(reactivePowerSetpoint).writeCell(voltageSetpoint) : this.formatter.writeEmptyCells(7);
        if (this.verbose) {
            this.formatter = writeValues ? this.formatter.writeCell(connected).writeCell(regulationMode.name()).writeCell(bMin).writeCell(bMax).writeCell(mainComponent).writeCell(this.getValidated(validated)) : this.formatter.writeEmptyCells(6);
        }
        return this.formatter;
    }

    @Override
    protected void write(String shuntId, double q, double expectedQ, double p, int currentSectionCount, int maximumSectionCount, double bPerSection, double v, boolean connected, double qMax, double nominalV, boolean mainComponent, boolean validated, AbstractValidationFormatterWriter.ShuntData shuntData, boolean found, boolean writeValues) throws IOException {
        this.formatter.writeCell(shuntId);
        if (this.compareResults) {
            this.formatter = found ? this.write(found, shuntData.q, shuntData.expectedQ, shuntData.p, shuntData.currentSectionCount, shuntData.maximumSectionCount, shuntData.bPerSection, shuntData.v, shuntData.connected, shuntData.qMax, shuntData.nominalV, shuntData.mainComponent, shuntData.validated) : this.write(found, Double.NaN, Double.NaN, Double.NaN, -1, -1, Double.NaN, Double.NaN, false, Double.NaN, Double.NaN, false, false);
        }
        this.write(writeValues, q, expectedQ, p, currentSectionCount, maximumSectionCount, bPerSection, v, connected, qMax, nominalV, mainComponent, validated);
    }

    private TableFormatter write(boolean writeValues, double q, double expectedQ, double p, int currentSectionCount, int maximumSectionCount, double bPerSection, double v, boolean connected, double qMax, double nominalV, boolean mainComponent, boolean validated) throws IOException {
        TableFormatter tableFormatter = this.formatter = writeValues ? this.formatter.writeCell(q).writeCell(expectedQ) : this.formatter.writeEmptyCells(2);
        if (this.verbose) {
            this.formatter = writeValues ? this.formatter.writeCell(p).writeCell(currentSectionCount).writeCell(maximumSectionCount).writeCell(bPerSection).writeCell(v).writeCell(connected).writeCell(qMax).writeCell(nominalV).writeCell(mainComponent).writeCell(this.getValidated(validated)) : this.formatter.writeEmptyCells(10);
        }
        return this.formatter;
    }

    @Override
    protected void write(String twtId, double error, double upIncrement, double downIncrement, double rho, double rhoPreviousStep, double rhoNextStep, int tapPosition, int lowTapPosition, int highTapPosition, double targetV, TwoSides regulatedSide, double v, boolean connected, boolean mainComponent, boolean validated, AbstractValidationFormatterWriter.TransformerData twtData, boolean found, boolean writeValues) throws IOException {
        this.formatter.writeCell(twtId);
        if (this.compareResults) {
            this.formatter = found ? this.write(found, twtData.error, twtData.upIncrement, twtData.downIncrement, twtData.rho, twtData.rhoPreviousStep, twtData.rhoNextStep, twtData.tapPosition, twtData.lowTapPosition, twtData.highTapPosition, twtData.targetV, twtData.regulatedSide, twtData.v, twtData.connected, twtData.mainComponent, twtData.validated) : this.write(found, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, -1, -1, -1, Double.NaN, TwoSides.ONE, Double.NaN, false, false, false);
        }
        this.write(writeValues, error, upIncrement, downIncrement, rho, rhoPreviousStep, rhoNextStep, tapPosition, lowTapPosition, highTapPosition, targetV, regulatedSide, v, connected, mainComponent, validated);
    }

    private TableFormatter write(boolean writeValues, double error, double upIncrement, double downIncrement, double rho, double rhoPreviousStep, double rhoNextStep, int tapPosition, int lowTapPosition, int highTapPosition, double targetV, TwoSides regulatedSide, double v, boolean connected, boolean mainComponent, boolean validated) throws IOException {
        TableFormatter tableFormatter = this.formatter = writeValues ? this.formatter.writeCell(error).writeCell(upIncrement).writeCell(downIncrement) : this.formatter.writeEmptyCells(3);
        if (this.verbose) {
            this.formatter = writeValues ? this.formatter.writeCell(rho).writeCell(rhoPreviousStep).writeCell(rhoNextStep).writeCell(tapPosition).writeCell(lowTapPosition).writeCell(highTapPosition).writeCell(targetV).writeCell(regulatedSide != null ? regulatedSide.name() : this.invalidString).writeCell(v).writeCell(connected).writeCell(mainComponent).writeCell(this.getValidated(validated)) : this.formatter.writeEmptyCells(12);
        }
        return this.formatter;
    }

    @Override
    protected void write(String twtId, AbstractValidationFormatterWriter.Transformer3WData transformer3wData1, AbstractValidationFormatterWriter.Transformer3WData transformer3wData2, boolean found, boolean writeValues) throws IOException {
        this.formatter.writeCell(twtId);
        if (this.compareResults) {
            this.formatter = this.write(found, transformer3wData2.twtData, transformer3wData2.validated);
        }
        this.write(writeValues, transformer3wData1.twtData, transformer3wData1.validated);
    }

    private TableFormatter write(boolean writeValues, TwtData twtData, boolean validated) throws IOException {
        TableFormatter tableFormatter = this.formatter = writeValues ? this.formatter.writeCell(twtData.getP(ThreeSides.ONE)).writeCell(twtData.getComputedP(ThreeSides.ONE)).writeCell(twtData.getQ(ThreeSides.ONE)).writeCell(twtData.getComputedQ(ThreeSides.ONE)).writeCell(twtData.getP(ThreeSides.TWO)).writeCell(twtData.getComputedP(ThreeSides.TWO)).writeCell(twtData.getQ(ThreeSides.TWO)).writeCell(twtData.getComputedQ(ThreeSides.TWO)).writeCell(twtData.getP(ThreeSides.THREE)).writeCell(twtData.getComputedP(ThreeSides.THREE)).writeCell(twtData.getQ(ThreeSides.THREE)).writeCell(twtData.getComputedQ(ThreeSides.THREE)) : this.formatter.writeEmptyCells(12);
        if (this.verbose) {
            this.formatter = writeValues ? this.formatter.writeCell(twtData.getU(ThreeSides.ONE)).writeCell(twtData.getU(ThreeSides.TWO)).writeCell(twtData.getU(ThreeSides.THREE)).writeCell(twtData.getStarU()).writeCell(twtData.getTheta(ThreeSides.ONE)).writeCell(twtData.getTheta(ThreeSides.TWO)).writeCell(twtData.getTheta(ThreeSides.THREE)).writeCell(twtData.getStarTheta()).writeCell(twtData.getG1(ThreeSides.ONE)).writeCell(twtData.getB1(ThreeSides.ONE)).writeCell(twtData.getG2(ThreeSides.ONE)).writeCell(twtData.getB2(ThreeSides.ONE)).writeCell(twtData.getG1(ThreeSides.TWO)).writeCell(twtData.getB1(ThreeSides.TWO)).writeCell(twtData.getG2(ThreeSides.TWO)).writeCell(twtData.getB2(ThreeSides.TWO)).writeCell(twtData.getG1(ThreeSides.THREE)).writeCell(twtData.getB1(ThreeSides.THREE)).writeCell(twtData.getG2(ThreeSides.THREE)).writeCell(twtData.getB2(ThreeSides.THREE)).writeCell(twtData.getR(ThreeSides.ONE)).writeCell(twtData.getR(ThreeSides.TWO)).writeCell(twtData.getR(ThreeSides.THREE)).writeCell(twtData.getX(ThreeSides.ONE)).writeCell(twtData.getX(ThreeSides.TWO)).writeCell(twtData.getX(ThreeSides.THREE)).writeCell(twtData.getRatedU(ThreeSides.ONE)).writeCell(twtData.getRatedU(ThreeSides.TWO)).writeCell(twtData.getRatedU(ThreeSides.THREE)).writeCell(twtData.getPhaseAngleClock2()).writeCell(twtData.getPhaseAngleClock3()).writeCell(twtData.getRatedU0()).writeCell(twtData.isConnected(ThreeSides.ONE)).writeCell(twtData.isConnected(ThreeSides.TWO)).writeCell(twtData.isConnected(ThreeSides.THREE)).writeCell(twtData.isMainComponent(ThreeSides.ONE)).writeCell(twtData.isMainComponent(ThreeSides.TWO)).writeCell(twtData.isMainComponent(ThreeSides.THREE)).writeCell(this.getValidated(validated)) : this.formatter.writeEmptyCells(39);
        }
        return this.formatter;
    }
}

