/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.loadflow.validation.io;

import com.powsybl.loadflow.validation.ValidationConfig;
import com.powsybl.loadflow.validation.ValidationType;
import com.powsybl.loadflow.validation.ValidationUtils;
import com.powsybl.loadflow.validation.io.ValidationWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Set;

public class ValidationWriters
implements AutoCloseable {
    final EnumMap<ValidationType, Writer> writersMap = new EnumMap(ValidationType.class);
    final EnumMap<ValidationType, ValidationWriter> validationWritersMap = new EnumMap(ValidationType.class);

    public ValidationWriters(String networkId, Set<ValidationType> validationTypes, Path folder, ValidationConfig config) {
        validationTypes.forEach(validationType -> {
            try {
                BufferedWriter writer = Files.newBufferedWriter(validationType.getOutputFile(folder), StandardCharsets.UTF_8, new OpenOption[0]);
                this.writersMap.put((ValidationType)((Object)validationType), writer);
                this.validationWritersMap.put((ValidationType)((Object)validationType), ValidationUtils.createValidationWriter(networkId, config, writer, validationType));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public ValidationWriter getWriter(ValidationType validationType) {
        return this.validationWritersMap.get((Object)validationType);
    }

    @Override
    public void close() throws Exception {
        this.validationWritersMap.values().forEach(validationWriter -> {
            try {
                validationWriter.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        this.writersMap.values().forEach(writer -> {
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }
}

