/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.math.graph;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GraphUtil {
    private GraphUtil() {
    }

    private static void computeConnectedComponents(int v1, List<Integer> componentSizes, TIntArrayList[] adjacencyList, int[] componentNumbers) {
        int c = componentSizes.size();
        int componentSize = 0;
        ArrayDeque<Integer> nodes = new ArrayDeque<Integer>();
        nodes.add(v1);
        while (!nodes.isEmpty()) {
            int node = (Integer)nodes.poll();
            if (componentNumbers[node] != -1) continue;
            ++componentSize;
            componentNumbers[node] = c;
            adjacencyList[node].forEach(e -> {
                if (componentNumbers[e] == -1) {
                    nodes.add(e);
                }
                return true;
            });
        }
        componentSizes.add(componentSize);
    }

    public static ConnectedComponentsComputationResult computeConnectedComponents(TIntArrayList[] adjacencyList) {
        int i;
        int[] componentNumber = new int[adjacencyList.length];
        Arrays.fill(componentNumber, -1);
        ArrayList<Integer> componentSizes = new ArrayList<Integer>();
        for (int v = 0; v < adjacencyList.length; ++v) {
            if (componentNumber[v] != -1) continue;
            GraphUtil.computeConnectedComponents(v, componentSizes, adjacencyList, componentNumber);
        }
        int nbComponents = componentSizes.size();
        ConnectedComponent[] components = new ConnectedComponent[nbComponents];
        ConnectedComponent[] orderedComponents = new ConnectedComponent[nbComponents];
        for (i = 0; i < nbComponents; ++i) {
            ConnectedComponent[] comp = new ConnectedComponent((Integer)componentSizes.get(i));
            components[i] = comp;
            orderedComponents[i] = comp;
        }
        Arrays.sort(orderedComponents, (o1, o2) -> o2.size - o1.size);
        for (i = 0; i < orderedComponents.length; ++i) {
            orderedComponents[i].orderedNumber = i;
        }
        int[] orderedComponentSizes = new int[nbComponents];
        for (ConnectedComponent cc : orderedComponents) {
            orderedComponentSizes[cc.orderedNumber] = cc.size;
        }
        for (int i2 = 0; i2 < componentNumber.length; ++i2) {
            ConnectedComponent cc = components[componentNumber[i2]];
            componentNumber[i2] = cc.orderedNumber;
        }
        return new ConnectedComponentsComputationResult(componentNumber, orderedComponentSizes);
    }

    public static class ConnectedComponentsComputationResult {
        private final int[] componentNumber;
        private final int[] componentSize;

        public ConnectedComponentsComputationResult(int[] componentNumber, int[] orderedComponents) {
            this.componentNumber = componentNumber;
            this.componentSize = orderedComponents;
        }

        public int[] getComponentNumber() {
            return this.componentNumber;
        }

        public int[] getComponentSize() {
            return this.componentSize;
        }
    }

    private static final class ConnectedComponent {
        private final int size;
        private int orderedNumber;

        private ConnectedComponent(int size) {
            this.size = size;
        }
    }
}

