/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.math.matrix;

import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.LUDecomposition;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.math.matrix.SparseMatrix;
import java.io.PrintStream;
import java.util.List;
import java.util.Objects;

public interface Matrix {
    public static Matrix createFromColumn(double[] c, MatrixFactory matrixFactory) {
        Objects.requireNonNull(c);
        Objects.requireNonNull(matrixFactory);
        Matrix m = matrixFactory.create(c.length, 1, c.length);
        for (int i = 0; i < c.length; ++i) {
            m.set(i, 0, c[i]);
        }
        return m;
    }

    public static Matrix createFromRow(double[] r, MatrixFactory matrixFactory) {
        Objects.requireNonNull(r);
        Objects.requireNonNull(matrixFactory);
        Matrix m = matrixFactory.create(1, r.length, r.length);
        for (int j = 0; j < r.length; ++j) {
            m.set(0, j, r[j]);
        }
        return m;
    }

    public int getRowCount();

    @Deprecated
    default public int getM() {
        return this.getRowCount();
    }

    public int getColumnCount();

    @Deprecated
    default public int getN() {
        return this.getColumnCount();
    }

    public void set(int var1, int var2, double var3);

    @Deprecated
    default public void setValue(int i, int j, double value) {
        this.set(i, j, value);
    }

    public void add(int var1, int var2, double var3);

    public Element addAndGetElement(int var1, int var2, double var3);

    public int addAndGetIndex(int var1, int var2, double var3);

    public void setAtIndex(int var1, double var2);

    public void setQuickAtIndex(int var1, double var2);

    public void addAtIndex(int var1, double var2);

    public void addQuickAtIndex(int var1, double var2);

    @Deprecated
    default public void addValue(int i, int j, double value) {
        this.add(i, j, value);
    }

    public void reset();

    public LUDecomposition decomposeLU();

    public Matrix times(Matrix var1);

    public Matrix add(Matrix var1, double var2, double var4);

    public Matrix add(Matrix var1);

    public void iterateNonZeroValue(ElementHandler var1);

    public void iterateNonZeroValueOfColumn(int var1, ElementHandler var2);

    public DenseMatrix toDense();

    public SparseMatrix toSparse();

    public Matrix to(MatrixFactory var1);

    public Matrix copy(MatrixFactory var1);

    public Matrix transpose();

    public void print(PrintStream var1, List<String> var2, List<String> var3);

    public void print(PrintStream var1);

    public static interface ElementHandler {
        public void onElement(int var1, int var2, double var3);

        @Deprecated
        default public void onValue(int i, int j, double value) {
            this.onElement(i, j, value);
        }
    }

    public static interface Element {
        public void set(double var1);

        public void add(double var1);
    }
}

