/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.math.graph;

import com.powsybl.math.graph.Traverser;
import com.powsybl.math.graph.UndirectedGraphListener;
import gnu.trove.list.array.TIntArrayList;
import java.io.PrintStream;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface UndirectedGraph<V, E> {
    public int addVertex();

    default public void addVertexIfNotPresent(int v) {
        throw new UnsupportedOperationException();
    }

    default public boolean vertexExists(int v) {
        throw new UnsupportedOperationException();
    }

    public V removeVertex(int var1);

    public int getVertexCount();

    public int addEdge(int var1, int var2, E var3);

    public E removeEdge(int var1);

    public void removeAllEdges();

    public int getEdgeCount();

    public int[] getEdges();

    public int[] getVertices();

    @Deprecated
    default public int getMaxVertex() {
        return this.getVertexCapacity();
    }

    default public int getVertexCapacity() {
        return this.getMaxVertex();
    }

    public Iterable<V> getVerticesObj();

    public Stream<V> getVertexObjectStream();

    public V getVertexObject(int var1);

    public void setVertexObject(int var1, V var2);

    public int getEdgeVertex1(int var1);

    public List<E> getEdgeObjectsConnectedToVertex(int var1);

    public Stream<E> getEdgeObjectConnectedToVertexStream(int var1);

    public List<Integer> getEdgesConnectedToVertex(int var1);

    public IntStream getEdgeConnectedToVertexStream(int var1);

    public int getEdgeVertex2(int var1);

    public void removeAllVertices();

    public Iterable<E> getEdgesObject();

    public Stream<E> getEdgeObjectStream();

    public E getEdgeObject(int var1);

    public List<E> getEdgeObjects(int var1, int var2);

    public boolean traverse(int var1, Traverser var2, boolean[] var3);

    public boolean traverse(int var1, Traverser var2);

    public boolean traverse(int[] var1, Traverser var2);

    public List<TIntArrayList> findAllPaths(int var1, Function<V, Boolean> var2, Function<E, Boolean> var3);

    public void addListener(UndirectedGraphListener<V, E> var1);

    public void removeListener(UndirectedGraphListener<V, E> var1);

    public void print(PrintStream var1, Function<V, String> var2, Function<E, String> var3);

    public void removeIsolatedVertices();
}

