/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.math.matrix;

import com.powsybl.math.matrix.Matrix;
import com.powsybl.math.matrix.MatrixException;
import com.powsybl.math.matrix.MatrixFactory;
import java.util.Objects;

public abstract class AbstractMatrix
implements Matrix {
    protected abstract int getEstimatedNonZeroValueCount();

    protected void checkBounds(int i, int j) {
        if (i < 0 || i >= this.getRowCount()) {
            throw new MatrixException("Row index out of bound [0, " + (this.getRowCount() - 1) + "]");
        }
        if (j < 0 || j >= this.getColumnCount()) {
            throw new MatrixException("Column index out of bound [0, " + (this.getColumnCount() - 1) + "]");
        }
    }

    @Override
    public Matrix copy(MatrixFactory factory) {
        Objects.requireNonNull(factory);
        Matrix matrix = factory.create(this.getRowCount(), this.getColumnCount(), this.getEstimatedNonZeroValueCount());
        this.iterateNonZeroValue(matrix::set);
        return matrix;
    }

    @Override
    public Matrix add(Matrix other) {
        return this.add(other, 1.0, 1.0);
    }

    @Override
    public Matrix times(Matrix other) {
        return this.times(other, 1.0);
    }
}

