/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.math.solver;

import com.powsybl.math.matrix.SparseMatrix;
import com.powsybl.math.solver.Kinsol;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class KinsolContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(KinsolContext.class);
    private final double[] x;
    private final SparseMatrix j;
    private final Kinsol.FunctionUpdater functionUpdater;
    private final Kinsol.JacobianUpdater jacobianUpdater;
    private final Level logLevel;

    public KinsolContext(double[] x, SparseMatrix j, Kinsol.FunctionUpdater functionUpdater, Kinsol.JacobianUpdater jacobianUpdater, Level logLevel) {
        this.x = Objects.requireNonNull(x);
        this.j = Objects.requireNonNull(j);
        this.functionUpdater = Objects.requireNonNull(functionUpdater);
        this.jacobianUpdater = Objects.requireNonNull(jacobianUpdater);
        this.logLevel = Objects.requireNonNull(logLevel);
    }

    public void logError(int errorCode, String module, String function, String message) {
        LOGGER.error("KinSol: code={}, module='{}', function='{}', message='{}'", new Object[]{errorCode, module, function, message});
    }

    public void logInfo(String module, String function, String message) {
        LOGGER.atLevel(this.logLevel).log("KinSol: module='{}', function='{}', message='{}'", new Object[]{module, function, message});
    }

    public void updateFunc(double[] f) {
        this.functionUpdater.update(this.x, f);
    }

    public void updateJac() {
        this.jacobianUpdater.update(this.x, this.j);
    }
}

