/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.math.graph;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.powsybl.commons.PowsyblException;
import com.powsybl.math.graph.TraversalType;
import com.powsybl.math.graph.TraverseResult;
import com.powsybl.math.graph.Traverser;
import com.powsybl.math.graph.UndirectedGraph;
import com.powsybl.math.graph.UndirectedGraphListener;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.linked.TIntLinkedList;
import gnu.trove.set.hash.TIntHashSet;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class UndirectedGraphImpl<V, E>
implements UndirectedGraph<V, E> {
    private static final int VERTICES_CAPACITY = 10;
    private static final int EDGES_CAPACITY = 15;
    private static final int NEIGHBORS_CAPACITY = 2;
    private final List<Vertex<V>> vertices = new ArrayList<Vertex<V>>(10);
    private final List<Edge<E>> edges = new ArrayList<Edge<E>>(15);
    private TIntArrayList[] adjacencyListCache;
    private final Lock adjacencyListCacheLock = new ReentrantLock();
    private final TIntHashSet availableVertices = new TIntHashSet();
    private final TIntLinkedList removedEdges = new TIntLinkedList();
    private final List<UndirectedGraphListener<V, E>> listeners = new CopyOnWriteArrayList<UndirectedGraphListener<V, E>>();
    private final int vertexLimit;

    public UndirectedGraphImpl(int vertexLimit) {
        if (vertexLimit < 1) {
            throw new PowsyblException("Vertex limit should be positive");
        }
        this.vertexLimit = vertexLimit;
    }

    private void checkVertex(int v) {
        if (v < 0 || v >= this.vertices.size() || this.vertices.get(v) == null) {
            throw new PowsyblException("Vertex " + v + " not found");
        }
    }

    private void checkEdge(int e) {
        if (e < 0 || e >= this.edges.size() || this.edges.get(e) == null) {
            throw new PowsyblException("Edge " + e + " not found");
        }
    }

    @Override
    public int addVertex() {
        int v;
        if (this.availableVertices.isEmpty()) {
            v = this.vertices.size();
            this.vertices.add(new Vertex());
        } else {
            v = this.availableVertices.iterator().next();
            this.availableVertices.remove(v);
            this.vertices.set(v, new Vertex());
        }
        this.invalidateAdjacencyList();
        this.notifyVertexAdded(v);
        return v;
    }

    @Override
    public void addVertexIfNotPresent(int v) {
        if (v < 0) {
            throw new PowsyblException("Invalid vertex " + v);
        }
        if (v >= this.vertexLimit) {
            throw new PowsyblException("Vertex index too high: " + v + ". Limit is " + this.vertexLimit);
        }
        if (v < this.vertices.size()) {
            if (this.availableVertices.contains(v)) {
                this.vertices.set(v, new Vertex());
                this.availableVertices.remove(v);
                this.invalidateAdjacencyList();
                this.notifyVertexAdded(v);
            }
        } else {
            for (int i = this.vertices.size(); i < v; ++i) {
                this.vertices.add(null);
                this.availableVertices.add(i);
            }
            this.vertices.add(new Vertex());
            this.invalidateAdjacencyList();
            this.notifyVertexAdded(v);
        }
    }

    @Override
    public boolean vertexExists(int v) {
        if (v < 0) {
            throw new PowsyblException("Invalid vertex " + v);
        }
        return v < this.vertices.size() && this.vertices.get(v) != null;
    }

    private V removeVertexInternal(int v) {
        V obj = this.vertices.get(v).getObject();
        if (v == this.vertices.size() - 1) {
            this.vertices.remove(v);
            this.cleanVertices(v - 1);
        } else {
            this.vertices.set(v, null);
            this.availableVertices.add(v);
        }
        this.notifyVertexRemoved(v, obj);
        return obj;
    }

    @Override
    public V removeVertex(int v) {
        this.checkVertex(v);
        for (Edge<E> e : this.edges) {
            if (e == null || e.getV1() != v && e.getV2() != v) continue;
            throw new PowsyblException("An edge is connected to vertex " + v);
        }
        V obj = this.removeVertexInternal(v);
        this.invalidateAdjacencyList();
        return obj;
    }

    private void cleanVertices(int v) {
        for (int i = v; i >= 0; --i) {
            if (!this.availableVertices.contains(i)) {
                return;
            }
            this.availableVertices.remove(i);
            this.vertices.remove(i);
        }
    }

    @Override
    public int getVertexCount() {
        return this.vertices.size() - this.availableVertices.size();
    }

    @Override
    public void removeAllVertices() {
        if (!this.edges.isEmpty()) {
            throw new PowsyblException("Cannot remove all vertices because there is still some edges in the graph");
        }
        this.vertices.clear();
        this.availableVertices.clear();
        this.invalidateAdjacencyList();
        this.notifyAllVerticesRemoved();
    }

    @Override
    public int addEdge(int v1, int v2, E obj) {
        int e;
        this.checkVertex(v1);
        this.checkVertex(v2);
        Edge<E> edge = new Edge<E>(v1, v2, obj);
        if (this.removedEdges.isEmpty()) {
            e = this.edges.size();
            this.edges.add(edge);
        } else {
            e = this.removedEdges.removeAt(0);
            this.edges.set(e, edge);
        }
        this.invalidateAdjacencyList();
        this.notifyEdgeAdded(e, obj);
        return e;
    }

    private E removeEdgeInternal(int e) {
        E obj = this.edges.get(e).getObject();
        this.notifyEdgeBeforeRemoval(e, obj);
        if (e == this.edges.size() - 1) {
            this.edges.remove(e);
        } else {
            this.edges.set(e, null);
            this.removedEdges.add(e);
        }
        this.notifyEdgeRemoved(e, obj);
        return obj;
    }

    @Override
    public E removeEdge(int e) {
        this.checkEdge(e);
        E obj = this.removeEdgeInternal(e);
        this.invalidateAdjacencyList();
        return obj;
    }

    @Override
    public void removeAllEdges() {
        Collection allEdges = this.edges.stream().filter(Objects::nonNull).map(Edge::getObject).collect(Collectors.toList());
        this.notifyAllEdgesBeforeRemoval(allEdges);
        this.edges.clear();
        this.removedEdges.clear();
        this.invalidateAdjacencyList();
        this.notifyAllEdgesRemoved(allEdges);
    }

    @Override
    public int getEdgeCount() {
        return this.edges.size() - this.removedEdges.size();
    }

    @Override
    public int[] getVertices() {
        TIntArrayList t = new TIntArrayList(this.vertices.size());
        for (int i = 0; i < this.vertices.size(); ++i) {
            if (this.vertices.get(i) == null) continue;
            t.add(i);
        }
        return t.toArray();
    }

    @Override
    public int[] getEdges() {
        TIntArrayList t = new TIntArrayList(this.getEdgeCount());
        for (int e = 0; e < this.edges.size(); ++e) {
            if (this.edges.get(e) == null) continue;
            t.add(e);
        }
        return t.toArray();
    }

    @Override
    public int getVertexCapacity() {
        return this.vertices.size();
    }

    @Override
    public Iterable<V> getVerticesObj() {
        return FluentIterable.from(this.vertices).filter(Predicates.notNull()).transform(Vertex::getObject);
    }

    @Override
    public Stream<V> getVertexObjectStream() {
        return this.vertices.stream().filter(Objects::nonNull).map(Vertex::getObject);
    }

    @Override
    public V getVertexObject(int v) {
        this.checkVertex(v);
        return this.vertices.get(v).getObject();
    }

    @Override
    public void setVertexObject(int v, V obj) {
        this.checkVertex(v);
        this.vertices.get(v).setObject(obj);
        this.notifyVertexObjectSet(v, obj);
    }

    @Override
    public int getEdgeVertex1(int e) {
        this.checkEdge(e);
        return this.edges.get(e).getV1();
    }

    @Override
    public List<E> getEdgeObjectsConnectedToVertex(int v) {
        return this.getEdgeObjectConnectedToVertexStream(v).collect(Collectors.toList());
    }

    @Override
    public Stream<E> getEdgeObjectConnectedToVertexStream(int v) {
        return this.getEdgeConnectedToVertexStream(v).mapToObj(this::getEdgeObject);
    }

    @Override
    public List<Integer> getEdgesConnectedToVertex(int v) {
        return this.getEdgeConnectedToVertexStream(v).boxed().collect(Collectors.toList());
    }

    @Override
    public IntStream getEdgeConnectedToVertexStream(int v) {
        this.checkVertex(v);
        TIntArrayList[] adjacencyList = this.getAdjacencyList();
        TIntArrayList adjacentEdges = adjacencyList[v];
        return IntStream.range(0, adjacentEdges.size()).map(arg_0 -> ((TIntArrayList)adjacentEdges).getQuick(arg_0));
    }

    @Override
    public int getEdgeVertex2(int e) {
        this.checkEdge(e);
        return this.edges.get(e).getV2();
    }

    @Override
    public Iterable<E> getEdgesObject() {
        return FluentIterable.from(this.edges).filter(Predicates.notNull()).transform(Edge::getObject);
    }

    @Override
    public Stream<E> getEdgeObjectStream() {
        return this.edges.stream().filter(Objects::nonNull).map(Edge::getObject);
    }

    @Override
    public E getEdgeObject(int e) {
        this.checkEdge(e);
        return this.edges.get(e).getObject();
    }

    @Override
    public List<E> getEdgeObjects(int v1, int v2) {
        this.checkVertex(v1);
        this.checkVertex(v2);
        ArrayList<E> edgeObjects = new ArrayList<E>(1);
        TIntArrayList[] adjacencyList = this.getAdjacencyList();
        TIntArrayList adjacentEdges = adjacencyList[v1];
        for (int i = 0; i < adjacentEdges.size(); ++i) {
            int e = adjacentEdges.getQuick(i);
            Edge<E> edge = this.edges.get(e);
            if ((edge.getV1() != v1 || edge.getV2() != v2) && (edge.getV1() != v2 || edge.getV2() != v1)) continue;
            edgeObjects.add(edge.getObject());
        }
        return edgeObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TIntArrayList[] getAdjacencyList() {
        this.adjacencyListCacheLock.lock();
        try {
            if (this.adjacencyListCache == null) {
                this.adjacencyListCache = new TIntArrayList[this.vertices.size()];
                for (int v = 0; v < this.vertices.size(); ++v) {
                    Vertex<V> vertex = this.vertices.get(v);
                    if (vertex == null) continue;
                    this.adjacencyListCache[v] = new TIntArrayList(2);
                }
                for (int e = 0; e < this.edges.size(); ++e) {
                    Edge<E> edge = this.edges.get(e);
                    if (edge == null) continue;
                    int v1 = edge.getV1();
                    int v2 = edge.getV2();
                    this.adjacencyListCache[v1].add(e);
                    this.adjacencyListCache[v2].add(e);
                }
            }
            TIntArrayList[] tIntArrayListArray = this.adjacencyListCache;
            return tIntArrayListArray;
        }
        finally {
            this.adjacencyListCacheLock.unlock();
        }
    }

    private void invalidateAdjacencyList() {
        this.adjacencyListCache = null;
    }

    private static void traverseVertex(int v, boolean[] encountered, Deque<Integer> edgesToTraverse, TIntArrayList[] adjacencyList, TraversalType traversalType) {
        encountered[v] = true;
        TIntArrayList adjacentEdges = adjacencyList[v];
        for (int i = 0; i < adjacentEdges.size(); ++i) {
            int iEdge = switch (traversalType) {
                default -> throw new IncompatibleClassChangeError();
                case TraversalType.DEPTH_FIRST -> adjacentEdges.size() - i - 1;
                case TraversalType.BREADTH_FIRST -> i;
            };
            edgesToTraverse.add(adjacentEdges.getQuick(iEdge));
        }
    }

    @Override
    public boolean traverse(int v, TraversalType traversalType, Traverser traverser, boolean[] encountered) {
        this.checkVertex(v);
        Objects.requireNonNull(traverser);
        Objects.requireNonNull(encountered);
        if (encountered.length < this.vertices.size()) {
            throw new PowsyblException("Encountered array is too small");
        }
        TIntArrayList[] adjacencyList = this.getAdjacencyList();
        boolean keepGoing = true;
        ArrayDeque<Integer> edgesToTraverse = new ArrayDeque<Integer>();
        UndirectedGraphImpl.traverseVertex(v, encountered, edgesToTraverse, adjacencyList, traversalType);
        while (!edgesToTraverse.isEmpty() && keepGoing) {
            int e;
            Edge<E> edge;
            if (encountered[(edge = this.edges.get(e = (switch (traversalType) {
                default -> throw new IncompatibleClassChangeError();
                case TraversalType.DEPTH_FIRST -> (Integer)edgesToTraverse.pollLast();
                case TraversalType.BREADTH_FIRST -> (Integer)edgesToTraverse.pollFirst();
            }))).getV1()] && encountered[edge.getV2()]) continue;
            boolean flipEdge = encountered[edge.getV2()];
            int vOrigin = flipEdge ? edge.getV2() : edge.getV1();
            int vDest = flipEdge ? edge.getV1() : edge.getV2();
            TraverseResult traverserResult = traverser.traverse(vOrigin, e, vDest);
            switch (traverserResult) {
                case CONTINUE: {
                    UndirectedGraphImpl.traverseVertex(vDest, encountered, edgesToTraverse, adjacencyList, traversalType);
                    break;
                }
                case TERMINATE_TRAVERSER: {
                    keepGoing = false;
                    break;
                }
            }
        }
        return keepGoing;
    }

    @Override
    public boolean traverse(int v, TraversalType traversalType, Traverser traverser) {
        boolean[] encountered = new boolean[this.vertices.size()];
        Arrays.fill(encountered, false);
        return this.traverse(v, traversalType, traverser, encountered);
    }

    @Override
    public boolean traverse(int[] startingVertices, TraversalType traversalType, Traverser traverser) {
        boolean[] encountered = new boolean[this.vertices.size()];
        Arrays.fill(encountered, false);
        for (int startingVertex : startingVertices) {
            if (encountered[startingVertex] || this.traverse(startingVertex, traversalType, traverser, encountered)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<TIntArrayList> findAllPaths(int from, Predicate<V> pathComplete, Predicate<? super E> pathCancelled) {
        return this.findAllPaths(from, pathComplete, pathCancelled, Comparator.comparing(TIntArrayList::size));
    }

    @Override
    public List<TIntArrayList> findAllPaths(int from, Predicate<V> pathComplete, Predicate<? super E> pathCancelled, Comparator<TIntArrayList> comparator) {
        Objects.requireNonNull(pathComplete);
        ArrayList<TIntArrayList> paths = new ArrayList<TIntArrayList>();
        BitSet encountered = new BitSet(this.vertices.size());
        TIntArrayList path = new TIntArrayList(1);
        this.findAllPaths(from, pathComplete, pathCancelled, path, encountered, paths);
        paths.sort(comparator);
        return paths;
    }

    private boolean findAllPaths(int e, int v1or2, Predicate<V> pathComplete, Predicate<? super E> pathCancelled, TIntArrayList path, BitSet encountered, List<TIntArrayList> paths) {
        if (encountered.get(v1or2)) {
            return false;
        }
        Vertex<V> obj1or2 = this.vertices.get(v1or2);
        path.add(e);
        if (Boolean.TRUE.equals(pathComplete.test(obj1or2.getObject()))) {
            paths.add(path);
            return true;
        }
        this.findAllPaths(v1or2, pathComplete, pathCancelled, path, encountered, paths);
        return false;
    }

    private void findAllPaths(int v, Predicate<V> pathComplete, Predicate<? super E> pathCancelled, TIntArrayList path, BitSet encountered, List<TIntArrayList> paths) {
        this.checkVertex(v);
        encountered.set(v, true);
        TIntArrayList[] adjacencyList = this.getAdjacencyList();
        TIntArrayList adjacentEdges = adjacencyList[v];
        for (int i = 0; i < adjacentEdges.size(); ++i) {
            BitSet encountered2;
            TIntArrayList path2;
            int e = adjacentEdges.getQuick(i);
            Edge<E> edge = this.edges.get(e);
            if (pathCancelled != null && pathCancelled.test(edge.getObject())) continue;
            int v1 = edge.getV1();
            int v2 = edge.getV2();
            if (i < adjacentEdges.size() - 1) {
                path2 = new TIntArrayList((TIntCollection)path);
                encountered2 = new BitSet(this.vertices.size());
                encountered2.or(encountered);
            } else {
                path2 = path;
                encountered2 = encountered;
            }
            if (v == v2) {
                this.findAllPaths(e, v1, pathComplete, pathCancelled, path2, encountered2, paths);
                continue;
            }
            if (v == v1) {
                this.findAllPaths(e, v2, pathComplete, pathCancelled, path2, encountered2, paths);
                continue;
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public void addListener(UndirectedGraphListener<V, E> l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(UndirectedGraphListener<V, E> l) {
        this.listeners.remove(l);
    }

    private void notifyVertexAdded(int v) {
        for (UndirectedGraphListener<V, E> l : this.listeners) {
            l.vertexAdded(v);
        }
    }

    private void notifyVertexObjectSet(int v, V obj) {
        for (UndirectedGraphListener<V, E> l : this.listeners) {
            l.vertexObjectSet(v, obj);
        }
    }

    private void notifyVertexRemoved(int v, V obj) {
        for (UndirectedGraphListener<V, E> l : this.listeners) {
            l.vertexRemoved(v, obj);
        }
    }

    private void notifyAllVerticesRemoved() {
        for (UndirectedGraphListener<V, E> l : this.listeners) {
            l.allVerticesRemoved();
        }
    }

    private void notifyEdgeAdded(int e, E obj) {
        for (UndirectedGraphListener<V, E> l : this.listeners) {
            l.edgeAdded(e, obj);
        }
    }

    private void notifyEdgeRemoved(int e, E obj) {
        for (UndirectedGraphListener<V, E> l : this.listeners) {
            l.edgeRemoved(e, obj);
        }
    }

    private void notifyEdgeBeforeRemoval(int e, E obj) {
        for (UndirectedGraphListener<V, E> l : this.listeners) {
            l.edgeBeforeRemoval(e, obj);
        }
    }

    private void notifyAllEdgesBeforeRemoval(Collection<E> obj) {
        for (UndirectedGraphListener<V, E> l : this.listeners) {
            l.allEdgesBeforeRemoval(obj);
        }
    }

    private void notifyAllEdgesRemoved(Collection<E> obj) {
        for (UndirectedGraphListener<V, E> l : this.listeners) {
            l.allEdgesRemoved(obj);
        }
    }

    @Override
    public void print(PrintStream out, Function<V, String> vertexToString, Function<E, String> edgeToString) {
        String str;
        out.append("Vertices:").append(System.lineSeparator());
        for (int v = 0; v < this.vertices.size(); ++v) {
            Vertex<V> vertex = this.vertices.get(v);
            if (vertex == null) continue;
            str = vertexToString == null ? Objects.toString(vertex.getObject()) : vertexToString.apply(vertex.getObject());
            out.append(Integer.toString(v)).append(": ").append(str).append(System.lineSeparator());
        }
        out.append("Edges:").append(System.lineSeparator());
        for (int e = 0; e < this.edges.size(); ++e) {
            Edge<E> edge = this.edges.get(e);
            if (edge == null) continue;
            str = edgeToString == null ? Objects.toString(edge.getObject()) : edgeToString.apply(edge.getObject());
            out.append(Integer.toString(e)).append(": ").append(Integer.toString(edge.getV1())).append("<->").append(Integer.toString(edge.getV2())).append(" ").append(str).append(System.lineSeparator());
        }
    }

    public void removeIsolatedVertices(int v, TIntArrayList[] adjacencyList) {
        TIntArrayList adjacentEdges;
        Vertex<V> vertex = this.vertices.get(v);
        if (vertex != null && vertex.getObject() == null && (adjacentEdges = adjacencyList[v]).isEmpty()) {
            this.removeVertexInternal(v);
            adjacencyList[v] = null;
            if (!adjacentEdges.isEmpty()) {
                int e = adjacentEdges.getQuick(0);
                this.removeDanglingEdgeAndPropagate(e, v, adjacencyList);
            }
        }
    }

    private void removeDanglingEdgeAndPropagate(int edgeToRemove, int vFrom, TIntArrayList[] adjacencyList) {
        Edge<E> edge = this.edges.get(edgeToRemove);
        int v1 = edge.getV1();
        int v2 = edge.getV2();
        int vTo = v1 == vFrom ? v2 : v1;
        this.removeEdgeInternal(edgeToRemove);
        Vertex<V> vertex = this.vertices.get(vTo);
        TIntArrayList adjacentEdges = adjacencyList[vTo];
        if (vertex == null || vertex.getObject() != null || adjacentEdges.size() > 2) {
            adjacentEdges.remove(edgeToRemove);
            return;
        }
        this.removeVertexInternal(vTo);
        adjacencyList[vTo] = null;
        if (adjacentEdges.size() == 2) {
            int otherEdgeToRemove = adjacentEdges.getQuick(0) == edgeToRemove ? adjacentEdges.getQuick(1) : adjacentEdges.getQuick(0);
            this.removeDanglingEdgeAndPropagate(otherEdgeToRemove, vTo, adjacencyList);
        }
    }

    @Override
    public void removeIsolatedVertices() {
        TIntArrayList[] adjacencyList = this.getAdjacencyList();
        for (int v = 0; v < this.vertices.size(); ++v) {
            this.removeIsolatedVertices(v, adjacencyList);
        }
    }

    private static final class Vertex<E> {
        private E object;

        private Vertex() {
        }

        public E getObject() {
            return this.object;
        }

        public void setObject(E object) {
            this.object = object;
        }
    }

    private static final class Edge<E> {
        private final int v1;
        private final int v2;
        private E object;

        private Edge(int v1, int v2, E object) {
            this.v1 = v1;
            this.v2 = v2;
            this.object = object;
        }

        public int getV1() {
            return this.v1;
        }

        public int getV2() {
            return this.v2;
        }

        public E getObject() {
            return this.object;
        }

        public void setObject(E object) {
            this.object = object;
        }

        public String toString() {
            return this.object.toString();
        }
    }
}

