/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.math.matrix;

import com.google.common.base.Stopwatch;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.LUDecomposition;
import com.powsybl.math.matrix.MatrixException;
import com.powsybl.math.matrix.SparseMatrix;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SparseLUDecomposition
implements LUDecomposition {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparseLUDecomposition.class);
    static final double DEFAULT_RGROWTH_THRESHOLD = 1.0E-10;
    private final SparseMatrix matrix;
    private final String id;
    private final int valueCount;

    SparseLUDecomposition(SparseMatrix matrix) {
        this.matrix = Objects.requireNonNull(matrix);
        if (matrix.getRowCount() != matrix.getColumnCount()) {
            throw new MatrixException("matrix is not square");
        }
        this.id = UUID.randomUUID().toString();
        this.init(this.id, matrix);
        this.valueCount = this.getMatrixValueCount();
    }

    private void init(String id, SparseMatrix matrix) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.init(id, matrix.getColumnStart(), matrix.getRowIndices(), matrix.getValues());
        stopwatch.stop();
        LOGGER.debug("Sparse LU decomposition done in {} us", (Object)stopwatch.elapsed(TimeUnit.MICROSECONDS));
    }

    private int getMatrixValueCount() {
        int[] columnStart = this.matrix.getColumnStart();
        return columnStart[columnStart.length - 1];
    }

    private native void init(String var1, int[] var2, int[] var3, double[] var4);

    private native void release(String var1);

    private native double update(String var1, int[] var2, int[] var3, double[] var4, double var5);

    private native void solve(String var1, double[] var2, boolean var3);

    private native void solve2(String var1, int var2, int var3, ByteBuffer var4, boolean var5);

    private void checkMatrixStructure() {
        if (this.getMatrixValueCount() != this.valueCount) {
            throw new MatrixException("Elements have been added to the sparse matrix since initial decomposition");
        }
    }

    @Override
    public void update(boolean allowIncrementalUpdate) {
        this.checkMatrixStructure();
        Stopwatch stopwatch = Stopwatch.createStarted();
        double rgrowthThreshold = allowIncrementalUpdate ? this.matrix.getRgrowthThreshold() : 0.0;
        double rgrowth = this.update(this.id, this.matrix.getColumnStart(), this.matrix.getRowIndices(), this.matrix.getValues(), rgrowthThreshold);
        stopwatch.stop();
        LOGGER.debug("Sparse LU decomposition updated (refactor rgrowth is {}, threshold is {}) in {} us", new Object[]{rgrowth, rgrowthThreshold, stopwatch.elapsed(TimeUnit.MICROSECONDS)});
    }

    @Override
    public void solve(double[] b) {
        this.solve(this.id, b, false);
    }

    @Override
    public void solveTransposed(double[] b) {
        this.solve(this.id, b, true);
    }

    @Override
    public void solve(DenseMatrix b) {
        this.solve2(this.id, b.getRowCount(), b.getColumnCount(), b.getBuffer(), false);
    }

    @Override
    public void solveTransposed(DenseMatrix b) {
        this.solve2(this.id, b.getRowCount(), b.getColumnCount(), b.getBuffer(), true);
    }

    @Override
    public void close() {
        this.release(this.id);
    }
}

