/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.math.matrix;

import com.powsybl.commons.exceptions.UncheckedClassNotFoundException;
import com.powsybl.commons.util.trove.TDoubleArrayListHack;
import com.powsybl.commons.util.trove.TIntArrayListHack;
import com.powsybl.math.matrix.AbstractMatrix;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.DenseMatrixFactory;
import com.powsybl.math.matrix.LUDecomposition;
import com.powsybl.math.matrix.Matrix;
import com.powsybl.math.matrix.MatrixException;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.math.matrix.SparseLUDecomposition;
import com.powsybl.math.matrix.SparseMatrixFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SparseMatrix
extends AbstractMatrix
implements Serializable {
    private static final long serialVersionUID = -7810324161942335828L;
    private final int rowCount;
    private final int columnCount;
    private final int[] columnStart;
    private final int[] columnValueCount;
    private final TIntArrayListHack rowIndices;
    private final TDoubleArrayListHack values;
    private double rgrowthThreshold = 1.0E-10;
    private int currentColumn = -1;

    public SparseMatrix(int rowCount, int columnCount, int[] columnStart, int[] rowIndices, double[] values) {
        SparseMatrix.checkSize(rowCount, columnCount);
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.columnStart = Objects.requireNonNull(columnStart);
        if (columnStart.length != columnCount + 1) {
            throw new MatrixException("columnStart array length has to be columnCount + 1");
        }
        this.columnValueCount = new int[columnCount];
        this.rowIndices = new TIntArrayListHack(Objects.requireNonNull(rowIndices));
        this.values = new TDoubleArrayListHack(Objects.requireNonNull(values));
        if (rowIndices.length != values.length) {
            throw new MatrixException("rowIndices and values arrays must have the same length");
        }
        SparseMatrix.fillColumnValueCount(this.columnCount, this.columnStart, this.columnValueCount, this.values);
        this.currentColumn = columnCount - 1;
    }

    private static void fillColumnValueCount(int columnCount, int[] columnStart, int[] columnValueCount, TDoubleArrayListHack values) {
        int lastNonEmptyColumn = -1;
        for (int column = 0; column < columnCount; ++column) {
            if (columnStart[column] == -1) continue;
            if (lastNonEmptyColumn != -1) {
                columnValueCount[lastNonEmptyColumn] = columnStart[column] - columnStart[lastNonEmptyColumn];
            }
            lastNonEmptyColumn = column;
        }
        if (lastNonEmptyColumn != -1) {
            columnValueCount[lastNonEmptyColumn] = values.size() - columnStart[lastNonEmptyColumn];
        }
    }

    SparseMatrix(int rowCount, int columnCount, int estimatedValueCount) {
        SparseMatrix.checkSize(rowCount, columnCount);
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.columnStart = new int[columnCount + 1];
        this.columnValueCount = new int[columnCount];
        Arrays.fill(this.columnStart, -1);
        this.columnStart[columnCount] = 0;
        this.rowIndices = new TIntArrayListHack(estimatedValueCount);
        this.values = new TDoubleArrayListHack(estimatedValueCount);
    }

    private static void checkSize(int rowCount, int columnCount) {
        if (rowCount < 1) {
            throw new MatrixException("row count has to be strictly positive");
        }
        if (columnCount < 1) {
            throw new MatrixException("column count has to be strictly positive");
        }
    }

    public double getRgrowthThreshold() {
        return this.rgrowthThreshold;
    }

    public void setRgrowthThreshold(double rgrowthThreshold) {
        this.rgrowthThreshold = rgrowthThreshold;
    }

    public int[] getColumnStart() {
        return this.columnStart;
    }

    int[] getColumnValueCount() {
        return this.columnValueCount;
    }

    public int[] getRowIndices() {
        return this.rowIndices.getData();
    }

    public double[] getValues() {
        return this.values.getData();
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public void set(int i, int j, double value) {
        this.checkBounds(i, j);
        if (j != this.currentColumn) {
            if (j > this.currentColumn) {
                for (int k = this.currentColumn + 1; k <= j; ++k) {
                    this.columnStart[k] = this.values.size();
                }
                this.currentColumn = j;
            } else {
                throw new MatrixException("Columns have to be filled in the right order");
            }
        }
        this.values.add(value);
        this.rowIndices.add(i);
        this.columnStart[this.columnStart.length - 1] = this.values.size();
        int n = j;
        this.columnValueCount[n] = this.columnValueCount[n] + 1;
    }

    private void fillLastEmptyColumns() {
        for (int k = this.currentColumn + 1; k < this.columnCount; ++k) {
            this.columnStart[k] = this.values.size();
        }
        this.currentColumn = this.columnCount - 1;
    }

    @Override
    public void add(int i, int j, double value) {
        this.checkBounds(i, j);
        boolean startNewColumn = false;
        if (j != this.currentColumn) {
            if (j > this.currentColumn) {
                this.columnStart[j] = this.values.size();
                this.currentColumn = j;
                startNewColumn = true;
            } else {
                throw new MatrixException("Columns have to be filled in the right order");
            }
        }
        if (!startNewColumn && i == this.rowIndices.get(this.rowIndices.size() - 1)) {
            int vi = this.values.size() - 1;
            this.values.setQuick(vi, this.values.getQuick(vi) + value);
        } else {
            this.values.add(value);
            this.rowIndices.add(i);
            this.columnStart[this.columnStart.length - 1] = this.values.size();
            int n = j;
            this.columnValueCount[n] = this.columnValueCount[n] + 1;
        }
    }

    @Override
    public Matrix.Element addAndGetElement(int i, int j, double value) {
        this.add(i, j, value);
        return new SparseElement(this.values.size() - 1);
    }

    @Override
    public int addAndGetIndex(int i, int j, double value) {
        this.add(i, j, value);
        return this.values.size() - 1;
    }

    private void checkElementIndex(int index) {
        if (index < 0 || index >= this.values.size()) {
            throw new MatrixException("Element index out of bound [0, " + (this.values.size() - 1) + "]");
        }
    }

    @Override
    public void setAtIndex(int index, double value) {
        this.checkElementIndex(index);
        this.setQuickAtIndex(index, value);
    }

    @Override
    public void setQuickAtIndex(int index, double value) {
        this.values.set(index, value);
    }

    @Override
    public void addAtIndex(int index, double value) {
        this.checkElementIndex(index);
        this.addQuickAtIndex(index, value);
    }

    @Override
    public void addQuickAtIndex(int index, double value) {
        this.values.setQuick(index, this.values.getQuick(index) + value);
    }

    @Override
    public void reset() {
        this.values.fill(0.0);
    }

    @Override
    public LUDecomposition decomposeLU() {
        this.fillLastEmptyColumns();
        return new SparseLUDecomposition(this);
    }

    private native SparseMatrix times(int var1, int var2, int[] var3, int[] var4, double[] var5, int var6, int var7, int[] var8, int[] var9, double[] var10);

    private native SparseMatrix add(int var1, int var2, int[] var3, int[] var4, double[] var5, int var6, int var7, int[] var8, int[] var9, double[] var10, double var11, double var13);

    public SparseMatrix times(SparseMatrix other) {
        Objects.requireNonNull(other);
        this.fillLastEmptyColumns();
        other.fillLastEmptyColumns();
        SparseMatrix result = this.times(this.rowCount, this.columnCount, this.columnStart, this.rowIndices.getData(), this.values.getData(), other.rowCount, other.columnCount, other.columnStart, other.rowIndices.getData(), other.values.getData());
        result.setRgrowthThreshold(this.rgrowthThreshold);
        return result;
    }

    public SparseMatrix times(SparseMatrix other, double scalar) {
        SparseMatrix result = this.times(other);
        result.values.transformValues(v -> v * scalar);
        return result;
    }

    @Override
    public Matrix times(Matrix other, double scalar) {
        SparseMatrix o = Objects.requireNonNull(other).toSparse();
        return this.times(o, scalar);
    }

    public SparseMatrix add(SparseMatrix other, double alpha, double beta) {
        Objects.requireNonNull(other);
        this.fillLastEmptyColumns();
        other.fillLastEmptyColumns();
        SparseMatrix result = this.add(this.rowCount, this.columnCount, this.columnStart, this.rowIndices.getData(), this.values.getData(), other.rowCount, other.columnCount, other.columnStart, other.rowIndices.getData(), other.values.getData(), alpha, beta);
        result.setRgrowthThreshold(this.rgrowthThreshold);
        return result;
    }

    @Override
    public Matrix add(Matrix other, double alpha, double beta) {
        SparseMatrix o = Objects.requireNonNull(other).toSparse();
        return this.add(o, alpha, beta);
    }

    @Override
    public void iterateNonZeroValue(Matrix.ElementHandler handler) {
        for (int j = 0; j < this.columnCount; ++j) {
            this.iterateNonZeroValueOfColumn(j, handler);
        }
    }

    @Override
    public void iterateNonZeroValueOfColumn(int j, Matrix.ElementHandler handler) {
        int first = this.columnStart[j];
        if (first != -1) {
            for (int v = first; v < first + this.columnValueCount[j]; ++v) {
                int i = this.rowIndices.getQuick(v);
                double value = this.values.getQuick(v);
                handler.onElement(i, j, value);
            }
        }
    }

    @Override
    public DenseMatrix toDense() {
        return (DenseMatrix)this.to(new DenseMatrixFactory());
    }

    @Override
    public SparseMatrix toSparse() {
        return this;
    }

    @Override
    public Matrix to(MatrixFactory factory) {
        Objects.requireNonNull(factory);
        if (factory instanceof SparseMatrixFactory) {
            return this;
        }
        return this.copy(factory);
    }

    @Override
    public int getValueCount() {
        return this.values.size();
    }

    private native SparseMatrix transpose(int var1, int var2, int[] var3, int[] var4, double[] var5);

    @Override
    public SparseMatrix transpose() {
        this.fillLastEmptyColumns();
        SparseMatrix transposed = this.transpose(this.rowCount, this.columnCount, this.columnStart, this.rowIndices.getData(), this.values.getData());
        transposed.setRgrowthThreshold(this.rgrowthThreshold);
        return transposed;
    }

    @Override
    public void print(PrintStream out) {
        this.print(out, null, null);
    }

    @Override
    public void print(PrintStream out, List<String> rowNames, List<String> columnNames) {
        out.println("rowCount=" + this.rowCount);
        out.println("columnCount=" + this.columnCount);
        out.println("columnStart=" + Arrays.toString(this.columnStart));
        out.println("columnValueCount=" + Arrays.toString(this.columnValueCount));
        out.println("rowIndices=" + this.rowIndices);
        out.println("values=" + this.values);
    }

    public int hashCode() {
        return this.rowCount + this.columnCount + Arrays.hashCode(this.columnStart) + Arrays.hashCode(this.columnValueCount) + this.rowIndices.hashCode() + this.values.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SparseMatrix) {
            SparseMatrix other = (SparseMatrix)obj;
            return this.rowCount == other.rowCount && this.columnCount == other.columnCount && Arrays.equals(this.columnStart, other.columnStart) && Arrays.equals(this.columnValueCount, other.columnValueCount) && this.rowIndices.equals((Object)other.rowIndices) && this.values.equals((Object)other.values);
        }
        return false;
    }

    public void write(OutputStream outputStream) {
        Objects.requireNonNull(outputStream);
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);){
            objectOutputStream.writeObject(this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SparseMatrix read(InputStream inputStream) {
        SparseMatrix sparseMatrix;
        Objects.requireNonNull(inputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        try {
            sparseMatrix = (SparseMatrix)objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (ClassNotFoundException e) {
                throw new UncheckedClassNotFoundException(e);
            }
        }
        objectInputStream.close();
        return sparseMatrix;
    }

    public void write(Path file) {
        Objects.requireNonNull(file);
        try (OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);){
            this.write(outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SparseMatrix read(Path file) {
        SparseMatrix sparseMatrix;
        block8: {
            Objects.requireNonNull(file);
            InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
            try {
                sparseMatrix = SparseMatrix.read(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            inputStream.close();
        }
        return sparseMatrix;
    }

    class SparseElement
    implements Matrix.Element {
        private final int valueIndex;

        SparseElement(int valueIndex) {
            this.valueIndex = valueIndex;
        }

        @Override
        public void set(double value) {
            SparseMatrix.this.values.setQuick(this.valueIndex, value);
        }

        @Override
        public void add(double value) {
            SparseMatrix.this.values.setQuick(this.valueIndex, SparseMatrix.this.values.getQuick(this.valueIndex) + value);
        }
    }
}

